/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.acquire;

import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassage;
import org.eclipse.passage.lic.licenses.model.api.FeatureGrant;

final class ProtectedGrantCapacity
implements Supplier<Integer> {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final String feature = "org.eclipse.passage.lbc.acquire.concurrent.full";
    private final FeatureGrant grant;
    private final int unlicensed = 4;

    ProtectedGrantCapacity(FeatureGrant grant) {
        this.grant = grant;
    }

    @Override
    public Integer get() {
        if (this.grant.getCapacity() < 4) {
            return this.grant.getCapacity();
        }
        if (new EquinoxPassage().canUse("org.eclipse.passage.lbc.acquire.concurrent.full")) {
            return this.grant.getCapacity();
        }
        this.reportDiminish();
        return 4;
    }

    private void reportDiminish() {
        this.log.error(String.format("Due to insufficient license coverage capacity for grant [%s] decreased to %d", this.grant(), 4));
    }

    private String grant() {
        return String.format("feature=%s, license=%s, capacity=%d", this.grant.getFeature().getIdentifier(), this.grant.getPack().getLicense().getIdentifier(), this.grant.getCapacity());
    }
}

