/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.http.ComplianceViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieCompliance
implements ComplianceViolation.Mode {
    private static final Logger LOG = LoggerFactory.getLogger(CookieCompliance.class);
    public static final CookieCompliance RFC6265 = new CookieCompliance("RFC6265", EnumSet.noneOf(Violation.class));
    public static final CookieCompliance RFC2965 = new CookieCompliance("RFC2965", EnumSet.allOf(Violation.class));
    private static final List<CookieCompliance> KNOWN_MODES = Arrays.asList(RFC6265, RFC2965);
    private static final AtomicInteger __custom = new AtomicInteger();
    private final String _name;
    private final Set<Violation> _violations;

    public static CookieCompliance valueOf(String name) {
        for (CookieCompliance compliance : KNOWN_MODES) {
            if (!compliance.getName().equals(name)) continue;
            return compliance;
        }
        return null;
    }

    public static CookieCompliance from(String spec) {
        EnumSet<Violation> violations;
        String[] elements = spec.split("\\s*,\\s*");
        switch (elements[0]) {
            case "0": {
                violations = EnumSet.noneOf(Violation.class);
                break;
            }
            case "*": {
                violations = EnumSet.allOf(Violation.class);
                break;
            }
            default: {
                CookieCompliance mode = CookieCompliance.valueOf(elements[0]);
                violations = mode == null ? EnumSet.noneOf(Violation.class) : EnumSet.copyOf(mode.getAllowed());
                break;
            }
        }
        for (int i = 1; i < elements.length; ++i) {
            String element = elements[i];
            boolean exclude = element.startsWith("-");
            if (exclude) {
                element = element.substring(1);
            }
            Violation section = Violation.valueOf(element);
            if (exclude) {
                violations.remove(section);
                continue;
            }
            violations.add(section);
        }
        CookieCompliance compliance = new CookieCompliance("CUSTOM" + __custom.getAndIncrement(), violations);
        if (LOG.isDebugEnabled()) {
            LOG.debug("CookieCompliance from {}->{}", (Object)spec, (Object)compliance);
        }
        return compliance;
    }

    private CookieCompliance(String name, Set<Violation> violations) {
        this._name = name;
        this._violations = Collections.unmodifiableSet(EnumSet.copyOf(Objects.requireNonNull(violations)));
    }

    @Override
    public boolean allows(ComplianceViolation violation) {
        return this._violations.contains(violation);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public Set<Violation> getKnown() {
        return EnumSet.allOf(Violation.class);
    }

    public Set<Violation> getAllowed() {
        return this._violations;
    }

    public static enum Violation implements ComplianceViolation
    {
        COMMA_NOT_VALID_OCTET("https://tools.ietf.org/html/rfc6265#section-4.1.1", "Comma not valid as cookie-octet or separator"),
        RESERVED_NAMES_NOT_DOLLAR_PREFIXED("https://tools.ietf.org/html/rfc6265#section-4.1.1", "Reserved names no longer use '$' prefix");

        private final String url;
        private final String description;

        private Violation(String url, String description) {
            this.url = url;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getURL() {
            return this.url;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

