/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.location;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.location.BasicLocation;
import org.eclipse.osgi.internal.location.LocationHelper;
import org.eclipse.osgi.storage.StorageUtil;

public class EquinoxLocations {
    public static final String READ_ONLY_AREA_SUFFIX = ".readOnly";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    public static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    public static final String PROP_INSTANCE_AREA_DEFAULT = "osgi.instance.area.default";
    public static final String PROP_USER_AREA = "osgi.user.area";
    public static final String PROP_USER_AREA_DEFAULT = "osgi.user.area.default";
    public static final String PROP_USER_HOME = "user.home";
    public static final String PROP_USER_DIR = "user.dir";
    public static final String PROP_HOME_LOCATION_AREA = "eclipse.home.location";
    public static final String PROP_LAUNCHER = "eclipse.launcher";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String CONFIG_DIR = "configuration";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    private static final String INSTALL_HASH_PLACEHOLDER = "@install.hash";
    private static final String INSTANCE_DATA_AREA_PREFIX = ".metadata/.plugins/";
    private final EquinoxConfiguration.ConfigValues equinoxConfig;
    private final EquinoxContainer container;
    private final AtomicBoolean debugLocations;
    private final BasicLocation installLocation;
    private final BasicLocation configurationLocation;
    private final BasicLocation userLocation;
    private final BasicLocation instanceLocation;
    private final BasicLocation eclipseHomeLocation;

    public EquinoxLocations(EquinoxConfiguration.ConfigValues equinoxConfig, EquinoxContainer container, AtomicBoolean debugLocations, Map<Throwable, Integer> exceptions) {
        String eclipseLauncher;
        String eclipseHomeLocationPath;
        URL defaultLocation;
        this.equinoxConfig = equinoxConfig;
        this.container = container;
        this.debugLocations = debugLocations;
        String osgiStorage = equinoxConfig.getConfiguration("org.osgi.framework.storage");
        if (osgiStorage != null) {
            if (equinoxConfig.getConfiguration(PROP_CONFIG_AREA) != null) {
                exceptions.put(new IllegalArgumentException(String.format("The property '%s' with the value '%s' is being overriden by the OSGi standard configuration property '%s' with the value '%s'.", PROP_CONFIG_AREA, equinoxConfig.getConfiguration(PROP_CONFIG_AREA), "org.osgi.framework.storage", osgiStorage)), 2);
            }
            equinoxConfig.setConfiguration(PROP_CONFIG_AREA, osgiStorage);
        }
        this.installLocation = this.buildLocation(PROP_INSTALL_AREA, null, "", true, false, null);
        BasicLocation temp = this.buildLocation(PROP_USER_AREA_DEFAULT, null, "", false, false, null);
        URL uRL = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null) {
            defaultLocation = EquinoxLocations.buildURL(new File(System.getProperty(PROP_USER_HOME), "user").getAbsolutePath(), true);
        }
        this.userLocation = this.buildLocation(PROP_USER_AREA, defaultLocation, "", false, false, null);
        temp = this.buildLocation(PROP_INSTANCE_AREA_DEFAULT, null, "", false, false, INSTANCE_DATA_AREA_PREFIX);
        URL uRL2 = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null) {
            defaultLocation = EquinoxLocations.buildURL(new File(System.getProperty(PROP_USER_DIR), "workspace").getAbsolutePath(), true);
        }
        this.instanceLocation = this.buildLocation(PROP_INSTANCE_AREA, defaultLocation, "", false, false, INSTANCE_DATA_AREA_PREFIX);
        this.mungeConfigurationLocation();
        temp = this.buildLocation(PROP_CONFIG_AREA_DEFAULT, null, "", false, false, null);
        URL uRL3 = defaultLocation = temp == null ? null : temp.getURL();
        if (defaultLocation == null && equinoxConfig.getConfiguration(PROP_CONFIG_AREA) == null) {
            defaultLocation = EquinoxLocations.buildURL(this.computeDefaultConfigurationLocation(), true);
        }
        this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA, defaultLocation, "", false, false, null);
        URL parentLocation = this.computeSharedConfigurationLocation();
        if (parentLocation != null && !parentLocation.equals(this.configurationLocation.getURL())) {
            BasicLocation parent = new BasicLocation(null, parentLocation, true, null, equinoxConfig, container, debugLocations);
            this.configurationLocation.setParent(parent);
        }
        if (equinoxConfig.getConfiguration(PROP_HOME_LOCATION_AREA) == null && (eclipseHomeLocationPath = EquinoxLocations.getEclipseHomeLocation(eclipseLauncher = equinoxConfig.getConfiguration(PROP_LAUNCHER), equinoxConfig)) != null) {
            equinoxConfig.setConfiguration(PROP_HOME_LOCATION_AREA, eclipseHomeLocationPath);
        }
        if (equinoxConfig.getConfiguration(PROP_HOME_LOCATION_AREA) == null && equinoxConfig.getConfiguration(PROP_INSTALL_AREA) != null) {
            equinoxConfig.setConfiguration(PROP_HOME_LOCATION_AREA, equinoxConfig.getConfiguration(PROP_INSTALL_AREA));
        }
        this.eclipseHomeLocation = this.buildLocation(PROP_HOME_LOCATION_AREA, null, "", true, true, null);
    }

    public static URL buildURL(String spec, boolean trailingSlash) {
        return LocationHelper.buildURL(spec, trailingSlash);
    }

    private void mungeConfigurationLocation() {
        String location = this.equinoxConfig.getConfiguration(PROP_CONFIG_AREA);
        if (location != null && location.endsWith(".cfg")) {
            int index = location.lastIndexOf(47);
            if (index < 0) {
                index = location.lastIndexOf(92);
            }
            location = location.substring(0, index + 1);
            this.equinoxConfig.setConfiguration(PROP_CONFIG_AREA, location);
        }
    }

    private static String getEclipseHomeLocation(String launcher, EquinoxConfiguration.ConfigValues configValues) {
        if (launcher == null) {
            return null;
        }
        File launcherFile = new File(launcher);
        if (launcherFile.getParent() == null) {
            return null;
        }
        File launcherDir = new File(launcherFile.getParent());
        String macosx = "macosx";
        if (macosx.equals(configValues.getConfiguration("osgi.os"))) {
            launcherDir = EquinoxLocations.getMacOSEclipseHomeLocation(launcherDir);
        }
        return launcherDir.exists() && launcherDir.isDirectory() ? launcherDir.getAbsolutePath() : null;
    }

    private static File getMacOSEclipseHomeLocation(File launcherDir) {
        if (!launcherDir.getName().equalsIgnoreCase("macos")) {
            return launcherDir;
        }
        return new File(launcherDir.getParent(), "Eclipse");
    }

    private BasicLocation buildLocation(String property, URL defaultLocation, String userDefaultAppendage, boolean readOnlyDefault, boolean computeReadOnly, String dataAreaPrefix) {
        String base;
        boolean readOnly;
        String location = this.equinoxConfig.clearConfiguration(property);
        String userReadOnlySetting = this.equinoxConfig.getConfiguration(String.valueOf(property) + READ_ONLY_AREA_SUFFIX);
        boolean bl = readOnly = userReadOnlySetting == null ? readOnlyDefault : Boolean.valueOf(userReadOnlySetting);
        if (location == null) {
            return new BasicLocation(property, defaultLocation, userReadOnlySetting != null || !computeReadOnly ? readOnly : !EquinoxLocations.canWrite(defaultLocation), dataAreaPrefix, this.equinoxConfig, this.container, this.debugLocations);
        }
        String trimmedLocation = location.trim();
        if (trimmedLocation.equalsIgnoreCase(NONE)) {
            return null;
        }
        if (trimmedLocation.equalsIgnoreCase(NO_DEFAULT)) {
            return new BasicLocation(property, null, readOnly, dataAreaPrefix, this.equinoxConfig, this.container, this.debugLocations);
        }
        if (trimmedLocation.startsWith(USER_HOME)) {
            base = this.substituteVar(location, USER_HOME, PROP_USER_HOME);
            location = new File(base, userDefaultAppendage).getAbsolutePath();
        } else if (trimmedLocation.startsWith(USER_DIR)) {
            base = this.substituteVar(location, USER_DIR, PROP_USER_DIR);
            location = new File(base, userDefaultAppendage).getAbsolutePath();
        }
        int idx = location.indexOf(INSTALL_HASH_PLACEHOLDER);
        if (idx == 0) {
            throw new RuntimeException("The location cannot start with '@install.hash': " + location);
        }
        if (idx > 0) {
            location = String.valueOf(location.substring(0, idx)) + this.getInstallDirHash() + location.substring(idx + INSTALL_HASH_PLACEHOLDER.length());
        }
        URL url = EquinoxLocations.buildURL(location, true);
        BasicLocation result = null;
        if (url != null) {
            result = new BasicLocation(property, null, userReadOnlySetting != null || !computeReadOnly ? readOnly : !EquinoxLocations.canWrite(url), dataAreaPrefix, this.equinoxConfig, this.container, this.debugLocations);
            result.setURL(url, false);
        }
        return result;
    }

    private String substituteVar(String source, String var, String prop) {
        String value = this.equinoxConfig.getConfiguration(prop, "");
        return String.valueOf(value) + source.substring(var.length());
    }

    private URL computeInstallConfigurationLocation() {
        String property = this.equinoxConfig.getConfiguration(PROP_INSTALL_AREA);
        if (property != null) {
            return LocationHelper.buildURL(property, true);
        }
        return null;
    }

    private URL computeSharedConfigurationLocation() {
        URL sharedConfigurationURL;
        block6: {
            String property = this.equinoxConfig.getConfiguration(PROP_SHARED_CONFIG_AREA);
            if (property == null) {
                return null;
            }
            try {
                sharedConfigurationURL = LocationHelper.buildURL(property, true);
                if (sharedConfigurationURL != null) break block6;
                return null;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (sharedConfigurationURL.getPath().startsWith("/")) {
            return sharedConfigurationURL;
        }
        URL installURL = this.installLocation.getURL();
        if (!sharedConfigurationURL.getProtocol().equals(installURL.getProtocol())) {
            return sharedConfigurationURL;
        }
        sharedConfigurationURL = new URL(installURL, sharedConfigurationURL.getPath());
        this.equinoxConfig.setConfiguration(PROP_SHARED_CONFIG_AREA, sharedConfigurationURL.toExternalForm());
        return null;
    }

    private String computeDefaultConfigurationLocation() {
        URL installURL = this.computeInstallConfigurationLocation();
        if (installURL != null && "file".equals(installURL.getProtocol())) {
            File installDir = new File(installURL.getPath());
            File defaultConfigDir = new File(installDir, CONFIG_DIR);
            if (!defaultConfigDir.exists()) {
                defaultConfigDir.mkdirs();
            }
            if (defaultConfigDir.exists() && StorageUtil.canWrite(defaultConfigDir)) {
                return defaultConfigDir.getAbsolutePath();
            }
        }
        return this.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    private static boolean canWrite(URL location) {
        if (location != null && "file".equals(location.getProtocol())) {
            File locationDir = new File(location.getPath());
            if (!locationDir.exists()) {
                locationDir.mkdirs();
            }
            if (locationDir.exists() && StorageUtil.canWrite(locationDir)) {
                return true;
            }
        }
        return false;
    }

    private String computeDefaultUserAreaLocation(String pathAppendage) {
        String installProperty = this.equinoxConfig.getConfiguration(PROP_INSTALL_AREA);
        URL installURL = EquinoxLocations.buildURL(installProperty, true);
        if (installURL == null) {
            return null;
        }
        File installDir = new File(installURL.getPath());
        String installDirHash = this.getInstallDirHash();
        String appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                String appVersion;
                props.load(new FileInputStream(eclipseProduct));
                String appId = props.getProperty(PRODUCT_SITE_ID);
                if (appId == null || appId.trim().length() == 0) {
                    appId = ECLIPSE;
                }
                if ((appVersion = props.getProperty(PRODUCT_SITE_VERSION)) == null || appVersion.trim().length() == 0) {
                    appVersion = "";
                }
                appName = String.valueOf(appName) + File.separator + appId + "_" + appVersion + "_" + installDirHash;
            }
            catch (IOException iOException) {
                appName = String.valueOf(appName) + File.separator + installDirHash;
            }
        } else {
            appName = String.valueOf(appName) + File.separator + installDirHash;
        }
        String userHome = System.getProperty(PROP_USER_HOME);
        return new File(userHome, String.valueOf(appName) + "/" + pathAppendage).getAbsolutePath();
    }

    private String getInstallDirHash() {
        int hashCode;
        String installProperty = this.equinoxConfig.getConfiguration(PROP_INSTALL_AREA);
        URL installURL = EquinoxLocations.buildURL(installProperty, true);
        if (installURL == null) {
            return "";
        }
        File installDir = new File(installURL.getPath());
        try {
            hashCode = installDir.getCanonicalPath().hashCode();
        }
        catch (IOException iOException) {
            hashCode = installDir.getAbsolutePath().hashCode();
        }
        if (hashCode < 0) {
            hashCode = -hashCode;
        }
        String installDirHash = String.valueOf(hashCode);
        return installDirHash;
    }

    public BasicLocation getUserLocation() {
        return this.userLocation;
    }

    public BasicLocation getConfigurationLocation() {
        return this.configurationLocation;
    }

    public BasicLocation getInstallLocation() {
        return this.installLocation;
    }

    public BasicLocation getInstanceLocation() {
        return this.instanceLocation;
    }

    public BasicLocation getEclipseHomeLocation() {
        return this.eclipseHomeLocation;
    }
}

