/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.oshi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.passage.lic.internal.api.inspection.EnvironmentProperty;
import org.eclipse.passage.lic.internal.base.inspection.hardware.Disk;
import org.eclipse.passage.lic.internal.base.inspection.hardware.NetworkInterface;
import org.eclipse.passage.lic.internal.oshi.EnvironmentProperties;
import org.eclipse.passage.lic.internal.oshi.FragileData;
import org.eclipse.passage.lic.internal.oshi.NetHardwareAddress;
import oshi.SystemInfo;
import oshi.hardware.HWDiskStore;
import oshi.hardware.NetworkIF;

abstract class Swath<T> {
    private final String family;
    protected final List<EnvironmentProperties> properties = new ArrayList<EnvironmentProperties>();

    Swath(String family) {
        this.family = family;
    }

    final boolean relates(String anotehr) {
        return this.family.equals(anotehr);
    }

    final int capacity() {
        return this.properties.size();
    }

    final Set<EnvironmentProperty> properties(int no) {
        return this.properties.get(no).all();
    }

    final String value(int no, EnvironmentProperty key) {
        return this.properties.get(no).get(key);
    }

    final String family() {
        return this.family;
    }

    final boolean hasValue(EnvironmentProperty property, String regexp) {
        return this.properties.stream().map(props -> Optional.ofNullable(props.get(property))).filter(Optional::isPresent).map(Optional::get).anyMatch(value -> value.matches(regexp));
    }

    final void read(SystemInfo system) {
        new FragileData<Object[]>(() -> this.source(system), this::readSource).supply();
    }

    private void readSource(T[] source) {
        Arrays.stream(source).forEach(src -> {
            boolean bl = this.properties.add(this.fillProperties(src, new EnvironmentProperties()));
        });
    }

    protected abstract T[] source(SystemInfo var1);

    protected abstract EnvironmentProperties fillProperties(T var1, EnvironmentProperties var2);

    static final class Disks
    extends Swath<HWDiskStore> {
        Disks() {
            super(new Disk.Name().family());
        }

        protected HWDiskStore[] source(SystemInfo system) {
            return system.getHardware().getDiskStores();
        }

        @Override
        protected EnvironmentProperties fillProperties(HWDiskStore source, EnvironmentProperties props) {
            props.store(() -> ((HWDiskStore)source).getName(), (EnvironmentProperty)new Disk.Name());
            props.store(() -> ((HWDiskStore)source).getModel(), (EnvironmentProperty)new Disk.Model());
            props.store(() -> ((HWDiskStore)source).getSerial(), (EnvironmentProperty)new Disk.Serial());
            return props;
        }
    }

    static final class Nets
    extends Swath<NetworkIF> {
        Nets() {
            super(new NetworkInterface.Name().family());
        }

        protected NetworkIF[] source(SystemInfo system) {
            return system.getHardware().getNetworkIFs();
        }

        @Override
        protected EnvironmentProperties fillProperties(NetworkIF source, EnvironmentProperties props) {
            props.store(() -> ((NetworkIF)source).getName(), (EnvironmentProperty)new NetworkInterface.Name());
            props.store(() -> ((NetworkIF)source).getDisplayName(), (EnvironmentProperty)new NetworkInterface.DisplayName());
            props.store(() -> ((NetworkIF)source).getMacaddr(), (EnvironmentProperty)new NetworkInterface.MacAddress());
            props.store(new NetHardwareAddress(source), (EnvironmentProperty)new NetworkInterface.HwAddress());
            return props;
        }
    }
}

