/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.frame.core.utils;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;

public class Tracer {
    static final int DEFAULT_STACK_TRACE_ELEMENT = 3;
    static boolean ERROR = false;
    static boolean WARNING = false;
    static boolean INFO = false;
    static boolean DEBUG = false;
    private String fPluginID;
    private BufferedWriter fTraceFile = null;
    private SimpleDateFormat fTimeFormat = new SimpleDateFormat("HH:mm:ss:SSS");
    private StringBuilder fTraceMessage = new StringBuilder();
    private boolean fLogToConsole = true;

    public void init(String aPluginId) {
        String traceKey = null;
        this.fPluginID = aPluginId;
        traceKey = Platform.getDebugOption((String)(String.valueOf(this.fPluginID) + "/error"));
        if (traceKey != null) {
            ERROR = Boolean.valueOf(traceKey);
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(this.fPluginID) + "/warning"))) != null) {
            WARNING = Boolean.valueOf(traceKey);
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(this.fPluginID) + "/info"))) != null) {
            INFO = Boolean.valueOf(traceKey);
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(this.fPluginID) + "/debug"))) != null) {
            DEBUG = Boolean.valueOf(traceKey);
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(this.fPluginID) + "/consoleLog"))) != null) {
            this.fLogToConsole = Boolean.valueOf(traceKey);
        }
        if ((traceKey = Platform.getDebugOption((String)(String.valueOf(this.fPluginID) + "/logfile"))) != null) {
            try {
                this.fTraceFile = new BufferedWriter(new FileWriter(traceKey));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void closeLogfile() {
        if (this.fTraceFile == null) {
            return;
        }
        try {
            this.fTraceFile.close();
            this.fTraceFile = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean setError(boolean newValue) {
        boolean oldValue = ERROR;
        ERROR = newValue;
        return oldValue;
    }

    public static boolean setDebug(boolean newValue) {
        boolean oldValue = DEBUG;
        DEBUG = newValue;
        return oldValue;
    }

    public static boolean setInfo(boolean newValue) {
        boolean oldValue = INFO;
        INFO = newValue;
        return oldValue;
    }

    public static boolean setWarning(boolean newValue) {
        boolean oldValue = WARNING;
        WARNING = newValue;
        return oldValue;
    }

    public static boolean isError() {
        return ERROR;
    }

    public static boolean isDebug() {
        return DEBUG;
    }

    public static boolean isInfo() {
        return INFO;
    }

    public static boolean isWarning() {
        return WARNING;
    }

    public void traceError(String aMsg) {
        if (ERROR) {
            this.fTraceMessage.setLength(0);
            this.writeTimestamp(this.fTraceMessage);
            this.fTraceMessage.append(" E");
            Tracer.writeThread(this.fTraceMessage);
            Tracer.writeLocation(this.fTraceMessage);
            this.fTraceMessage.append(aMsg);
            this.outputTrace(this.fTraceMessage);
        }
    }

    public void traceWarning(String aMsg) {
        if (WARNING) {
            this.fTraceMessage.setLength(0);
            this.writeTimestamp(this.fTraceMessage);
            this.fTraceMessage.append(" W");
            Tracer.writeThread(this.fTraceMessage);
            Tracer.writeLocation(this.fTraceMessage);
            this.fTraceMessage.append(aMsg);
            this.outputTrace(this.fTraceMessage);
        }
    }

    public void traceInfo(String aMsg) {
        if (INFO) {
            this.fTraceMessage.setLength(0);
            this.writeTimestamp(this.fTraceMessage);
            this.fTraceMessage.append(" I");
            Tracer.writeThread(this.fTraceMessage);
            Tracer.writeLocation(this.fTraceMessage);
            this.fTraceMessage.append(aMsg);
            this.outputTrace(this.fTraceMessage);
        }
    }

    public void traceDebug(String aMsg) {
        if (DEBUG) {
            this.fTraceMessage.setLength(0);
            this.writeTimestamp(this.fTraceMessage);
            this.fTraceMessage.append(" D");
            Tracer.writeThread(this.fTraceMessage);
            Tracer.writeLocation(this.fTraceMessage);
            this.fTraceMessage.append(aMsg);
            this.outputTrace(this.fTraceMessage);
        }
    }

    private void writeTimestamp(StringBuilder aSb) {
        aSb.append("[" + this.fTimeFormat.format(new Date()) + "]");
    }

    private static void writeThread(StringBuilder aSb) {
        aSb.append(" T=" + Thread.currentThread().getName());
    }

    private static void writeLocation(StringBuilder aSb) {
        StackTraceElement s;
        int traceElement = 3;
        StackTraceElement[] e = Thread.currentThread().getStackTrace();
        if (e != null && (s = e[traceElement = traceElement >= e.length ? e.length - 1 : traceElement]) != null) {
            String simpleClassName = s.getClassName();
            String[] clsNameSegs = simpleClassName.split("\\.");
            if (clsNameSegs.length > 0) {
                simpleClassName = clsNameSegs[clsNameSegs.length - 1];
            }
            aSb.append(" " + simpleClassName + ":" + s.getLineNumber() + " (" + s.getMethodName() + "): ");
        }
    }

    private void outputTrace(StringBuilder aSb) {
        if (this.fLogToConsole) {
            System.out.println(aSb);
        }
        if (this.fTraceFile != null) {
            try {
                this.fTraceFile.write(aSb.toString());
                this.fTraceFile.newLine();
                this.fTraceFile.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

