/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDelta;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class R4EUIContentsContainer
extends R4EUIModelElement {
    protected List<R4EUIContent> fContents;

    protected R4EUIContentsContainer(IR4EUIModelElement aParent, String aName) {
        super(aParent, aName);
        this.fReadOnly = aParent.isReadOnly();
        this.fContents = new ArrayList<R4EUIContent>();
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return this.fContents.toArray(new R4EUIContent[this.fContents.size()]);
    }

    public List<R4EUIContent> getContentsList() {
        return this.fContents;
    }

    @Override
    public boolean hasChildren() {
        return this.fContents.size() > 0;
    }

    @Override
    public void close() {
        R4EUIContent content = null;
        int contentSize = this.fContents.size();
        int i = 0;
        while (i < contentSize) {
            content = this.fContents.get(i);
            content.close();
            ++i;
        }
        this.fContents.clear();
        this.fOpen = false;
    }

    @Override
    public boolean isEnabled() {
        if (this.getParent().isEnabled()) {
            for (R4EUIContent content : this.fContents) {
                if (!content.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fContents.add((R4EUIContent)aChildToAdd);
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        R4EUIContent removedElement = this.fContents.get(this.fContents.indexOf(aChildToRemove));
        R4EDelta modelContent = removedElement.getContent();
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelContent, R4EUIModelController.getReviewer());
        modelContent.setEnabled(false);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fContents.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIContent content : this.fContents) {
            this.removeChildren(content, aFileRemove);
        }
    }

    public void verifyUserReviewed() {
        try {
            R4EUIReviewBasic review = (R4EUIReviewBasic)this.getParent().getParent().getParent();
            R4EParticipant user = review.getParticipant(R4EUIModelController.getReviewer(), false);
            if (user != null) {
                for (R4EUIContent uiContent : this.fContents) {
                    if (!user.getReviewedContent().contains((Object)uiContent.getContent().getId())) continue;
                    uiContent.setUserReviewed(true, true, false);
                }
            }
        }
        catch (ResourceHandlingException e) {
            UIUtils.displayResourceErrorDialog(e);
        }
        catch (OutOfSyncException e) {
            UIUtils.displaySyncErrorDialog(e);
        }
    }

    @Override
    public boolean isShowPropertiesCmd() {
        return false;
    }
}

