/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhaseInfo;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUser;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ReviewProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIReviewExtended
extends R4EUIReviewBasic {
    public static final String REVIEW_FORMAL_ICON_FILE = "icons/obj16/reviewfrm_obj.gif";
    public static final String REVIEW_FORMAL_CLOSED_ICON_FILE = "icons/obj16/revfrmclsd_obj.gif";
    protected static final String REVIEW_PHASE_REWORK = "REWORK";
    private static final String[] FORMAL_PHASE_VALUES = new String[]{"PLANNING", "PREPARATION", "DECISION", "REWORK", "COMPLETED"};

    public R4EUIReviewExtended(R4EUIReviewGroup aParent, R4EReview aReview, R4EReviewType aType, boolean aOpen) {
        super(aParent, aReview, aType, aOpen);
        if (aOpen) {
            this.setImage(REVIEW_FORMAL_ICON_FILE);
        } else {
            this.setImage(REVIEW_FORMAL_CLOSED_ICON_FILE);
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new ReviewProperties(this);
        }
        return null;
    }

    @Override
    public void close() {
        super.close();
        this.setImage(REVIEW_FORMAL_CLOSED_ICON_FILE);
    }

    @Override
    public void open() throws ResourceHandlingException, FileNotFoundException, CompatibilityException {
        super.open();
        this.setImage(REVIEW_FORMAL_ICON_FILE);
    }

    @Override
    public boolean isNextStateElementCmd() {
        return this.isOpen() && !this.isReadOnly() && this.getNextAvailablePhases().length > 0;
    }

    @Override
    public boolean isPreviousStateElementCmd() {
        return this.isOpen() && !this.isReadOnly() && this.getPreviousPhase() != null;
    }

    @Override
    public void updatePhase(R4EReviewPhase aNewPhase) throws ResourceHandlingException, OutOfSyncException {
        R4EFormalReview formalReview = (R4EFormalReview)this.fReview;
        String owner = null;
        Long bookNum = null;
        if (formalReview.getCurrent() != null) {
            owner = formalReview.getCurrent().getPhaseOwnerID();
            bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fReview, R4EUIModelController.getReviewer());
            this.setOldPhaseData(aNewPhase, formalReview.getCurrent());
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        R4EReviewPhaseInfo newPhase = null;
        EList phases = formalReview.getPhases();
        for (R4EReviewPhaseInfo phase : phases) {
            if (!phase.getType().equals((Object)aNewPhase)) continue;
            newPhase = phase;
            break;
        }
        if (newPhase == null) {
            newPhase = R4EUIModelController.FModelExt.createR4EReviewPhaseInfo(formalReview);
        }
        bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fReview, R4EUIModelController.getReviewer());
        newPhase.setStartDate(Calendar.getInstance().getTime());
        newPhase.setType(aNewPhase);
        if (formalReview.getCurrent() == null) {
            newPhase.setPhaseOwnerID(R4EUIModelController.getReviewer());
        } else {
            newPhase.setPhaseOwnerID(owner);
        }
        formalReview.setCurrent(newPhase);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        super.updatePhase(aNewPhase);
        this.setName(String.valueOf(this.getPhaseString(aNewPhase)) + ": " + this.fReview.getName());
    }

    @Override
    public String getPhaseString(R4EReviewPhase aNewPhase) {
        if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_STARTED)) {
            return "PLANNING";
        }
        if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION)) {
            return "PREPARATION";
        }
        if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION)) {
            return "DECISION";
        }
        if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) {
            return REVIEW_PHASE_REWORK;
        }
        if (aNewPhase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) {
            return "COMPLETED";
        }
        return "";
    }

    @Override
    public R4EReviewPhase getPhaseFromString(String aNewPhase) {
        if (aNewPhase.equals("PLANNING")) {
            return R4EReviewPhase.R4E_REVIEW_PHASE_STARTED;
        }
        if (aNewPhase.equals("PREPARATION")) {
            return R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION;
        }
        if (aNewPhase.equals("DECISION")) {
            return R4EReviewPhase.R4E_REVIEW_PHASE_DECISION;
        }
        if (aNewPhase.equals(REVIEW_PHASE_REWORK)) {
            return R4EReviewPhase.R4E_REVIEW_PHASE_REWORK;
        }
        if (aNewPhase.equals("COMPLETED")) {
            return R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED;
        }
        return null;
    }

    public static String[] getFormalPhases() {
        return FORMAL_PHASE_VALUES;
    }

    @Override
    public String[] getAvailablePhases() {
        R4EReviewPhase[] phases = this.getAllowedPhases(((R4EReviewState)this.getReview().getState()).getState());
        ArrayList<String> phaseStrings = new ArrayList<String>();
        R4EReviewPhase[] r4EReviewPhaseArray = phases;
        int n = phases.length;
        int n2 = 0;
        while (n2 < n) {
            R4EReviewPhase phase = r4EReviewPhaseArray[n2];
            phaseStrings.add(this.getPhaseString(phase));
            ++n2;
        }
        return phaseStrings.toArray(new String[phaseStrings.size()]);
    }

    public String[] getNextAvailablePhases() {
        R4EReviewPhase[] phases = this.getNextAllowedPhases(((R4EReviewState)this.getReview().getState()).getState());
        ArrayList<String> phaseStrings = new ArrayList<String>();
        R4EReviewPhase[] r4EReviewPhaseArray = phases;
        int n = phases.length;
        int n2 = 0;
        while (n2 < n) {
            R4EReviewPhase phase = r4EReviewPhaseArray[n2];
            phaseStrings.add(this.getPhaseString(phase));
            ++n2;
        }
        return phaseStrings.toArray(new String[phaseStrings.size()]);
    }

    public R4EReviewPhase getPreviousPhase() {
        R4EReviewPhase currentPhase = ((R4EReviewState)this.getReview().getState()).getState();
        switch (currentPhase.getValue()) {
            case 2: {
                return R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION;
            }
            case 3: {
                return R4EReviewPhase.R4E_REVIEW_PHASE_DECISION;
            }
            case 4: {
                return R4EReviewPhase.R4E_REVIEW_PHASE_REWORK;
            }
        }
        return null;
    }

    @Override
    public int mapPhaseToIndex(R4EReviewPhase aPhase) {
        R4EReviewPhase[] phases = this.getAllowedPhases(((R4EReviewState)this.getReview().getState()).getState());
        int i = 0;
        while (i < phases.length) {
            if (phases[i].getValue() == aPhase.getValue()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public R4EReviewPhaseInfo getPhaseInfo(R4EReviewPhase aPhase) {
        for (R4EReviewPhaseInfo phase : ((R4EFormalReview)this.fReview).getPhases()) {
            if (!phase.getType().equals((Object)aPhase)) continue;
            return phase;
        }
        return null;
    }

    @Override
    protected R4EReviewPhase[] getAllowedPhases(R4EReviewPhase aCurrentPhase) {
        ArrayList<R4EReviewPhase> phases = new ArrayList<R4EReviewPhase>();
        switch (aCurrentPhase.getValue()) {
            case 0: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_STARTED);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION);
                break;
            }
            case 1: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_DECISION);
                break;
            }
            case 2: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_DECISION);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_REWORK);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
                break;
            }
            case 3: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_DECISION);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_REWORK);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
                break;
            }
            case 4: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_DECISION);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_REWORK);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
            }
        }
        return phases.toArray(new R4EReviewPhase[phases.size()]);
    }

    protected R4EReviewPhase[] getNextAllowedPhases(R4EReviewPhase aCurrentPhase) {
        ArrayList<R4EReviewPhase> phases = new ArrayList<R4EReviewPhase>();
        switch (aCurrentPhase.getValue()) {
            case 0: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION);
                break;
            }
            case 1: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_DECISION);
                break;
            }
            case 2: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_REWORK);
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
                break;
            }
            case 3: {
                phases.add(R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
            }
        }
        return phases.toArray(new R4EReviewPhase[phases.size()]);
    }

    public void setOldPhaseData(R4EReviewPhase aNewPhase, R4EReviewPhaseInfo aOldPhaseInfo) {
        boolean clearOldPhaseData = false;
        switch (aNewPhase.getValue()) {
            case 0: {
                break;
            }
            case 1: {
                if (!aOldPhaseInfo.getType().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION)) break;
                clearOldPhaseData = true;
                break;
            }
            case 2: {
                if (!aOldPhaseInfo.getType().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK) && !aOldPhaseInfo.getType().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) break;
                clearOldPhaseData = true;
                break;
            }
            case 3: {
                if (!aOldPhaseInfo.getType().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) break;
                clearOldPhaseData = true;
                break;
            }
        }
        if (clearOldPhaseData) {
            aOldPhaseInfo.setPhaseOwnerID("");
            aOldPhaseInfo.setStartDate(null);
            aOldPhaseInfo.setEndDate(null);
        } else {
            aOldPhaseInfo.setEndDate(Calendar.getInstance().getTime());
        }
    }

    @Override
    public boolean validatePhaseChange(R4EReviewPhase aNextPhase, AtomicReference<String> aErrorMessage) {
        if (!R4EUIModelController.getReviewer().equals(((R4EFormalReview)this.fReview).getCurrent().getPhaseOwnerID())) {
            aErrorMessage.set("Phase cannot be changed as you are not the phase owner");
            return false;
        }
        switch (aNextPhase.getValue()) {
            case 1: {
                break;
            }
            case 2: {
                if (!((R4EFormalReview)this.fReview).getCurrent().getType().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION)) break;
                Collection users = this.fReview.getUsersMap().values();
                ArrayList<String> pendingUsers = new ArrayList<String>();
                for (R4EUser user : users) {
                    if (user.isReviewCompleted()) continue;
                    pendingUsers.add(user.getId());
                }
                if (pendingUsers.size() <= 0) break;
                aErrorMessage.set("Take note that the following reviewers did not complete the preparation phase: " + ((Object)pendingUsers).toString());
                break;
            }
            case 3: {
                if (this.checkReworkStatus(aErrorMessage)) break;
                return false;
            }
            case 4: {
                if (this.checkCompletionStatus(aErrorMessage)) break;
                return false;
            }
        }
        return true;
    }

    public boolean checkReworkStatus(AtomicReference<String> aErrorMessage) {
        if (this.fReview.getDecision() == null || this.fReview.getDecision().getValue() == null) {
            aErrorMessage.set("Phase cannot be changed to REWORK as review exit decision information is missing");
            return false;
        }
        if (this.fReview.getDecision().getValue().equals((Object)R4EDecision.R4E_REVIEW_DECISION_NONE)) {
            aErrorMessage.set("Phase cannot be changed to REWORK as review exit decision information is set to NONE");
            return false;
        }
        if (this.fReview.getDecision().getValue().equals((Object)R4EDecision.R4E_REVIEW_DECISION_REJECTED)) {
            aErrorMessage.set("Phase cannot be changed to REWORK as review exit decision information is set to REJECTED");
            return false;
        }
        AtomicReference<Object> resultMsg = new AtomicReference<Object>(null);
        boolean resultOk = true;
        StringBuilder sb = new StringBuilder();
        if (!this.fAnomalyContainer.checkReworkStatus(resultMsg)) {
            sb.append("Phase cannot be changed to REWORK as some anomalies are in the wrong state:" + R4EUIConstants.LINE_FEED);
            sb.append(resultMsg);
            resultOk = false;
        }
        for (R4EUIReviewItem item : this.fItems) {
            R4EUIFileContext[] contexts;
            R4EUIFileContext[] r4EUIFileContextArray = contexts = (R4EUIFileContext[])item.getChildren();
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                R4EUIFileContext context = r4EUIFileContextArray[n2];
                R4EUIAnomalyContainer container = context.getAnomalyContainerElement();
                if (!container.checkReworkStatus(resultMsg)) {
                    if (resultOk) {
                        sb.append("Phase cannot be changed to REWORK as some anomalies are in the wrong state:" + R4EUIConstants.LINE_FEED);
                        resultOk = false;
                    }
                    if (resultMsg != null) {
                        sb.append(resultMsg);
                    }
                }
                ++n2;
            }
        }
        if (!resultOk) {
            aErrorMessage.set(sb.toString());
            return false;
        }
        return true;
    }

    public boolean isParticipantExtraDetailsEnabled() {
        return ((R4EReviewState)this.fReview.getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_STARTED) || ((R4EReviewState)this.fReview.getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION);
    }

    public boolean isParticipantTimeSpentEnabled() {
        return !((R4EReviewState)this.fReview.getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    public boolean isPreparationDateEnabled() {
        return ((R4EReviewState)this.fReview.getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION);
    }

    public boolean isDecisionDateEnabled() {
        return ((R4EReviewState)this.fReview.getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION);
    }

    public boolean isReworkDateEnabled() {
        return ((R4EReviewState)this.fReview.getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK);
    }
}

