/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.DRModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleArea;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleViolation;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IRuleViolationInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleViolation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.RuleAreaProperties;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIRuleArea
extends R4EUIModelElement {
    public static final String RULE_AREA_ICON_FILE = "icons/obj16/rulearea_obj.gif";
    private static final String NEW_CHILD_ELEMENT_COMMAND_NAME = "New Rule Violation...";
    private static final String NEW_CHILD_ELEMENT_COMMAND_TOOLTIP = "Add a New Rule Violation to the Current Rule Area";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Rule Area";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable (and Optionally Remove) this Rule Area from its parent Rule Set";
    private static final String RESTORE_ELEMENT_COMMAND_NAME = "Restore Rule Area";
    private static final String RESTORE_ELEMENT_COMMAND_TOOLTIP = "Restore this disabled Rule Area";
    protected R4EDesignRuleArea fArea;
    private final List<R4EUIRuleViolation> fViolations;

    public R4EUIRuleArea(IR4EUIModelElement aParent, R4EDesignRuleArea aArea) {
        super(aParent, aArea.getName());
        this.fReadOnly = aParent.isReadOnly();
        this.fArea = aArea;
        this.fViolations = new ArrayList<R4EUIRuleViolation>();
        this.setImage(RULE_AREA_ICON_FILE);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new RuleAreaProperties(this);
        }
        return null;
    }

    public R4EDesignRuleArea getArea() {
        return this.fArea;
    }

    @Override
    public List<ReviewComponent> createChildModelDataElement() {
        ArrayList<ReviewComponent> tempViolations = new ArrayList<ReviewComponent>();
        IRuleViolationInputDialog dialog = R4EUIDialogFactory.getInstance().getRuleViolationInputDialog();
        int result = dialog.open();
        if (result == 0) {
            R4EDesignRuleViolation tempViolation = DRModelFactory.eINSTANCE.createR4EDesignRuleViolation();
            tempViolation.setName(dialog.getNameValue());
            tempViolations.add((ReviewComponent)tempViolation);
        }
        return tempViolations;
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return this.fViolations.toArray(new R4EUIRuleViolation[this.fViolations.size()]);
    }

    public List<R4EUIRuleViolation> getViolationList() {
        return this.fViolations;
    }

    @Override
    public boolean hasChildren() {
        return this.fViolations.size() > 0;
    }

    @Override
    public void close() {
        R4EUIRuleViolation violation = null;
        int violationSize = this.fViolations.size();
        int i = 0;
        while (i < violationSize) {
            violation = this.fViolations.get(i);
            violation.close();
            ++i;
        }
        this.fViolations.clear();
        this.fOpen = false;
    }

    @Override
    public void open() {
        EList violations = this.fArea.getViolations();
        if (violations != null) {
            R4EUIRuleViolation uiViolation = null;
            int violationSize = violations.size();
            int i = 0;
            while (i < violationSize) {
                if (((R4EDesignRuleViolation)violations.get(i)).isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                    uiViolation = new R4EUIRuleViolation((IR4EUIModelElement)this, (R4EDesignRuleViolation)violations.get(i));
                    this.addChildren(uiViolation);
                    if (uiViolation.isEnabled()) {
                        uiViolation.open();
                    }
                }
                ++i;
            }
        }
        this.fOpen = true;
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fArea, R4EUIModelController.getReviewer());
        this.fArea.setEnabled(true);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    @Override
    public boolean isEnabled() {
        return this.fArea.isEnabled();
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fViolations.add((R4EUIRuleViolation)aChildToAdd);
    }

    @Override
    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        R4EDesignRuleViolation violation = R4EUIModelController.FModelExt.createR4EDesignRuleViolation(this.fArea);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)violation, R4EUIModelController.getReviewer());
        violation.setName(((R4EDesignRuleViolation)aModelComponent).getName());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EUIRuleViolation addedChild = new R4EUIRuleViolation((IR4EUIModelElement)this, violation);
        this.addChildren(addedChild);
        return addedChild;
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        R4EUIRuleViolation removedElement = this.fViolations.get(this.fViolations.indexOf(aChildToRemove));
        R4EDesignRuleViolation modelViolation = removedElement.getViolation();
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelViolation, R4EUIModelController.getReviewer());
        modelViolation.setEnabled(false);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fViolations.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIRuleViolation area : this.fViolations) {
            this.removeChildren(area, aFileRemove);
        }
    }

    @Override
    public boolean isNewChildElementCmd() {
        return this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getNewChildElementCmdName() {
        return NEW_CHILD_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getNewChildElementCmdTooltip() {
        return NEW_CHILD_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRemoveElementCmd() {
        return this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRestoreElementCmd() {
        return !this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getRestoreElementCmdName() {
        return RESTORE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRestoreElementCmdTooltip() {
        return RESTORE_ELEMENT_COMMAND_TOOLTIP;
    }
}

