/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.navigator;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.EditorProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRootElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleSet;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.LineViewerSorter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorActionGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorContentProvider;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorTreeViewer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.preferences.R4EPreferencePage;
import org.eclipse.mylyn.reviews.r4e.ui.internal.sorters.DateComparator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.sorters.LinePositionComparator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ReviewNavigatorView
extends ViewPart
implements IMenuListener,
IEclipsePreferences.IPreferenceChangeListener,
ITabbedPropertySheetPageContributor,
IPropertyListener {
    private ReviewNavigatorTreeViewer fReviewTreeViewer = null;
    private Menu fContextMenu = null;
    private ActionGroup fActionSet = null;
    private boolean fEditorLinked;
    private boolean fPropertiesLinked;
    protected TabbedPropertySheetPage fPropertySheetPage;
    private IPartListener fPartListener = null;

    public ReviewNavigatorView() {
        R4EUIModelController.setNavigatorView(this);
    }

    public boolean isVisible() {
        IWorkbenchPage page = R4EUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            return page.isPartVisible((IWorkbenchPart)this);
        }
        return false;
    }

    public void setEditorLinked(boolean aEditorLinked) {
        this.fEditorLinked = aEditorLinked;
    }

    public boolean isEditorLinked() {
        return this.fEditorLinked;
    }

    public void setPropertiesLinked(boolean aPropertiesLinked) {
        this.fPropertiesLinked = aPropertiesLinked;
    }

    public boolean isPropertiesLinked() {
        return this.fPropertiesLinked;
    }

    public boolean isDefaultDisplay() {
        if (this.fReviewTreeViewer != null) {
            return this.fReviewTreeViewer.isDefaultDisplay();
        }
        return true;
    }

    public void dispose() {
        if (this.fPartListener != null) {
            this.getSite().getPage().removePartListener(this.fPartListener);
        }
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        if (this.fActionSet != null) {
            this.fActionSet.dispose();
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("R4ETemp");
        if (this.fPropertySheetPage != null) {
            this.fPropertySheetPage.dispose();
        }
        try {
            try {
                if (project.exists()) {
                    project.delete(true, null);
                }
            }
            catch (CoreException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                R4EUIPlugin.getDefault().logWarning("Exception: " + e.toString(), (Exception)((Object)e));
                R4EUIModelController.setActiveReview(null);
                super.dispose();
            }
        }
        finally {
            R4EUIModelController.setActiveReview(null);
            super.dispose();
        }
    }

    public void createPartControl(Composite parent) {
        R4EUIPlugin.Ftracer.traceInfo("Build Review Navigator view");
        this.fReviewTreeViewer = new ReviewNavigatorTreeViewer(parent, 66306);
        this.fReviewTreeViewer.setUseHashlookup(true);
        this.fReviewTreeViewer.getTree().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fReviewTreeViewer);
        this.fReviewTreeViewer.setContentProvider((IContentProvider)new ReviewNavigatorContentProvider());
        this.fReviewTreeViewer.setComparator(new LinePositionComparator());
        this.fReviewTreeViewer.setInput(this.getInitalInput());
        this.fReviewTreeViewer.setDefaultInput(this.fReviewTreeViewer.getInput());
        this.fReviewTreeViewer.setSorter(new LineViewerSorter());
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fReviewTreeViewer.getTree());
        this.fReviewTreeViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fReviewTreeViewer);
        site.setSelectionProvider((ISelectionProvider)this.fReviewTreeViewer);
        this.makeActions();
        this.hookListeners();
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.mylyn.reviews.r4e.ui");
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.fReviewTreeViewer.setViewTree();
        IEvaluationService evService = (IEvaluationService)this.getSite().getWorkbenchWindow().getService(IEvaluationService.class);
        evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.display.defaultDisplay");
        this.applyDefaultFilters();
        this.getTreeViewer().setComparator(null);
        IPreferenceStore store = R4EUIPlugin.getDefault().getPreferenceStore();
        store.setValue("userIdPreference", store.getString("userIdPreference").toLowerCase());
        R4EPreferencePage.populateParticipantListMap();
        R4EUIModelController.setJobInProgress(false);
    }

    public void resetInput() {
        IR4EUIModelElement[] groups = R4EUIModelController.getRootElement().getChildren();
        ArrayList<String> openGroupNames = new ArrayList<String>();
        IR4EUIModelElement[] iR4EUIModelElementArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            IR4EUIModelElement group = iR4EUIModelElementArray[n2];
            if (group.isOpen()) {
                group.close();
                openGroupNames.add(group.getName());
            }
            ++n2;
        }
        if (this.fReviewTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.fReviewTreeViewer.setInput(this.getInitalInput());
        groups = R4EUIModelController.getRootElement().getChildren();
        block5: for (String groupName : openGroupNames) {
            IR4EUIModelElement[] iR4EUIModelElementArray2 = groups;
            int n3 = groups.length;
            int n4 = 0;
            while (n4 < n3) {
                IR4EUIModelElement group = iR4EUIModelElementArray2[n4];
                if (group.getName().equals(groupName)) {
                    try {
                        group.open();
                    }
                    catch (ResourceHandlingException e) {
                        UIUtils.displayResourceErrorDialog(e);
                    }
                    catch (FileNotFoundException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
                    }
                    catch (CompatibilityException e) {
                        UIUtils.displayCompatibilityErrorDialog(e);
                    }
                    continue block5;
                }
                ++n4;
            }
        }
    }

    public void setFocus() {
        this.fReviewTreeViewer.getControl().setFocus();
    }

    public void menuAboutToShow(IMenuManager aMenuManager) {
        this.fActionSet.setContext(new ActionContext(this.fReviewTreeViewer.getSelection()));
        this.fActionSet.fillContextMenu(aMenuManager);
        this.fActionSet.setContext(null);
    }

    public TreeViewer getTreeViewer() {
        return this.fReviewTreeViewer;
    }

    public IR4EUIModelElement getInitalInput() {
        R4EUIModelController.loadModel();
        R4EUIRootElement rootTreeNode = R4EUIModelController.getRootElement();
        rootTreeNode.getChildren();
        return rootTreeNode;
    }

    protected void hookListeners() {
        this.fReviewTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (ReviewNavigatorView.this.isPropertiesLinked()) {
                        ReviewNavigatorView.this.showProperties();
                    }
                    if (ReviewNavigatorView.this.isEditorLinked()) {
                        IR4EUIModelElement element = (IR4EUIModelElement)selection.getFirstElement();
                        while (element != null && !(element instanceof R4EUIFileContext)) {
                            element = element.getParent();
                        }
                        if (element == null) {
                            return;
                        }
                        R4EFileVersion fileVersion = ((R4EUIFileContext)element).getFileContext().getTarget();
                        if (fileVersion == null) {
                            return;
                        }
                        IResource resource = fileVersion.getResource();
                        if (resource instanceof IFile) {
                            IEditorReference[] editors;
                            IEditorReference[] iEditorReferenceArray = editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                            int n = editors.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IEditorReference editor = iEditorReferenceArray[n2];
                                try {
                                    IEditorInput input = editor.getEditorInput();
                                    if (input instanceof IFileEditorInput && ((IFileEditorInput)input).getFile().equals((Object)resource)) {
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop(editor.getPart(true));
                                        break;
                                    }
                                }
                                catch (PartInitException partInitException) {}
                                ++n2;
                            }
                        }
                    }
                }
            }
        });
        this.fReviewTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                block9: {
                    R4EUIPlugin.Ftracer.traceInfo("Double-click event received");
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    IR4EUIModelElement element = (IR4EUIModelElement)selection.getFirstElement();
                    if (element instanceof R4EUIReviewBasic || element instanceof R4EUIReviewGroup || element instanceof R4EUIRuleSet) {
                        try {
                            if (!element.isEnabled()) break block9;
                            if (element.isOpen()) {
                                ((ReviewNavigatorActionGroup)ReviewNavigatorView.this.getActionSet()).closeElementCommand();
                                break block9;
                            }
                            ((ReviewNavigatorActionGroup)ReviewNavigatorView.this.getActionSet()).openElementCommand();
                        }
                        catch (ExecutionException e) {
                            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                        }
                        catch (NotDefinedException e) {
                            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                        }
                        catch (NotEnabledException e) {
                            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                        }
                        catch (NotHandledException e) {
                            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                        }
                    } else if (ReviewNavigatorView.this.isEditorLinked()) {
                        EditorProxy.openEditor(ReviewNavigatorView.this.getSite().getPage(), (ISelection)selection, false);
                    }
                }
            }
        });
        this.fPartListener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof PropertySheet && ((PropertySheet)part).getCurrentPage() == ReviewNavigatorView.this.fPropertySheetPage) {
                    ReviewNavigatorView.this.fPropertySheetPage = null;
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                IEditorInput input;
                if (ReviewNavigatorView.this.isEditorLinked() && part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
                    IFile editorFile = ((IFileEditorInput)input).getFile();
                    R4EUIRootElement rootElement = R4EUIModelController.getRootElement();
                    IR4EUIModelElement[] iR4EUIModelElementArray = rootElement.getChildren();
                    int n = iR4EUIModelElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IR4EUIModelElement group = iR4EUIModelElementArray[n2];
                        IR4EUIModelElement[] iR4EUIModelElementArray2 = group.getChildren();
                        int n3 = iR4EUIModelElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IR4EUIModelElement review = iR4EUIModelElementArray2[n4];
                            IR4EUIModelElement[] iR4EUIModelElementArray3 = review.getChildren();
                            int n5 = iR4EUIModelElementArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IR4EUIModelElement item = iR4EUIModelElementArray3[n6];
                                IR4EUIModelElement[] iR4EUIModelElementArray4 = item.getChildren();
                                int n7 = iR4EUIModelElementArray4.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    R4EFileVersion version;
                                    final IR4EUIModelElement navigatorFile = iR4EUIModelElementArray4[n8];
                                    if (navigatorFile instanceof R4EUIFileContext && (version = ((R4EUIFileContext)navigatorFile).getFileContext().getTarget()) != null && (IFile)version.getResource() != null && ((IFile)version.getResource()).equals((Object)editorFile)) {
                                        IR4EUIModelElement selectedElement;
                                        IR4EUIModelElement fileContextElement = selectedElement = (IR4EUIModelElement)((IStructuredSelection)ReviewNavigatorView.this.fReviewTreeViewer.getSelection()).getFirstElement();
                                        while (fileContextElement != null && !(fileContextElement instanceof R4EUIFileContext)) {
                                            fileContextElement = fileContextElement.getParent();
                                        }
                                        if (fileContextElement != null && fileContextElement.equals(navigatorFile)) {
                                            return;
                                        }
                                        Display.getDefault().asyncExec(new Runnable(){

                                            public void run() {
                                                while (Display.getDefault().readAndDispatch()) {
                                                }
                                                ReviewNavigatorView.this.fReviewTreeViewer.setSelection((ISelection)new StructuredSelection((Object)navigatorFile), true);
                                            }
                                        });
                                        return;
                                    }
                                    ++n8;
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        };
        this.getSite().getPage().addPartListener(this.fPartListener);
    }

    public IViewPart showProperties() {
        IViewPart propertiesView = null;
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            propertiesView = page.findView("org.eclipse.ui.views.PropertySheet");
            if (!page.isPartVisible((IWorkbenchPart)propertiesView)) {
                if (this.fPropertySheetPage != null) {
                    this.fPropertySheetPage = null;
                }
                this.getPropertySheetPage();
                propertiesView = page.showView("org.eclipse.ui.views.PropertySheet");
            }
        }
        catch (PartInitException e) {
            R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logWarning("Exception: " + e.toString(), (Exception)((Object)e));
        }
        return propertiesView;
    }

    private void makeActions() {
        this.fActionSet = new ReviewNavigatorActionGroup(this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(actionBars);
    }

    public ActionGroup getActionSet() {
        return this.fActionSet;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("userIdPreference")) {
            IPreferenceStore store = R4EUIPlugin.getDefault().getPreferenceStore();
            R4EUIModelController.setReviewer(store.getString("userIdPreference"));
            if (this.isVisible()) {
                this.getTreeViewer().refresh();
            }
        } else if (event.getKey().equals("groupFilePathPreference")) {
            ArrayList<String> arrayList;
            List<String> list;
            Path path;
            List<R4EUIReviewGroup> groupsLoaded = Arrays.asList(R4EUIModelController.getRootElement().getGroups());
            List<String> groupsPreferencesPaths = UIUtils.parseStringList((String)event.getNewValue());
            ArrayList<String> groupsLoadedPaths = new ArrayList<String>();
            for (R4EUIReviewGroup group : groupsLoaded) {
                path = new Path(group.getGroupFile());
                groupsLoadedPaths.add(path.toOSString());
            }
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(groupsPreferencesPaths);
            result.removeAll(groupsLoadedPaths);
            ArrayList<String> groupsToLoad = new ArrayList<String>();
            for (String groupToLoad : result) {
                groupsToLoad.add(groupToLoad);
            }
            result.clear();
            result.addAll(groupsLoadedPaths);
            result.removeAll(groupsPreferencesPaths);
            ArrayList<R4EUIReviewGroup> groupsToRemove = new ArrayList<R4EUIReviewGroup>();
            for (R4EUIReviewGroup r4EUIReviewGroup : groupsLoaded) {
                for (String groupPath : result) {
                    if (!groupPath.equals((path = new Path(r4EUIReviewGroup.getGroupFile())).toOSString())) continue;
                    groupsToRemove.add(r4EUIReviewGroup);
                }
            }
            for (IR4EUIModelElement iR4EUIModelElement : groupsToRemove) {
                R4EUIModelController.getRootElement().removeChildrenFromUI(iR4EUIModelElement);
            }
            if (groupsToLoad.size() > 0 && (list = R4EUIModelController.loadReviewGroups(groupsToLoad, arrayList = new ArrayList<String>())).size() > 0) {
                UIUtils.displayFailedLoadDialog(list);
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (!ReviewNavigatorView.this.fReviewTreeViewer.getControl().isDisposed()) {
                        ReviewNavigatorView.this.fReviewTreeViewer.refresh();
                    } else {
                        R4EUIPlugin.Ftracer.traceWarning("Exception: preferenceChange() R4E Tree viewer is DISPOSED , Group path ");
                    }
                }
            });
        } else if (event.getKey().equals("ruleSetFilePathPreference")) {
            ArrayList<String> arrayList;
            List<String> list;
            Path path;
            List<R4EUIRuleSet> ruleSetsLoaded = R4EUIModelController.getRootElement().getRuleSets();
            List<String> ruleSetsPreferencesPaths = UIUtils.parseStringList((String)event.getNewValue());
            ArrayList<String> ruleSetsLoadedPaths = new ArrayList<String>();
            for (R4EUIRuleSet ruleSet : ruleSetsLoaded) {
                path = new Path(ruleSet.getRuleSetFile());
                ruleSetsLoadedPaths.add(path.toOSString());
            }
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(ruleSetsPreferencesPaths);
            result.removeAll(ruleSetsLoadedPaths);
            ArrayList<String> ruleSetsToLoad = new ArrayList<String>();
            for (String ruleSetToLoad : result) {
                ruleSetsToLoad.add(ruleSetToLoad);
            }
            result.clear();
            result.addAll(ruleSetsLoadedPaths);
            result.removeAll(ruleSetsPreferencesPaths);
            ArrayList<IR4EUIModelElement> ruleSetsToRemove = new ArrayList<IR4EUIModelElement>();
            for (IR4EUIModelElement iR4EUIModelElement : ruleSetsLoaded) {
                for (String ruleSetPath : result) {
                    if (!ruleSetPath.equals((path = new Path(((R4EUIRuleSet)iR4EUIModelElement).getRuleSetFile())).toOSString())) continue;
                    ruleSetsToRemove.add(iR4EUIModelElement);
                }
            }
            for (IR4EUIModelElement iR4EUIModelElement : ruleSetsToRemove) {
                R4EUIModelController.getRootElement().removeChildrenFromUI(iR4EUIModelElement);
            }
            if (ruleSetsToLoad.size() > 0 && (list = R4EUIModelController.loadRuleSets(ruleSetsToLoad, arrayList = new ArrayList<String>())).size() > 0) {
                UIUtils.displayFailedLoadDialog(list);
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (!ReviewNavigatorView.this.fReviewTreeViewer.getControl().isDisposed()) {
                        ReviewNavigatorView.this.fReviewTreeViewer.refresh();
                    } else {
                        R4EUIPlugin.Ftracer.traceWarning("Exception: preferenceChange() R4E Tree viewer is DISPOSED , RULES SET PATH ");
                    }
                }
            });
        } else if (event.getKey().equals("showDisabled")) {
            this.resetInput();
        }
    }

    public void applyDefaultFilters() {
        IPreferenceStore store = R4EUIPlugin.getDefault().getPreferenceStore();
        try {
            ((ReviewNavigatorActionGroup)this.fActionSet).resetAllFilterActions();
            ((ReviewNavigatorActionGroup)this.fActionSet).runReviewsCompletedFilterCommand(store.getBoolean("reviewsCompletedFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runReviewsOnlyFilterCommand(store.getBoolean("reviewsOnlyFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runReviewsMyFilterCommand(store.getBoolean("reviewsMyFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runReviewsParticipantFilterCommand(store.getString("participantFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runAssignedMyFilterCommand(store.getBoolean("assignMyFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runAssignedParticipantFilterCommand(store.getString("assignFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runUnassignedFilterCommand(store.getBoolean("unassignFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runAnomaliesFilterCommand(store.getBoolean("anomaliesFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runAnomaliesMyFilterCommand(store.getBoolean("anomaliesMyFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runReviewElemsFilterCommand(store.getBoolean("reviewItemsFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runHideRuleSetsFilterCommand(store.getBoolean("hideRuleSetsFilter"));
            ((ReviewNavigatorActionGroup)this.fActionSet).runHideDeltasFilterCommand(store.getBoolean("hideDeltasFilter"));
            this.getTreeViewer().setComparator((ViewerComparator)new DateComparator());
        }
        catch (ExecutionException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        catch (NotDefinedException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        catch (NotEnabledException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        catch (NotHandledException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public TabbedPropertySheetPage getPropertySheetPage() {
        if (this.fPropertySheetPage == null || this.fPropertySheetPage.getControl() == null || this.fPropertySheetPage.getCurrentTab() == null) {
            this.fPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return this.fPropertySheetPage;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public void propertyChanged(Object source, int propId) {
        ((ReviewNavigatorActionGroup)this.fActionSet).dialogOpenNotify();
    }

    public void updateView(final IR4EUIModelElement aElement, final int aExpandLevel) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ReviewNavigatorView.this.getSite().getPage().activate((IWorkbenchPart)R4EUIModelController.getNavigatorView());
                ReviewNavigatorView.this.fReviewTreeViewer.expandToLevel(aElement, aExpandLevel);
                ReviewNavigatorView.this.fReviewTreeViewer.refresh();
                ReviewNavigatorView.this.fReviewTreeViewer.setSelection(null);
                StructuredSelection newSelection = new StructuredSelection((Object)aElement);
                ReviewNavigatorView.this.fReviewTreeViewer.setSelection((ISelection)newSelection, true);
            }
        });
    }

    public void refreshItems() {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = R4EUIModelController.getNavigatorView().getViewSite().getActionBars().getToolBarManager().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            item.update();
            ++n2;
        }
        MenuManager menu = (MenuManager)R4EUIModelController.getNavigatorView().getViewSite().getActionBars().getMenuManager();
        menu.updateAll(true);
    }
}

