/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.sorters;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorActionGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IEvaluationService;

public class ReviewTypeSortHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Applying Review Type Sorter...";

    public Object execute(final ExecutionEvent aEvent) {
        final ISelection selection = R4EUIModelController.getNavigatorView().getTreeViewer().getSelection();
        UIJob job = new UIJob(COMMAND_MESSAGE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object element;
                boolean oldValue;
                monitor.beginTask(ReviewTypeSortHandler.COMMAND_MESSAGE, 1);
                TreeViewer viewer = R4EUIModelController.getNavigatorView().getTreeViewer();
                Object[] elements = viewer.getExpandedElements();
                ViewerComparator sorter = ((ReviewNavigatorActionGroup)R4EUIModelController.getNavigatorView().getActionSet()).getReviewTypeSorter();
                try {
                    oldValue = HandlerUtil.toggleCommandState((Command)aEvent.getCommand());
                }
                catch (ExecutionException executionException) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                if (!oldValue) {
                    R4EUIPlugin.Ftracer.traceInfo("Apply Review Type sorter to ReviewNavigator");
                    viewer.setComparator(sorter);
                } else {
                    R4EUIPlugin.Ftracer.traceInfo("Remove Review Type sorter from ReviewNavigator");
                    viewer.setComparator(null);
                }
                R4EUIModelController.getNavigatorView().getTreeViewer().setExpandedElements(elements);
                try {
                    IEvaluationService evService = (IEvaluationService)HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)aEvent).getService(IEvaluationService.class);
                    evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.sorters.AlphaSort");
                    evService.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.sorters.ReviewTypeSort");
                }
                catch (ExecutionException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IR4EUIModelElement) {
                    UIUtils.setNavigatorViewFocus((IR4EUIModelElement)element, 0);
                }
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

