/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EID;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotationText;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnomalyAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;

public class R4ECommentAnnotation
extends R4EAnnotation {
    private final R4EAnomalyAnnotation fParent;
    private final List<String> fCommentLines = new ArrayList<String>();

    public R4ECommentAnnotation(R4EUIComment aSourceComment, R4EAnomalyAnnotation aParentAnomaly) {
        super(aSourceComment, R4ECommentAnnotation.getAnnotationType(aSourceComment), aSourceComment.getComment().getUser().getId());
        this.fParent = aParentAnomaly;
        StringTokenizer st = new StringTokenizer(aSourceComment.getComment().getDescription(), R4EUIConstants.LINE_FEED);
        while (st.hasMoreElements()) {
            this.fCommentLines.add((String)st.nextElement());
        }
    }

    public IR4EUIPosition getR4EPosition() {
        return null;
    }

    public R4EID getId() {
        return ((R4EUIComment)this.fSourceElement).getComment().getId();
    }

    private static String getAnnotationType(R4EUIComment aSourceComment) {
        if (aSourceComment.isEnabled()) {
            return "org.eclipse.mylyn.reviews.r4e.ui.comment.Annotation";
        }
        return "org.eclipse.mylyn.reviews.r4e.ui.commentDisabled.Annotation";
    }

    public Object getParent() {
        return this.fParent;
    }

    public Object[] getChildren() {
        ArrayList<R4EAnnotationText> values = new ArrayList<R4EAnnotationText>();
        for (String contentLine : this.fCommentLines) {
            values.add(new R4EAnnotationText((Object)this, contentLine, null));
        }
        return values.toArray(new Object[values.size()]);
    }

    public boolean hasChildren() {
        return true;
    }
}

