/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum R4EContextType implements Enumerator
{
    R4E_UNDEFINED(4, "R4E_UNDEFINED", "R4E_UNDEFINED"),
    R4E_ADDED(0, "R4E_ADDED", "R4E_ADDED"),
    R4E_DELETED(1, "R4E_DELETED", "R4E_DELETED"),
    R4E_MODIFIED(2, "R4E_MODIFIED", "R4E_MODIFIED"),
    R4E_REPLACED(3, "R4E_REPLACED", "R4E_REPLACED");

    public static final int R4E_UNDEFINED_VALUE = 4;
    public static final int R4E_ADDED_VALUE = 0;
    public static final int R4E_DELETED_VALUE = 1;
    public static final int R4E_MODIFIED_VALUE = 2;
    public static final int R4E_REPLACED_VALUE = 3;
    private static final R4EContextType[] VALUES_ARRAY;
    public static final List<R4EContextType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new R4EContextType[]{R4E_UNDEFINED, R4E_ADDED, R4E_DELETED, R4E_MODIFIED, R4E_REPLACED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static R4EContextType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            R4EContextType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static R4EContextType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            R4EContextType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static R4EContextType get(int value) {
        switch (value) {
            case 4: {
                return R4E_UNDEFINED;
            }
            case 0: {
                return R4E_ADDED;
            }
            case 1: {
                return R4E_DELETED;
            }
            case 2: {
                return R4E_MODIFIED;
            }
            case 3: {
                return R4E_REPLACED;
            }
        }
        return null;
    }

    private R4EContextType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

