/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.report.internal.util;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.Platform;

public final class OSPLATFORM {
    private static final String FILE_PATH_SEPARATOR = File.pathSeparator;
    private static final char FILE_PATH_SEPARATOR_CHAR = File.pathSeparatorChar;
    private static final String FILE_ELEMENT_SEPARATOR = File.separator;
    private static final char FILE_ELEMENT_SEPARATOR_CHAR = File.separatorChar;
    public static final String FFILE_ELEMENT_SEPARATOR_PORTABLE = "/";
    private static final boolean IS_FILE_ELEMENT_SEPARATOR_PORTABLE = "/".equals(FILE_ELEMENT_SEPARATOR);
    public static final String FNAME = System.getProperty("os.name");
    public static final OSTYPE FTYPE = OSTYPE.resolveOSNameToOSType(FNAME);

    private OSPLATFORM() {
    }

    public static void main(String[] args) {
        for (Map.Entry<Object, Object> pair : System.getProperties().entrySet()) {
            System.out.println(pair.getKey() + " [" + pair.getValue() + "]");
        }
        System.out.println("main() OS Name [" + FNAME + "]");
        System.out.println("main() OS Type [" + (Object)((Object)FTYPE) + "]");
        System.out.println("main() Windows/Linux/Solaris " + FTYPE.isWindowsOS() + FFILE_ELEMENT_SEPARATOR_PORTABLE + FTYPE.isLinuxOS() + FFILE_ELEMENT_SEPARATOR_PORTABLE + FTYPE.isSolarisOS());
        System.out.println("main() File Path separator [" + FILE_PATH_SEPARATOR + "] char [" + FILE_PATH_SEPARATOR_CHAR + "]");
        System.out.println("main() File Element separator [" + FILE_ELEMENT_SEPARATOR + "] char [" + FILE_ELEMENT_SEPARATOR_CHAR + "] Portable " + IS_FILE_ELEMENT_SEPARATOR_PORTABLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSTYPE {
        WINDOWS{

            protected OSTYPE match(String name) {
                OSTYPE type = null;
                if (Platform.getOS().matches("win32")) {
                    type = WINDOWS;
                }
                return type;
            }
        }
        ,
        LINUX{

            protected OSTYPE match(String name) {
                OSTYPE type = null;
                if (Platform.getOS().matches("linux")) {
                    type = LINUX;
                }
                return type;
            }
        }
        ,
        SOLARIS{

            protected OSTYPE match(String name) {
                OSTYPE type = null;
                if (Platform.getOS().matches("solaris")) {
                    type = SOLARIS;
                }
                return type;
            }
        }
        ,
        MAC{

            protected OSTYPE match(String name) {
                OSTYPE type = null;
                if (Platform.getOS().matches("macosx")) {
                    type = MAC;
                }
                return type;
            }
        };


        protected abstract OSTYPE match(String var1);

        protected static OSTYPE resolveOSNameToOSType(String aName) {
            OSTYPE type = null;
            OSTYPE[] oSTYPEArray = OSTYPE.values();
            int n = oSTYPEArray.length;
            int n2 = 0;
            while (n2 < n) {
                OSTYPE t = oSTYPEArray[n2];
                type = t.match(aName);
                if (type != null) break;
                ++n2;
            }
            return type;
        }

        public boolean isWindowsOS() {
            return this == WINDOWS;
        }

        public boolean isLinuxOS() {
            return this == LINUX;
        }

        public boolean isSolarisOS() {
            return this == SOLARIS;
        }

        public boolean isMacOS() {
            return this == MAC;
        }
    }
}

