/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.DRModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleArea;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleCollection;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IRuleAreaInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleArea;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.RuleSetProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIRuleSet
extends R4EUIModelElement {
    public static final String RULE_SET_ICON_FILE = "icons/obj16/ruleset_obj.gif";
    public static final String RULE_SET_CLOSED_ICON_FILE = "icons/obj16/rulesetclsd_obj.gif";
    private static final String NEW_CHILD_ELEMENT_COMMAND_NAME = "New Rule Area...";
    private static final String NEW_CHILD_ELEMENT_COMMAND_TOOLTIP = "Add a New Rule Area to the Current Rule Set";
    private static final String OPEN_ELEMENT_COMMAND_NAME = "Open Rule Set";
    private static final String OPEN_ELEMENT_COMMAND_TOOLTIP = "Open and Load Data for this Rule Set";
    private static final String CLOSE_ELEMENT_COMMAND_NAME = "Close Rule Set";
    private static final String CLOSE_ELEMENT_COMMAND_TOOLTIP = "Close and Unload Data for this Rule Set";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Rule Set";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable (and Optionally Remove) this Rule Set";
    protected R4EDesignRuleCollection fRuleSet;
    private final URI fRuleSetFileURI;
    private final List<R4EUIRuleArea> fAreas;

    public R4EUIRuleSet(IR4EUIModelElement aParent, R4EDesignRuleCollection aRuleSet, boolean aOpen) {
        super(aParent, aRuleSet.getName());
        this.fReadOnly = false;
        this.fRuleSet = aRuleSet;
        this.fRuleSetFileURI = aRuleSet.eResource().getURI();
        this.fAreas = new ArrayList<R4EUIRuleArea>();
        this.fOpen = aOpen;
    }

    @Override
    public String getImageLocation() {
        if (this.isOpen()) {
            return RULE_SET_ICON_FILE;
        }
        return RULE_SET_CLOSED_ICON_FILE;
    }

    @Override
    public String getToolTip() {
        return "File Location: " + URI.decode((String)this.fRuleSetFileURI.devicePath());
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new RuleSetProperties(this);
        }
        return null;
    }

    public R4EDesignRuleCollection getRuleSet() {
        return this.fRuleSet;
    }

    public String getRuleSetFile() {
        return this.fRuleSetFileURI.devicePath();
    }

    @Override
    public void setModelData(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fRuleSet, R4EUIModelController.getReviewer());
        this.fRuleSet.setVersion(((R4EDesignRuleCollection)aModelComponent).getVersion());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    @Override
    public List<ReviewComponent> createChildModelDataElement() {
        ArrayList<ReviewComponent> tempAreas = new ArrayList<ReviewComponent>();
        IRuleAreaInputDialog dialog = R4EUIDialogFactory.getInstance().getRuleAreaInputDialog();
        int result = dialog.open();
        if (result == 0) {
            R4EDesignRuleArea tempArea = DRModelFactory.eINSTANCE.createR4EDesignRuleArea();
            tempArea.setName(dialog.getNameValue());
            tempAreas.add((ReviewComponent)tempArea);
        }
        return tempAreas;
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return this.fAreas.toArray(new R4EUIRuleArea[this.fAreas.size()]);
    }

    public List<R4EUIRuleArea> getAreaList() {
        return this.fAreas;
    }

    @Override
    public boolean hasChildren() {
        return this.fAreas.size() > 0;
    }

    @Override
    public void close() {
        R4EUIRuleArea area = null;
        int areaSize = this.fAreas.size();
        int i = 0;
        while (i < areaSize) {
            area = this.fAreas.get(i);
            area.close();
            ++i;
        }
        this.fAreas.clear();
        this.fOpen = false;
        this.fReadOnly = false;
        R4EUIModelController.FModelExt.closeR4EDesignRuleCollection(this.fRuleSet);
        this.fImage = UIUtils.loadIcon(RULE_SET_CLOSED_ICON_FILE);
    }

    @Override
    public void open() throws ResourceHandlingException, CompatibilityException {
        this.fRuleSet = R4EUIModelController.FModelExt.openR4EDesignRuleCollection(this.fRuleSetFileURI);
        if (this.checkCompatibility()) {
            EList areas = this.fRuleSet.getAreas();
            if (areas != null) {
                R4EUIRuleArea uiArea = null;
                int areaSize = areas.size();
                int i = 0;
                while (i < areaSize) {
                    if (((R4EDesignRuleArea)areas.get(i)).isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                        uiArea = new R4EUIRuleArea((IR4EUIModelElement)this, (R4EDesignRuleArea)areas.get(i));
                        this.addChildren(uiArea);
                        if (uiArea.isEnabled()) {
                            uiArea.open();
                        }
                    }
                    ++i;
                }
            }
            this.fOpen = true;
            this.fImage = UIUtils.loadIcon(RULE_SET_ICON_FILE);
        } else {
            R4EUIModelController.FModelExt.closeR4EDesignRuleCollection(this.fRuleSet);
        }
    }

    public boolean openReadOnly() throws ResourceHandlingException, CompatibilityException {
        this.fRuleSet = R4EUIModelController.FModelExt.openR4EDesignRuleCollection(this.fRuleSetFileURI);
        int checkResult = this.fRuleSet.getCompatibility();
        if (checkResult == -1) {
            R4EUIModelController.FModelExt.closeR4EDesignRuleCollection(this.fRuleSet);
            return false;
        }
        this.fReadOnly = true;
        EList areas = this.fRuleSet.getAreas();
        if (areas != null) {
            R4EUIRuleArea uiArea = null;
            int areaSize = areas.size();
            int i = 0;
            while (i < areaSize) {
                if (((R4EDesignRuleArea)areas.get(i)).isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                    uiArea = new R4EUIRuleArea((IR4EUIModelElement)this, (R4EDesignRuleArea)areas.get(i));
                    this.addChildren(uiArea);
                    if (uiArea.isEnabled()) {
                        uiArea.open();
                    }
                }
                ++i;
            }
        }
        this.fOpen = true;
        this.fImage = UIUtils.loadIcon(RULE_SET_ICON_FILE);
        R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
        return true;
    }

    private boolean checkCompatibility() {
        int checkResult = this.fRuleSet.getCompatibility();
        switch (checkResult) {
            case -1: {
                UIUtils.displayCompatibilityErrorDialog();
                return false;
            }
            case 1: {
                int result = UIUtils.displayCompatibilityWarningDialog(this.fRuleSet.getFragmentVersion(), this.fRuleSet.getApplicationVersion());
                switch (result) {
                    case 0: {
                        try {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fRuleSet, R4EUIModelController.getReviewer());
                            this.fRuleSet.setFragmentVersion(this.fRuleSet.getApplicationVersion());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        catch (ResourceHandlingException e) {
                            UIUtils.displayResourceErrorDialog(e);
                            return false;
                        }
                        catch (OutOfSyncException e) {
                            UIUtils.displaySyncErrorDialog(e);
                            return false;
                        }
                        this.fReadOnly = false;
                        return true;
                    }
                    case 1: {
                        this.fReadOnly = true;
                        return true;
                    }
                }
                return false;
            }
        }
        this.fReadOnly = false;
        return true;
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        this.fRuleSet = R4EUIModelController.FModelExt.openR4EDesignRuleCollection(this.fRuleSetFileURI);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fRuleSet, R4EUIModelController.getReviewer());
        this.fRuleSet.setEnabled(aEnabled);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    @Override
    public boolean isEnabled() {
        return this.fRuleSet.isEnabled();
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fAreas.add((R4EUIRuleArea)aChildToAdd);
    }

    @Override
    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        R4EDesignRuleArea area = R4EUIModelController.FModelExt.createR4EDesignRuleArea(this.fRuleSet);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)area, R4EUIModelController.getReviewer());
        area.setName(((R4EDesignRuleArea)aModelComponent).getName());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EUIRuleArea addedChild = new R4EUIRuleArea((IR4EUIModelElement)this, area);
        this.addChildren(addedChild);
        return addedChild;
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        R4EUIRuleArea removedElement = this.fAreas.get(this.fAreas.indexOf(aChildToRemove));
        R4EDesignRuleArea modelArea = removedElement.getArea();
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelArea, R4EUIModelController.getReviewer());
        modelArea.setEnabled(false);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fAreas.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIRuleArea area : this.fAreas) {
            this.removeChildren(area, aFileRemove);
        }
    }

    @Override
    public boolean isOpenElementCmd() {
        return this.isEnabled() && !this.isOpen();
    }

    @Override
    public String getOpenElementCmdName() {
        return OPEN_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getOpenElementCmdTooltip() {
        return OPEN_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isCloseElementCmd() {
        return this.isEnabled() && this.isOpen();
    }

    @Override
    public String getCloseElementCmdName() {
        return CLOSE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getCloseElementCmdTooltip() {
        return CLOSE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isNewChildElementCmd() {
        return this.isEnabled() && this.isOpen() && !this.isReadOnly();
    }

    @Override
    public String getNewChildElementCmdName() {
        return NEW_CHILD_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getNewChildElementCmdTooltip() {
        return NEW_CHILD_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRemoveElementCmd() {
        return !this.isOpen() && this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public boolean isRestoreElementCmd() {
        return !this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }
}

