/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EMeetingData;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhaseInfo;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUser;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.EditableListWidget;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.IEditableListListener;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.MailServicesProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ReviewTabPropertySection
extends ModelElementTabPropertySection
implements IEditableListListener {
    private static final String REVIEW_DETAILS_SECTION_LABEL = "Review Details";
    private static final String DECISION_SECTION_LABEL = "Decision Information";
    private static final String REVIEW_MEETING_REFRESH_TOOLTIP = "Refresh meetinmg information for mail server";
    private Text fNameText = null;
    protected CCombo fPhaseCombo = null;
    private Text fStartDateText = null;
    private Text fEndDateText = null;
    protected Text fDescriptionText = null;
    protected TableColumn fColumnPhase = null;
    protected TableColumn fColumnOwner = null;
    protected TableColumn fColumnStartDate = null;
    protected TableColumn fColumnEndDate = null;
    protected Table fPhaseTable = null;
    private CLabel fPhaseMapLabel = null;
    private TableItem fPhasePlanning = null;
    private TableItem fPhasePreparation = null;
    private TableItem fPhaseDecision = null;
    private TableItem fPhaseRework = null;
    protected CCombo fPlanningPhaseOwnerCombo = null;
    protected CCombo fPreparationPhaseOwnerCombo = null;
    protected CCombo fDecisionPhaseOwnerCombo = null;
    protected CCombo fReworkPhaseOwnerCombo = null;
    protected CCombo fProjectCombo = null;
    protected EditableListWidget fComponents = null;
    protected Text fEntryCriteriaText = null;
    protected Text fObjectivesText = null;
    protected Text fReferenceMaterialText = null;
    private ExpandableComposite fDecisionSection = null;
    protected CCombo fExitDecisionCombo = null;
    protected EditableListWidget fDecisionUsersList = null;
    protected CLabel fDecisionUsersListLabel = null;
    protected Text fDecisionTimeSpentText = null;
    protected CLabel fDecisionTimeSpentLabel = null;
    private Composite fMeetingComposite = null;
    private Button fMeetingUpdateButton = null;
    private Button fMeetingRefreshButton = null;
    protected Text fMeetingSubjectLabel = null;
    protected Text fMeetingStartTimeLabel = null;
    protected Text fMeetingDurationLabel = null;
    protected Text fMeetingLocationLabel = null;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite mainForm = widgetFactory.createFlatFormComposite(parent);
        FormData data = null;
        widgetFactory.setBorderStyle(0);
        this.fNameText = widgetFactory.createText(mainForm, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.fNameText.setEditable(false);
        this.fNameText.setToolTipText("A Name that Identifies this Review");
        this.fNameText.setLayoutData((Object)data);
        CLabel nameLabel = widgetFactory.createCLabel(mainForm, "Name: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fNameText, -5);
        data.top = new FormAttachment((Control)this.fNameText, 0, 0x1000000);
        nameLabel.setToolTipText("A Name that Identifies this Review");
        nameLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(2048);
        this.fPhaseCombo = widgetFactory.createCCombo(mainForm, 8);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fNameText, 4);
        this.fPhaseCombo.setToolTipText("The Current Review Phase.  Review Phases are used mainly for Formal Reviews");
        this.fPhaseCombo.setLayoutData((Object)data);
        this.fPhaseCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                R4EReviewPhase phase = null;
                phase = ReviewTabPropertySection.this.fProperties.getElement() instanceof R4EUIReviewExtended ? ((R4EUIReviewExtended)ReviewTabPropertySection.this.fProperties.getElement()).getPhaseFromString(ReviewTabPropertySection.this.fPhaseCombo.getText()) : ((R4EUIReviewBasic)ReviewTabPropertySection.this.fProperties.getElement()).getPhaseFromString(ReviewTabPropertySection.this.fPhaseCombo.getText());
                if (!ReviewTabPropertySection.this.fRefreshInProgress) {
                    UIUtils.changeReviewPhase(ReviewTabPropertySection.this.fProperties.getElement(), phase);
                    ReviewTabPropertySection.this.refresh();
                    R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
                }
            }
        });
        ReviewTabPropertySection.addScrollListener(this.fPhaseCombo);
        CLabel phaseLabel = widgetFactory.createCLabel(mainForm, "Phase: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fPhaseCombo, -5);
        data.top = new FormAttachment((Control)this.fPhaseCombo, 0, 0x1000000);
        phaseLabel.setToolTipText("The Current Review Phase.  Review Phases are used mainly for Formal Reviews");
        phaseLabel.setLayoutData((Object)data);
        this.fDescriptionText = widgetFactory.createText(mainForm, "", 2);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fPhaseCombo, 4);
        this.fDescriptionText.setToolTipText("A Description of the Review");
        this.fDescriptionText.setLayoutData((Object)data);
        this.fDescriptionText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress && ReviewTabPropertySection.this.fDescriptionText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewBasic)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        String newValue = ReviewTabPropertySection.this.fDescriptionText.getText().trim();
                        if (!newValue.equals(modelReview.getExtraNotes())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            modelReview.setExtraNotes(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        ReviewTabPropertySection.this.fDescriptionText.setText(newValue);
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fDescriptionText);
        CLabel descriptionLabel = widgetFactory.createCLabel(mainForm, "Description: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fDescriptionText, -5);
        data.top = new FormAttachment((Control)this.fDescriptionText, 0, 0x1000000);
        descriptionLabel.setToolTipText("A Description of the Review");
        descriptionLabel.setLayoutData((Object)data);
        this.createPhaseTable(widgetFactory, mainForm, this.createDecisionSection(widgetFactory, mainForm, this.createReviewDetailsSection(widgetFactory, mainForm)));
    }

    private Composite createReviewDetailsSection(TabbedPropertySheetWidgetFactory aWidgetFactory, final Composite aComposite) {
        ExpandableComposite reviewDetailsSection = aWidgetFactory.createExpandableComposite(aComposite, 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fDescriptionText, 4);
        reviewDetailsSection.setLayoutData((Object)data);
        reviewDetailsSection.setText(REVIEW_DETAILS_SECTION_LABEL);
        reviewDetailsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aComposite.getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aComposite.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        reviewDetailsSection.setLayout((Layout)new GridLayout(1, false));
        Composite reviewDetailsSectionClient = aWidgetFactory.createComposite((Composite)reviewDetailsSection);
        reviewDetailsSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        reviewDetailsSectionClient.setLayout((Layout)new GridLayout(4, false));
        reviewDetailsSection.setClient((Control)reviewDetailsSectionClient);
        CLabel startDateLabel = aWidgetFactory.createCLabel(reviewDetailsSectionClient, "Start Date: ");
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        startDateLabel.setToolTipText("The Start Date for this Review");
        startDateLabel.setLayoutData((Object)gridData);
        aWidgetFactory.setBorderStyle(0);
        this.fStartDateText = aWidgetFactory.createText(reviewDetailsSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fStartDateText.setEditable(false);
        this.fStartDateText.setToolTipText("The Start Date for this Review");
        this.fStartDateText.setLayoutData((Object)gridData);
        CLabel endDateLabel = aWidgetFactory.createCLabel(reviewDetailsSectionClient, "End Date: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        endDateLabel.setToolTipText("The Closing Date for this Review");
        endDateLabel.setLayoutData((Object)gridData);
        this.fEndDateText = aWidgetFactory.createText(reviewDetailsSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fEndDateText.setEditable(false);
        this.fEndDateText.setToolTipText("The Closing Date for this Review");
        this.fEndDateText.setLayoutData((Object)gridData);
        CLabel projectLabel = aWidgetFactory.createCLabel(reviewDetailsSectionClient, "Project Id: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        projectLabel.setToolTipText("The Project the Reviewed Code belongs to");
        projectLabel.setLayoutData((Object)gridData);
        aWidgetFactory.setBorderStyle(2048);
        this.fProjectCombo = aWidgetFactory.createCCombo(reviewDetailsSectionClient);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fProjectCombo.setToolTipText("The Project the Reviewed Code belongs to");
        this.fProjectCombo.setLayoutData((Object)gridData);
        this.fProjectCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewBasic)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        if (!ReviewTabPropertySection.this.fProjectCombo.getText().equals(modelReview.getProject())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            modelReview.setProject(ReviewTabPropertySection.this.fProjectCombo.getText());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
                ReviewTabPropertySection.this.refresh();
            }
        });
        ReviewTabPropertySection.addScrollListener(this.fProjectCombo);
        CLabel componentsLabel = aWidgetFactory.createCLabel(reviewDetailsSectionClient, "Components: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        componentsLabel.setToolTipText("The Components for the Elements being Reviewed");
        componentsLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fComponents = new EditableListWidget((FormToolkit)aWidgetFactory, reviewDetailsSectionClient, gridData, this, 1, CCombo.class, null);
        this.fComponents.setToolTipText("The Components for the Elements being Reviewed");
        CLabel entryCriteriaLabel = aWidgetFactory.createCLabel(reviewDetailsSectionClient, "Entry Criteria: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        entryCriteriaLabel.setToolTipText("The Entry Criteria for this Review.  This is automatically set to the Parent Review Group Default Value");
        entryCriteriaLabel.setLayoutData((Object)gridData);
        this.fEntryCriteriaText = aWidgetFactory.createText(reviewDetailsSectionClient, "", 2);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fEntryCriteriaText.setToolTipText("The Entry Criteria for this Review.  This is automatically set to the Parent Review Group Default Value");
        this.fEntryCriteriaText.setLayoutData((Object)gridData);
        this.fEntryCriteriaText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress && ReviewTabPropertySection.this.fEntryCriteriaText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewBasic)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        String newValue = ReviewTabPropertySection.this.fEntryCriteriaText.getText().trim();
                        if (!newValue.equals(modelReview.getEntryCriteria())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            modelReview.setEntryCriteria(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        ReviewTabPropertySection.this.fEntryCriteriaText.setText(newValue);
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fEntryCriteriaText);
        CLabel objectivesLabel = aWidgetFactory.createCLabel(reviewDetailsSectionClient, "Objectives: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        objectivesLabel.setToolTipText("The Objectives of this Review");
        objectivesLabel.setLayoutData((Object)gridData);
        this.fObjectivesText = aWidgetFactory.createText(reviewDetailsSectionClient, "", 2);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fObjectivesText.setToolTipText("The Objectives of this Review");
        this.fObjectivesText.setLayoutData((Object)gridData);
        this.fObjectivesText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress && ReviewTabPropertySection.this.fObjectivesText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewBasic)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        String newValue = ReviewTabPropertySection.this.fObjectivesText.getText().trim();
                        if (!newValue.equals(modelReview.getObjectives())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            modelReview.setObjectives(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        ReviewTabPropertySection.this.fObjectivesText.setText(newValue);
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fObjectivesText);
        CLabel referenceMaterialLabel = aWidgetFactory.createCLabel(reviewDetailsSectionClient, "Reference Material: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        referenceMaterialLabel.setToolTipText("The Reference Materials to be used for This Review");
        referenceMaterialLabel.setLayoutData((Object)gridData);
        this.fReferenceMaterialText = aWidgetFactory.createText(reviewDetailsSectionClient, "", 2);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fReferenceMaterialText.setToolTipText("The Reference Materials to be used for This Review");
        this.fReferenceMaterialText.setLayoutData((Object)gridData);
        this.fReferenceMaterialText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress && ReviewTabPropertySection.this.fReferenceMaterialText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewBasic)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        String newValue = ReviewTabPropertySection.this.fReferenceMaterialText.getText().trim();
                        if (!newValue.equals(modelReview.getReferenceMaterial())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            modelReview.setReferenceMaterial(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        ReviewTabPropertySection.this.fReferenceMaterialText.setText(newValue);
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fReferenceMaterialText);
        return reviewDetailsSection;
    }

    private Composite createDecisionSection(TabbedPropertySheetWidgetFactory aWidgetFactory, final Composite aComposite, Composite aTopComposite) {
        this.fDecisionSection = aWidgetFactory.createExpandableComposite(aComposite, 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)aTopComposite, 4);
        this.fDecisionSection.setLayoutData((Object)data);
        this.fDecisionSection.setText(DECISION_SECTION_LABEL);
        this.fDecisionSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aComposite.getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aComposite.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        this.fDecisionSection.setLayout((Layout)new GridLayout(1, false));
        Composite decisionSectionClient = aWidgetFactory.createComposite((Composite)this.fDecisionSection);
        decisionSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        decisionSectionClient.setLayout((Layout)new GridLayout(4, false));
        this.fDecisionSection.setClient((Control)decisionSectionClient);
        CLabel meetingInfoLabel = aWidgetFactory.createCLabel(decisionSectionClient, "Meeting: ");
        meetingInfoLabel.setToolTipText("The Review Decision Meeting Details, as sent in the Meeting Request Email");
        meetingInfoLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fMeetingComposite = aWidgetFactory.createComposite(decisionSectionClient, 2048);
        GridData textGridData = new GridData(4, 4, true, true);
        textGridData.horizontalSpan = 3;
        this.fMeetingComposite.setLayoutData((Object)textGridData);
        this.fMeetingComposite.setLayout((Layout)new GridLayout(4, false));
        CLabel meetingSubjectLabel = aWidgetFactory.createCLabel(this.fMeetingComposite, "Subject: ");
        meetingSubjectLabel.setToolTipText("The Review Decision Meeting Subject, as sent in the Meeting Request Email");
        meetingSubjectLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        aWidgetFactory.setBorderStyle(0);
        this.fMeetingSubjectLabel = aWidgetFactory.createText(this.fMeetingComposite, "", 0);
        textGridData = new GridData(4, 0x1000000, false, false);
        textGridData.horizontalSpan = 2;
        this.fMeetingSubjectLabel.setEditable(false);
        this.fMeetingSubjectLabel.setToolTipText("The Review Decision Meeting Subject, as sent in the Meeting Request Email");
        this.fMeetingSubjectLabel.setLayoutData((Object)textGridData);
        this.fMeetingUpdateButton = aWidgetFactory.createButton(this.fMeetingComposite, "Create...", 8);
        this.fMeetingUpdateButton.setToolTipText("Update Meeting Details and re-send the New Meeting Request Email");
        this.fMeetingUpdateButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fMeetingUpdateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MailServicesProxy.sendMeetingRequest();
                    ReviewTabPropertySection.this.refresh();
                    R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
                }
                catch (ResourceHandlingException e1) {
                    UIUtils.displayResourceErrorDialog(e1);
                }
                catch (OutOfSyncException e1) {
                    UIUtils.displaySyncErrorDialog(e1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        CLabel meetingStartTimeLabel = aWidgetFactory.createCLabel(this.fMeetingComposite, "Starts: ");
        meetingStartTimeLabel.setToolTipText("The Review Decision Meeting Time, as sent in the Meeting Request Email");
        meetingStartTimeLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fMeetingStartTimeLabel = aWidgetFactory.createText(this.fMeetingComposite, "", 0);
        textGridData = new GridData(4, 0x1000000, false, false);
        textGridData.horizontalSpan = 2;
        this.fMeetingStartTimeLabel.setEditable(false);
        this.fMeetingStartTimeLabel.setToolTipText("The Review Decision Meeting Time, as sent in the Meeting Request Email");
        this.fMeetingStartTimeLabel.setLayoutData((Object)textGridData);
        this.fMeetingRefreshButton = aWidgetFactory.createButton(this.fMeetingComposite, "Refresh", 8);
        this.fMeetingRefreshButton.setToolTipText(REVIEW_MEETING_REFRESH_TOOLTIP);
        this.fMeetingRefreshButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fMeetingRefreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ((R4EUIReviewBasic)ReviewTabPropertySection.this.fProperties.getElement()).refreshMeetingData();
                    ReviewTabPropertySection.this.refresh();
                    R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
                }
                catch (OutOfSyncException ex) {
                    UIUtils.displaySyncErrorDialog(ex);
                }
                catch (ResourceHandlingException ex) {
                    UIUtils.displayResourceErrorDialog(ex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        CLabel meetingDurationLabel = aWidgetFactory.createCLabel(this.fMeetingComposite, "Duration (minutes): ");
        meetingDurationLabel.setToolTipText("The Review Decision Meeting Duration, as sent in the Meeting Request Email");
        meetingDurationLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fMeetingDurationLabel = aWidgetFactory.createText(this.fMeetingComposite, "", 0);
        textGridData = new GridData(4, 0x1000000, false, false);
        textGridData.horizontalSpan = 2;
        this.fMeetingDurationLabel.setEditable(false);
        this.fMeetingDurationLabel.setToolTipText("The Review Decision Meeting Duration, as sent in the Meeting Request Email");
        this.fMeetingDurationLabel.setLayoutData((Object)textGridData);
        aWidgetFactory.createCLabel(this.fMeetingComposite, "");
        CLabel meetingLocationLabel = aWidgetFactory.createCLabel(this.fMeetingComposite, "Location: ");
        meetingLocationLabel.setToolTipText("The Review Decision Meeting Location, as sent in the Meeting Request Email");
        meetingLocationLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fMeetingLocationLabel = aWidgetFactory.createText(this.fMeetingComposite, "", 0);
        textGridData = new GridData(4, 0x1000000, true, false);
        textGridData.horizontalSpan = 2;
        this.fMeetingLocationLabel.setEditable(false);
        this.fMeetingLocationLabel.setToolTipText("The Review Decision Meeting Location, as sent in the Meeting Request Email");
        this.fMeetingLocationLabel.setLayoutData((Object)textGridData);
        aWidgetFactory.createCLabel(this.fMeetingComposite, "");
        CLabel exitDecisionLabel = aWidgetFactory.createCLabel(decisionSectionClient, "Exit Decision: ");
        exitDecisionLabel.setToolTipText("The Exit Decision for this Review");
        exitDecisionLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        aWidgetFactory.setBorderStyle(2048);
        this.fExitDecisionCombo = aWidgetFactory.createCCombo(decisionSectionClient, 8);
        textGridData = new GridData(4, 0x1000000, true, false);
        textGridData.horizontalSpan = 3;
        this.fExitDecisionCombo.setToolTipText("The Exit Decision for this Review");
        this.fExitDecisionCombo.setLayoutData((Object)textGridData);
        this.fExitDecisionCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewBasic)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        R4EReviewDecision newDecision = R4EUIReviewBasic.getDecisionValueFromString(ReviewTabPropertySection.this.fExitDecisionCombo.getText());
                        boolean updateDecision = false;
                        if (modelReview.getDecision() == null) {
                            updateDecision = true;
                        } else {
                            R4EDecision oldDecisionValue = modelReview.getDecision().getValue();
                            if (!newDecision.getValue().equals((Object)oldDecisionValue)) {
                                updateDecision = true;
                            }
                        }
                        if (updateDecision) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            modelReview.setDecision(newDecision);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
                ReviewTabPropertySection.this.refresh();
            }
        });
        ReviewTabPropertySection.addScrollListener(this.fExitDecisionCombo);
        this.fDecisionUsersListLabel = aWidgetFactory.createCLabel(decisionSectionClient, "Decision Participants: ");
        this.fDecisionUsersListLabel.setToolTipText("The Participants that were part of the Exit Decision");
        this.fDecisionUsersListLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        List<String> participants = null;
        participants = R4EUIModelController.getActiveReview() != null ? R4EUIModelController.getActiveReview().getParticipantIDs() : new ArrayList<String>();
        textGridData = new GridData(4, 0x1000000, true, false);
        textGridData.horizontalSpan = 3;
        this.fDecisionUsersList = new EditableListWidget((FormToolkit)aWidgetFactory, decisionSectionClient, textGridData, this, 2, CCombo.class, participants.toArray(new String[participants.size()]));
        this.fDecisionUsersList.setToolTipText("The Participants that were part of the Exit Decision");
        this.fDecisionTimeSpentLabel = aWidgetFactory.createCLabel(decisionSectionClient, "Decision Time Spent: ");
        this.fDecisionTimeSpentLabel.setToolTipText("The Time Spent for the Review Exit Decision");
        this.fDecisionTimeSpentLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fDecisionTimeSpentText = aWidgetFactory.createText(decisionSectionClient, "");
        textGridData = new GridData(4, 0x1000000, true, false);
        textGridData.horizontalSpan = 3;
        this.fDecisionTimeSpentText.setToolTipText("The Time Spent for the Review Exit Decision");
        this.fDecisionTimeSpentText.setLayoutData((Object)textGridData);
        this.fDecisionTimeSpentText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress && ReviewTabPropertySection.this.fDecisionTimeSpentText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    Integer timeSpent;
                    try {
                        timeSpent = Integer.valueOf(ReviewTabPropertySection.this.fDecisionTimeSpentText.getText().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        timeSpent = 0;
                    }
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewExtended)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        if (modelReview.getDecision() == null || timeSpent.intValue() != modelReview.getDecision().getSpentTime()) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            if (modelReview.getDecision() == null) {
                                R4EReviewDecision reviewDecision = Persistence.RModelFactoryExt.eINSTANCE.createR4EReviewDecision();
                                reviewDecision.setValue(R4EDecision.R4E_REVIEW_DECISION_NONE);
                                modelReview.setDecision(reviewDecision);
                            }
                            modelReview.getDecision().setSpentTime(timeSpent.intValue());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        return this.fDecisionSection;
    }

    private void createPhaseTable(TabbedPropertySheetWidgetFactory aWidgetFactory, Composite aComposite, Composite aTopComposite) {
        this.fPhaseTable = aWidgetFactory.createTable(aComposite, 32768);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)aTopComposite, 4);
        this.fPhaseTable.setHeaderVisible(true);
        this.fPhaseTable.setToolTipText("The Review Phase Map that show the Review Progression");
        this.fPhaseTable.setLayoutData((Object)data);
        this.fPhaseTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReviewTabPropertySection.this.fPhaseTable.deselectAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fColumnPhase = new TableColumn(this.fPhaseTable, 16384, 0);
        this.fColumnOwner = new TableColumn(this.fPhaseTable, 16384, 1);
        this.fColumnStartDate = new TableColumn(this.fPhaseTable, 16384, 2);
        this.fColumnEndDate = new TableColumn(this.fPhaseTable, 16384, 3);
        this.fColumnPhase.setText("Phase: ");
        this.fColumnOwner.setText("Owner: ");
        this.fColumnStartDate.setText("Start Date: ");
        this.fColumnEndDate.setText("End Date: ");
        this.fPhasePlanning = new TableItem(this.fPhaseTable, 0);
        this.fPhasePreparation = new TableItem(this.fPhaseTable, 0);
        this.fPhaseDecision = new TableItem(this.fPhaseTable, 0);
        this.fPhaseRework = new TableItem(this.fPhaseTable, 0);
        this.fPhasePlanning.setText(0, "PLANNING");
        this.fPhasePreparation.setText(0, "PREPARATION");
        this.fPhaseDecision.setText(0, "DECISION");
        this.fPhaseRework.setText(0, "REWORK");
        this.fPhaseMapLabel = aWidgetFactory.createCLabel(aComposite, "Phase Map: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fPhaseTable, -5);
        data.top = new FormAttachment((Control)this.fPhaseTable, 0, 0x1000000);
        this.fPhaseMapLabel.setToolTipText("The Review Phase Map that show the Review Progression");
        this.fPhaseMapLabel.setLayoutData((Object)data);
        this.fPlanningPhaseOwnerCombo = new CCombo((Composite)this.fPhaseTable, 2056);
        this.fPlanningPhaseOwnerCombo.setToolTipText("The Owner of the Review Phase.  Only the Owner can Change the Current Review Phase");
        this.fPlanningPhaseOwnerCombo.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewExtended)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        if (!ReviewTabPropertySection.this.fPlanningPhaseOwnerCombo.getText().equals(((R4EFormalReview)modelReview).getCurrent().getPhaseOwnerID())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            ((R4EFormalReview)modelReview).getCurrent().setPhaseOwnerID(ReviewTabPropertySection.this.fPlanningPhaseOwnerCombo.getText());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
                ReviewTabPropertySection.this.refresh();
            }
        });
        ReviewTabPropertySection.addScrollListener(this.fPlanningPhaseOwnerCombo);
        TableEditor planningEditor = new TableEditor(this.fPhaseTable);
        planningEditor.grabHorizontal = true;
        planningEditor.grabVertical = true;
        planningEditor.setEditor((Control)this.fPlanningPhaseOwnerCombo, this.fPhasePlanning, 1);
        this.fPreparationPhaseOwnerCombo = new CCombo((Composite)this.fPhaseTable, 2056);
        this.fPreparationPhaseOwnerCombo.setToolTipText("The Owner of the Review Phase.  Only the Owner can Change the Current Review Phase");
        this.fPreparationPhaseOwnerCombo.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewExtended)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        if (!ReviewTabPropertySection.this.fPreparationPhaseOwnerCombo.getText().equals(((R4EFormalReview)modelReview).getCurrent().getPhaseOwnerID())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            ((R4EFormalReview)modelReview).getCurrent().setPhaseOwnerID(ReviewTabPropertySection.this.fPreparationPhaseOwnerCombo.getText());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
                ReviewTabPropertySection.this.refresh();
            }
        });
        ReviewTabPropertySection.addScrollListener(this.fPreparationPhaseOwnerCombo);
        TableEditor preparationEditor = new TableEditor(this.fPhaseTable);
        preparationEditor.grabHorizontal = true;
        preparationEditor.grabVertical = true;
        preparationEditor.setEditor((Control)this.fPreparationPhaseOwnerCombo, this.fPhasePreparation, 1);
        this.fDecisionPhaseOwnerCombo = new CCombo((Composite)this.fPhaseTable, 2056);
        this.fDecisionPhaseOwnerCombo.setToolTipText("The Owner of the Review Phase.  Only the Owner can Change the Current Review Phase");
        this.fDecisionPhaseOwnerCombo.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewExtended)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        if (!ReviewTabPropertySection.this.fDecisionPhaseOwnerCombo.getText().equals(((R4EFormalReview)modelReview).getCurrent().getPhaseOwnerID())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            ((R4EFormalReview)modelReview).getCurrent().setPhaseOwnerID(ReviewTabPropertySection.this.fDecisionPhaseOwnerCombo.getText());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
                ReviewTabPropertySection.this.refresh();
            }
        });
        ReviewTabPropertySection.addScrollListener(this.fDecisionPhaseOwnerCombo);
        TableEditor decisionEditor = new TableEditor(this.fPhaseTable);
        decisionEditor.grabHorizontal = true;
        decisionEditor.grabVertical = true;
        decisionEditor.setEditor((Control)this.fDecisionPhaseOwnerCombo, this.fPhaseDecision, 1);
        this.fReworkPhaseOwnerCombo = new CCombo((Composite)this.fPhaseTable, 2056);
        this.fReworkPhaseOwnerCombo.setToolTipText("The Owner of the Review Phase.  Only the Owner can Change the Current Review Phase");
        this.fReworkPhaseOwnerCombo.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewTabPropertySection.this.fRefreshInProgress) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EReview modelReview = ((R4EUIReviewExtended)ReviewTabPropertySection.this.fProperties.getElement()).getReview();
                        if (!ReviewTabPropertySection.this.fReworkPhaseOwnerCombo.getText().equals(((R4EFormalReview)modelReview).getCurrent().getPhaseOwnerID())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                            ((R4EFormalReview)modelReview).getCurrent().setPhaseOwnerID(ReviewTabPropertySection.this.fReworkPhaseOwnerCombo.getText());
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
                ReviewTabPropertySection.this.refresh();
            }
        });
        ReviewTabPropertySection.addScrollListener(this.fReworkPhaseOwnerCombo);
        TableEditor reworkEditor = new TableEditor(this.fPhaseTable);
        reworkEditor.grabHorizontal = true;
        reworkEditor.grabVertical = true;
        reworkEditor.setEditor((Control)this.fReworkPhaseOwnerCombo, this.fPhaseRework, 1);
        this.fColumnPhase.pack();
        this.fColumnOwner.pack();
        this.fColumnStartDate.pack();
        this.fColumnEndDate.pack();
    }

    public void refresh() {
        R4EMeetingData meetingData;
        String project;
        this.fRefreshInProgress = true;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
        R4EUIReviewBasic uiReview = (R4EUIReviewBasic)this.fProperties.getElement();
        R4EReview modelReview = uiReview.getReview();
        this.fNameText.setText(modelReview.getName());
        this.fDescriptionText.setText(modelReview.getExtraNotes());
        this.fStartDateText.setText(dateFormat.format(modelReview.getStartDate()));
        if (modelReview.getEndDate() == null) {
            this.fEndDateText.setText("(In Progress)");
        } else {
            this.fEndDateText.setText(dateFormat.format(modelReview.getEndDate()));
        }
        String[] availableProjects = (String[])((R4EUIReviewGroup)uiReview.getParent()).getReviewGroup().getAvailableProjects().toArray();
        this.fProjectCombo.removeAll();
        this.fProjectCombo.add("");
        String[] stringArray = availableProjects;
        int n = availableProjects.length;
        int n2 = 0;
        while (n2 < n) {
            project = stringArray[n2];
            this.fProjectCombo.add(project);
            ++n2;
        }
        project = modelReview.getProject();
        if (project != null) {
            this.fProjectCombo.setText(project);
        }
        this.fComponents.setEditableValues((String[])((R4EUIReviewGroup)uiReview.getParent()).getReviewGroup().getAvailableComponents().toArray());
        String[] components = (String[])modelReview.getComponents().toArray();
        this.fComponents.removeAll();
        Item item = null;
        String component = null;
        int i = 0;
        while (i < components.length) {
            component = components[i];
            if (i >= this.fComponents.getItemCount()) {
                item = this.fComponents.addItem();
            } else {
                item = this.fComponents.getItem(i);
                if (item == null) {
                    item = this.fComponents.addItem();
                }
            }
            item.setText(component);
            ++i;
        }
        if (modelReview.getEntryCriteria() != null) {
            this.fEntryCriteriaText.setText(modelReview.getEntryCriteria());
        }
        if (modelReview.getObjectives() != null) {
            this.fObjectivesText.setText(modelReview.getObjectives());
        }
        if (modelReview.getReferenceMaterial() != null) {
            this.fReferenceMaterialText.setText(modelReview.getReferenceMaterial());
        }
        if ((meetingData = modelReview.getActiveMeeting()) != null && meetingData.eResource() != null) {
            this.fMeetingUpdateButton.setText("Update...");
            this.fMeetingSubjectLabel.setText(meetingData.getSubject());
            SimpleDateFormat meetingDateFormat = new SimpleDateFormat("yyyy-MMM-dd HH:mm");
            meetingDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.fMeetingStartTimeLabel.setText(meetingDateFormat.format(new Date(meetingData.getStartTime())));
            this.fMeetingDurationLabel.setText(Integer.toString(meetingData.getDuration()));
            this.fMeetingLocationLabel.setText(meetingData.getLocation() != null ? meetingData.getLocation() : "");
        } else {
            this.fMeetingUpdateButton.setText("Create...");
            this.fMeetingSubjectLabel.setText("");
            this.fMeetingStartTimeLabel.setText("");
            this.fMeetingDurationLabel.setText("");
            this.fMeetingLocationLabel.setText("");
        }
        this.fExitDecisionCombo.setItems(R4EUIReviewBasic.getExitDecisionValues());
        if (modelReview.getDecision() != null) {
            this.fExitDecisionCombo.select(modelReview.getDecision().getValue() == null ? 0 : modelReview.getDecision().getValue().getValue());
        } else {
            this.fExitDecisionCombo.setText("");
        }
        if (this.fProperties.getElement() instanceof R4EUIReviewExtended) {
            R4EUIReviewExtended uiExtendedReview = (R4EUIReviewExtended)this.fProperties.getElement();
            R4EFormalReview modelFormalReview = (R4EFormalReview)uiReview.getReview();
            List<R4EParticipant> participants = uiExtendedReview.getParticipants();
            item = null;
            int numParticipants = participants.size();
            this.fDecisionUsersList.removeAll();
            int i2 = 0;
            while (i2 < numParticipants) {
                if (participants.get(i2).isIsPartOfDecision()) {
                    if (i2 >= this.fDecisionUsersList.getItemCount()) {
                        item = this.fDecisionUsersList.addItem();
                    } else {
                        item = this.fDecisionUsersList.getItem(i2);
                        if (item == null) {
                            item = this.fDecisionUsersList.addItem();
                        }
                    }
                    item.setText(participants.get(i2).getId());
                }
                ++i2;
            }
            if (modelFormalReview.getDecision() != null) {
                this.fDecisionTimeSpentText.setText(Integer.valueOf(modelFormalReview.getDecision().getSpentTime()).toString());
            } else {
                this.fDecisionTimeSpentText.setText("");
            }
            this.fPhaseCombo.setItems(uiExtendedReview.getAvailablePhases());
            this.fPhaseCombo.select(uiExtendedReview.mapPhaseToIndex(((R4EReviewState)modelReview.getState()).getState()));
            int columnWidth = this.fPhaseTable.getClientArea().width / this.fPhaseTable.getColumnCount();
            this.fColumnPhase.setWidth(columnWidth);
            this.fColumnOwner.setWidth(columnWidth);
            this.fColumnStartDate.setWidth(columnWidth);
            this.fColumnEndDate.setWidth(columnWidth);
            ArrayList<String> participantsList = new ArrayList<String>();
            for (R4EParticipant participant : participants) {
                participantsList.add(participant.getId());
            }
            String[] participantsStr = participantsList.toArray(new String[participantsList.size()]);
            this.fDecisionUsersList.setEditableValues(participantsStr);
            R4EReviewPhaseInfo phaseInfo = uiExtendedReview.getPhaseInfo(R4EReviewPhase.R4E_REVIEW_PHASE_STARTED);
            R4EReviewPhaseInfo currentPhaseInfo = modelFormalReview.getCurrent();
            if (phaseInfo != null && phaseInfo.getPhaseOwnerID() != null) {
                this.fPhasePlanning.setText(1, phaseInfo.getPhaseOwnerID());
                this.fPhasePlanning.setText(2, phaseInfo.getStartDate() != null ? dateFormat.format(phaseInfo.getStartDate()) : "");
                this.fPhasePlanning.setText(3, phaseInfo.getEndDate() != null ? dateFormat.format(phaseInfo.getEndDate()) : "");
                if (currentPhaseInfo.getType().equals((Object)phaseInfo.getType())) {
                    this.fPhasePlanning.setBackground(Display.getCurrent().getSystemColor(13));
                    this.fPhasePreparation.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fPhaseDecision.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fPhaseRework.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fPlanningPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(13));
                    this.fPreparationPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fDecisionPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fReworkPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fPlanningPhaseOwnerCombo.setItems(participantsStr);
                    this.fPlanningPhaseOwnerCombo.select(UIUtils.mapParticipantToIndex(modelFormalReview.getCurrent().getPhaseOwnerID()));
                }
            } else {
                this.fPhasePlanning.setText(1, "");
                this.fPhasePlanning.setText(2, "");
                this.fPhasePlanning.setText(3, "");
            }
            if ((phaseInfo = uiExtendedReview.getPhaseInfo(R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION)) != null && phaseInfo.getPhaseOwnerID() != null) {
                this.fPhasePreparation.setText(1, phaseInfo.getPhaseOwnerID());
                this.fPhasePreparation.setText(2, phaseInfo.getStartDate() != null ? dateFormat.format(phaseInfo.getStartDate()) : "");
                this.fPhasePreparation.setText(3, phaseInfo.getEndDate() != null ? dateFormat.format(phaseInfo.getEndDate()) : "");
                if (currentPhaseInfo.getType().equals((Object)phaseInfo.getType())) {
                    this.fPhasePlanning.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fPhasePreparation.setBackground(Display.getCurrent().getSystemColor(13));
                    this.fPhaseDecision.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fPhaseRework.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fPlanningPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fPreparationPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(13));
                    this.fDecisionPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fReworkPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fPreparationPhaseOwnerCombo.setItems(participantsStr);
                    this.fPreparationPhaseOwnerCombo.select(UIUtils.mapParticipantToIndex(modelFormalReview.getCurrent().getPhaseOwnerID()));
                }
            } else {
                this.fPhasePreparation.setText(1, "");
                this.fPhasePreparation.setText(2, "");
                this.fPhasePreparation.setText(3, "");
            }
            if ((phaseInfo = uiExtendedReview.getPhaseInfo(R4EReviewPhase.R4E_REVIEW_PHASE_DECISION)) != null && phaseInfo.getPhaseOwnerID() != null) {
                this.fPhaseDecision.setText(1, phaseInfo.getPhaseOwnerID());
                this.fPhaseDecision.setText(2, phaseInfo.getStartDate() != null ? dateFormat.format(phaseInfo.getStartDate()) : "");
                this.fPhaseDecision.setText(3, phaseInfo.getEndDate() != null ? dateFormat.format(phaseInfo.getEndDate()) : "");
                if (currentPhaseInfo.getType().equals((Object)phaseInfo.getType())) {
                    this.fPhasePlanning.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fPhasePreparation.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fPhaseDecision.setBackground(Display.getCurrent().getSystemColor(13));
                    this.fPhaseRework.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fPlanningPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fPreparationPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fDecisionPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(13));
                    this.fReworkPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(1));
                    this.fDecisionPhaseOwnerCombo.setItems(participantsStr);
                    this.fDecisionPhaseOwnerCombo.select(UIUtils.mapParticipantToIndex(modelFormalReview.getCurrent().getPhaseOwnerID()));
                }
            } else {
                this.fPhaseDecision.setText(1, "");
                this.fPhaseDecision.setText(2, "");
                this.fPhaseDecision.setText(3, "");
            }
            if ((phaseInfo = uiExtendedReview.getPhaseInfo(R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) != null && phaseInfo.getPhaseOwnerID() != null) {
                this.fPhaseRework.setText(1, phaseInfo.getPhaseOwnerID());
                this.fPhaseRework.setText(2, phaseInfo.getStartDate() != null ? dateFormat.format(phaseInfo.getStartDate()) : "");
                this.fPhaseRework.setText(3, phaseInfo.getEndDate() != null ? dateFormat.format(phaseInfo.getEndDate()) : "");
                if (currentPhaseInfo.getType().equals((Object)phaseInfo.getType())) {
                    this.fPhasePlanning.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fPhasePreparation.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fPhaseDecision.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fPhaseRework.setBackground(Display.getCurrent().getSystemColor(13));
                    this.fPlanningPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fPreparationPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fDecisionPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(5));
                    this.fReworkPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(13));
                    this.fReworkPhaseOwnerCombo.setItems(participantsStr);
                    this.fReworkPhaseOwnerCombo.select(UIUtils.mapParticipantToIndex(modelFormalReview.getCurrent().getPhaseOwnerID()));
                }
            } else {
                this.fPhaseRework.setText(1, "");
                this.fPhaseRework.setText(2, "");
                this.fPhaseRework.setText(3, "");
            }
            if ((phaseInfo = uiExtendedReview.getPhaseInfo(R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) != null && phaseInfo.getType() != null && currentPhaseInfo.getType().equals((Object)phaseInfo.getType())) {
                this.fPhasePlanning.setBackground(Display.getCurrent().getSystemColor(5));
                this.fPhasePreparation.setBackground(Display.getCurrent().getSystemColor(5));
                this.fPhaseDecision.setBackground(Display.getCurrent().getSystemColor(5));
                this.fPhaseRework.setBackground(Display.getCurrent().getSystemColor(5));
                this.fPlanningPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(5));
                this.fPreparationPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(5));
                this.fDecisionPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(5));
                this.fReworkPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(5));
            }
        } else {
            this.fPhaseCombo.setItems(uiReview.getAvailablePhases());
            this.fPhaseCombo.select(uiReview.mapPhaseToIndex(((R4EReviewState)modelReview.getState()).getState()));
        }
        this.setEnabledFields();
        this.fRefreshInProgress = false;
        R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
    }

    protected void setEnabledFields() {
        if (R4EUIModelController.isJobInProgress() || this.fProperties.getElement().isReadOnly() || !((R4EUIReviewBasic)this.fProperties.getElement()).isOpen() || ((R4EReviewState)((R4EUIReviewBasic)this.fProperties.getElement()).getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) || !this.fProperties.getElement().isEnabled()) {
            this.fNameText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fPhaseCombo.setEnabled(false);
            this.fDescriptionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDescriptionText.setEditable(false);
            this.fStartDateText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fEndDateText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fProjectCombo.setEnabled(false);
            this.fComponents.setEnabled(false);
            this.fEntryCriteriaText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fEntryCriteriaText.setEditable(false);
            this.fObjectivesText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fObjectivesText.setEditable(false);
            this.fReferenceMaterialText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fReferenceMaterialText.setEditable(false);
            this.fExitDecisionCombo.setEnabled(false);
            this.fMeetingUpdateButton.setEnabled(false);
            this.fMeetingRefreshButton.setEnabled(false);
            this.fMeetingSubjectLabel.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fMeetingStartTimeLabel.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fMeetingDurationLabel.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fMeetingLocationLabel.setForeground(UIUtils.DISABLED_FONT_COLOR);
            if (this.fProperties.getElement() instanceof R4EUIReviewExtended) {
                this.fPhaseTable.setEnabled(false);
                this.fPlanningPhaseOwnerCombo.setEnabled(false);
                this.fPreparationPhaseOwnerCombo.setEnabled(false);
                this.fDecisionPhaseOwnerCombo.setEnabled(false);
                this.fReworkPhaseOwnerCombo.setEnabled(false);
                this.fPlanningPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(15));
                this.fPreparationPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(15));
                this.fDecisionPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(15));
                this.fReworkPhaseOwnerCombo.setBackground(Display.getCurrent().getSystemColor(15));
                this.fPhaseTable.setVisible(true);
                this.fPhaseMapLabel.setVisible(true);
                this.fDecisionSection.setVisible(true);
                this.fDecisionUsersList.setEnabled(false);
                this.fDecisionTimeSpentText.setForeground(UIUtils.DISABLED_FONT_COLOR);
                this.fDecisionTimeSpentText.setEditable(false);
                this.fDecisionUsersListLabel.setVisible(true);
                this.fDecisionUsersList.setVisible(true);
                this.fDecisionTimeSpentText.setVisible(true);
                this.fDecisionTimeSpentLabel.setVisible(true);
                this.setPhaseControlVisibility();
            } else {
                this.fPhaseTable.setVisible(false);
                this.fPhaseMapLabel.setVisible(false);
                this.fPlanningPhaseOwnerCombo.setVisible(false);
                this.fPreparationPhaseOwnerCombo.setVisible(false);
                this.fDecisionPhaseOwnerCombo.setVisible(false);
                this.fReworkPhaseOwnerCombo.setVisible(false);
                this.fDecisionUsersListLabel.setVisible(false);
                this.fDecisionUsersList.setVisible(false);
                this.fDecisionTimeSpentText.setVisible(false);
                this.fDecisionTimeSpentLabel.setVisible(false);
                if (((R4EUIReviewBasic)this.fProperties.getElement()).getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
                    this.fDecisionSection.setVisible(false);
                } else {
                    this.fDecisionSection.setVisible(true);
                }
            }
        } else {
            this.fNameText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fPhaseCombo.setEnabled(true);
            this.fStartDateText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fEndDateText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDescriptionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDescriptionText.setEditable(true);
            this.fProjectCombo.setEnabled(true);
            this.fComponents.setEnabled(true);
            this.fEntryCriteriaText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fEntryCriteriaText.setEditable(true);
            this.fObjectivesText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fObjectivesText.setEditable(true);
            this.fReferenceMaterialText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fReferenceMaterialText.setEditable(true);
            this.fMeetingUpdateButton.setEnabled(true);
            this.fMeetingRefreshButton.setEnabled(true);
            this.fMeetingSubjectLabel.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fMeetingStartTimeLabel.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fMeetingDurationLabel.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fMeetingLocationLabel.setForeground(UIUtils.ENABLED_FONT_COLOR);
            if (this.fProperties.getElement() instanceof R4EUIReviewExtended) {
                R4EUIReviewExtended uiReview = (R4EUIReviewExtended)this.fProperties.getElement();
                if (uiReview.isDecisionDateEnabled()) {
                    this.fDecisionUsersList.setEnabled(true);
                    this.fDecisionTimeSpentText.setForeground(UIUtils.ENABLED_FONT_COLOR);
                    this.fDecisionTimeSpentText.setEditable(true);
                    this.fExitDecisionCombo.setEnabled(true);
                } else {
                    this.fDecisionUsersList.setEnabled(false);
                    this.fDecisionTimeSpentText.setForeground(UIUtils.DISABLED_FONT_COLOR);
                    this.fDecisionTimeSpentText.setEditable(false);
                    this.fExitDecisionCombo.setEnabled(false);
                }
                this.fDecisionUsersListLabel.setVisible(true);
                this.fDecisionUsersList.setVisible(true);
                this.fDecisionTimeSpentText.setVisible(true);
                this.fDecisionTimeSpentLabel.setVisible(true);
                this.fPhaseTable.setEnabled(true);
                this.fPlanningPhaseOwnerCombo.setEnabled(true);
                this.fPreparationPhaseOwnerCombo.setEnabled(true);
                this.fDecisionPhaseOwnerCombo.setEnabled(true);
                this.fReworkPhaseOwnerCombo.setEnabled(true);
                this.fPhaseTable.setVisible(true);
                this.fPhaseMapLabel.setVisible(true);
                this.setPhaseControlVisibility();
            } else {
                this.fDecisionUsersListLabel.setVisible(false);
                this.fDecisionUsersList.setVisible(false);
                this.fDecisionTimeSpentText.setVisible(false);
                this.fDecisionTimeSpentLabel.setVisible(false);
                if (((R4EUIReviewBasic)this.fProperties.getElement()).isExitDecisionEnabled()) {
                    this.fExitDecisionCombo.setEnabled(true);
                } else {
                    this.fExitDecisionCombo.setEnabled(false);
                }
                this.fPhaseTable.setVisible(false);
                this.fPhaseMapLabel.setVisible(false);
                this.fPlanningPhaseOwnerCombo.setVisible(false);
                this.fPreparationPhaseOwnerCombo.setVisible(false);
                this.fDecisionPhaseOwnerCombo.setVisible(false);
                this.fReworkPhaseOwnerCombo.setVisible(false);
                if (((R4EUIReviewBasic)this.fProperties.getElement()).getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
                    this.fDecisionSection.setVisible(false);
                } else {
                    this.fDecisionSection.setVisible(true);
                }
            }
        }
    }

    private void setPhaseControlVisibility() {
        R4EReviewPhase currentPhase = ((R4EFormalReview)((R4EUIReviewExtended)this.fProperties.getElement()).getReview()).getCurrent().getType();
        switch (currentPhase.getValue()) {
            case 0: {
                this.fPlanningPhaseOwnerCombo.setVisible(true);
                this.fPreparationPhaseOwnerCombo.setVisible(false);
                this.fDecisionPhaseOwnerCombo.setVisible(false);
                this.fReworkPhaseOwnerCombo.setVisible(false);
                break;
            }
            case 1: {
                this.fPreparationPhaseOwnerCombo.setVisible(true);
                this.fPlanningPhaseOwnerCombo.setVisible(false);
                this.fDecisionPhaseOwnerCombo.setVisible(false);
                this.fReworkPhaseOwnerCombo.setVisible(false);
                break;
            }
            case 2: {
                this.fDecisionPhaseOwnerCombo.setVisible(true);
                this.fPlanningPhaseOwnerCombo.setVisible(false);
                this.fPreparationPhaseOwnerCombo.setVisible(false);
                this.fReworkPhaseOwnerCombo.setVisible(false);
                break;
            }
            case 3: {
                this.fReworkPhaseOwnerCombo.setVisible(true);
                this.fPlanningPhaseOwnerCombo.setVisible(false);
                this.fPreparationPhaseOwnerCombo.setVisible(false);
                this.fDecisionPhaseOwnerCombo.setVisible(false);
                break;
            }
            case 4: {
                this.fPlanningPhaseOwnerCombo.setVisible(false);
                this.fPreparationPhaseOwnerCombo.setVisible(false);
                this.fDecisionPhaseOwnerCombo.setVisible(false);
                this.fReworkPhaseOwnerCombo.setVisible(false);
            }
        }
    }

    public void itemsUpdated(Item[] aItems, int aInstanceId) {
        try {
            R4EReview modelReview = ((R4EUIReviewBasic)this.fProperties.getElement()).getReview();
            String currentUser = R4EUIModelController.getReviewer();
            if (1 == aInstanceId) {
                Long bookNum;
                ArrayList<String> newAddComponents = new ArrayList<String>();
                ArrayList<String> newDeleteComponents = new ArrayList<String>();
                ArrayList storedComponents = new ArrayList();
                storedComponents.addAll(modelReview.getComponents());
                Item[] itemArray = aItems;
                int n = aItems.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item = itemArray[n2];
                    newAddComponents.add(item.getText());
                    newDeleteComponents.add(item.getText());
                    ++n2;
                }
                newAddComponents.removeAll(storedComponents);
                if (newAddComponents.size() > 0) {
                    bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                    modelReview.getComponents().addAll(newAddComponents);
                    R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                }
                storedComponents.removeAll(newDeleteComponents);
                if (storedComponents.size() > 0) {
                    bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelReview, currentUser);
                    modelReview.getComponents().removeAll(storedComponents);
                    R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                }
            } else {
                ArrayList<String> newAddParticipants = new ArrayList<String>();
                ArrayList<String> newDeleteParticipants = new ArrayList<String>();
                ArrayList<String> storedParticipants = new ArrayList<String>();
                Collection storedUsers = modelReview.getUsersMap().values();
                for (R4EUser storedUser : storedUsers) {
                    if (!((R4EParticipant)storedUser).isIsPartOfDecision()) continue;
                    storedParticipants.add(storedUser.getId());
                }
                Item[] itemArray = aItems;
                int n = aItems.length;
                int n3 = 0;
                while (n3 < n) {
                    Item item = itemArray[n3];
                    newAddParticipants.add(item.getText());
                    newDeleteParticipants.add(item.getText());
                    ++n3;
                }
                newAddParticipants.removeAll(storedParticipants);
                if (newAddParticipants.size() > 0) {
                    for (String participant : newAddParticipants) {
                        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)((R4EUIReviewBasic)this.fProperties.getElement()).getParticipant(participant, false), currentUser);
                        ((R4EParticipant)modelReview.getUsersMap().get((Object)participant)).setIsPartOfDecision(true);
                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                    }
                }
                storedParticipants.removeAll(newDeleteParticipants);
                if (storedParticipants.size() > 0) {
                    for (String participant : storedParticipants) {
                        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)((R4EUIReviewBasic)this.fProperties.getElement()).getParticipant(participant, false), currentUser);
                        ((R4EParticipant)modelReview.getUsersMap().get((Object)participant)).setIsPartOfDecision(false);
                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                    }
                }
            }
            this.refresh();
        }
        catch (ResourceHandlingException e1) {
            UIUtils.displayResourceErrorDialog(e1);
        }
        catch (OutOfSyncException e1) {
            UIUtils.displaySyncErrorDialog(e1);
        }
    }

    public void itemSelected(Item aItem, int aInstanceId) {
    }
}

