/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import org.eclipse.emf.common.util.URI;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleSet;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class RuleSetTabPropertySection
extends ModelElementTabPropertySection {
    protected Text fVersionText = null;
    private Text fNameText = null;
    private Text fFilePathText = null;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(parent);
        FormData data = null;
        widgetFactory.setBorderStyle(0);
        this.fNameText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.fNameText.setEditable(false);
        this.fNameText.setToolTipText("A Name that Identifies this Rule Set.A Rule Set is a Collection of Related Design Rules bundled together");
        this.fNameText.setLayoutData((Object)data);
        CLabel nameLabel = widgetFactory.createCLabel(composite, "Name: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fNameText, -5);
        data.top = new FormAttachment((Control)this.fNameText, 0, 0x1000000);
        nameLabel.setToolTipText("A Name that Identifies this Rule Set.A Rule Set is a Collection of Related Design Rules bundled together");
        nameLabel.setLayoutData((Object)data);
        this.fFilePathText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fNameText, 4);
        this.fFilePathText.setEditable(false);
        this.fFilePathText.setToolTipText("The Location (Folder) where the Rule Set Information is Stored.  Rule Set Information is stored in files that have a _rule_set.xrer suffix");
        this.fFilePathText.setLayoutData((Object)data);
        CLabel filePathLabel = widgetFactory.createCLabel(composite, "File: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fFilePathText, -5);
        data.top = new FormAttachment((Control)this.fFilePathText, 0, 0x1000000);
        filePathLabel.setToolTipText("The Location (Folder) where the Rule Set Information is Stored.  Rule Set Information is stored in files that have a _rule_set.xrer suffix");
        filePathLabel.setLayoutData((Object)data);
        this.fVersionText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fFilePathText, 4);
        this.fVersionText.setEditable(false);
        this.fVersionText.setToolTipText("The Version for this Rule Set");
        this.fVersionText.setLayoutData((Object)data);
        CLabel versionLabel = widgetFactory.createCLabel(composite, "Version: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fVersionText, -5);
        data.top = new FormAttachment((Control)this.fVersionText, 0, 0x1000000);
        versionLabel.setToolTipText("The Version for this Rule Set");
        versionLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(2048);
    }

    public void refresh() {
        if (((R4EUIRuleSet)this.fProperties.getElement()).getRuleSet() != null) {
            this.fRefreshInProgress = true;
            this.fVersionText.setText(((R4EUIRuleSet)this.fProperties.getElement()).getRuleSet().getVersion());
            this.fNameText.setText(((R4EUIRuleSet)this.fProperties.getElement()).getRuleSet().getName());
            this.fFilePathText.setText(URI.decode((String)((R4EUIRuleSet)this.fProperties.getElement()).getRuleSetFile()));
            this.setEnabledFields();
            this.fRefreshInProgress = false;
        } else {
            this.fVersionText.setText("");
            this.fNameText.setText("");
            this.fFilePathText.setText("");
        }
    }

    protected void setEnabledFields() {
        if (R4EUIModelController.isJobInProgress() || !((R4EUIRuleSet)this.fProperties.getElement()).isOpen() || !this.fProperties.getElement().isEnabled() || this.fProperties.getElement().isReadOnly()) {
            this.fNameText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fFilePathText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fVersionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
        } else {
            this.fNameText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fFilePathText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fVersionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
        }
    }
}

