/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.core.rfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.util.FS;
import org.eclipse.mylyn.reviews.r4e.core.Activator;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.IRFSRegistry;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.core.utils.IOUtils;
import org.eclipse.mylyn.reviews.r4e.core.utils.filePermission.FileSupportCommandFactory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class ReviewsRFSProxy
implements IRFSRegistry {
    private static final String DEFAULT_REPO_NAME = "ReviewsRepo.git";
    private ObjectInserter fInserter = null;
    protected Repository fRepository = null;
    protected final RepositoryUtil fRepositoryUtil;

    public ReviewsRFSProxy(File aReviewGroupDir, boolean create) throws ReviewsFileStorageException {
        File repoLoc = new File(aReviewGroupDir, DEFAULT_REPO_NAME);
        if (create) {
            this.fRepository = this.initializeRepo(repoLoc);
            try {
                FileSupportCommandFactory.getInstance().grantWritePermission(aReviewGroupDir.getAbsolutePath());
            }
            catch (IOException e) {
                throw new ReviewsFileStorageException(e);
            }
        } else {
            this.fRepository = this.openRepository(repoLoc);
        }
        this.fInserter = this.fRepository.newObjectInserter();
        this.fRepositoryUtil = org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil();
    }

    public static boolean isValidRepo(File dir) {
        File repoDir = new File(dir, DEFAULT_REPO_NAME);
        return RepositoryCache.FileKey.isGitRepository((File)repoDir, (FS)FS.DETECTED);
    }

    private Repository initializeRepo(File aReviewGroupDir) throws ReviewsFileStorageException {
        try {
            FileRepository newRepo = new FileRepository(aReviewGroupDir);
            newRepo.create(true);
            newRepo.getConfig().setString("core", null, "sharedrepository", "0666");
            newRepo.getConfig().save();
            return newRepo;
        }
        catch (IOException e) {
            throw new ReviewsFileStorageException(e);
        }
    }

    private Repository openRepository(File aReviewGroupDir) throws ReviewsFileStorageException {
        Repository r;
        try {
            r = RepositoryCache.FileKey.exact((File)aReviewGroupDir, (FS)FS.DETECTED).open(true);
        }
        catch (IOException e) {
            throw new ReviewsFileStorageException(e);
        }
        return r;
    }

    public String registerReviewBlob(byte[] content) throws ReviewsFileStorageException {
        ObjectId objid;
        String id;
        block9: {
            id = null;
            objid = null;
            try {
                try {
                    objid = this.fInserter.insert(3, content);
                    this.fInserter.flush();
                }
                catch (IOException e) {
                    id = this.blobIdFor(content);
                    InputStream is = this.getBlobContent(null, id);
                    if (is == null) {
                        throw new ReviewsFileStorageException(e);
                    }
                    Activator.fTracer.traceError("IOException while registering content however it's already available in the local repository, " + e.getMessage());
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        Activator.fTracer.traceError("IOException while closing probe stream, " + ex.getMessage());
                    }
                    this.fInserter.release();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.fInserter.release();
                throw throwable;
            }
            this.fInserter.release();
        }
        if (objid != null) {
            id = objid.getName();
        }
        return id;
    }

    public String registerReviewBlob(InputStream content) throws ReviewsFileStorageException {
        try {
            return this.registerReviewBlob(IOUtils.readFully(content));
        }
        catch (IOException e) {
            throw new ReviewsFileStorageException(e);
        }
    }

    public String registerReviewBlob(File aFromFile) throws ReviewsFileStorageException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(aFromFile);
        }
        catch (FileNotFoundException e) {
            throw new ReviewsFileStorageException(e);
        }
        String id = null;
        ObjectId objid = null;
        try {
            try {
                objid = this.fInserter.insert(3, aFromFile.length(), (InputStream)stream);
                this.fInserter.flush();
                FileSupportCommandFactory.getInstance().grantWritePermission(this.fRepository.getDirectory().getAbsolutePath());
            }
            catch (IOException e) {
                throw new ReviewsFileStorageException(e);
            }
        }
        finally {
            this.fInserter.release();
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                StringBuilder sb = new StringBuilder("Exception: " + e.getMessage());
                Activator.fTracer.traceDebug(sb.toString());
            }
        }
        if (objid != null) {
            id = objid.getName();
        }
        return id;
    }

    public InputStream getBlobContent(IProgressMonitor monitor, String id) throws ReviewsFileStorageException {
        ObjectStream resStream = null;
        if (id == null) {
            return null;
        }
        try {
            ObjectId objId = ObjectId.fromString((String)id);
            resStream = this.fRepository.open((AnyObjectId)objId, 3).openStream();
        }
        catch (Exception e) {
            throw new ReviewsFileStorageException(e);
        }
        return resStream;
    }

    public IFileRevision getIFileRevision(IProgressMonitor monitor, final R4EFileVersion fileVersion) throws ReviewsFileStorageException {
        String localId = fileVersion.getLocalVersionID();
        if (localId == null) {
            return null;
        }
        try {
            final IPath path = Path.fromPortableString((String)fileVersion.getRepositoryPath());
            return new FileRevision(){

                public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
                    return this;
                }

                public boolean isPropertyMissing() {
                    return false;
                }

                public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
                    return ReviewsRFSProxy.this.getIStorage(null, fileVersion);
                }

                public String getName() {
                    return path.lastSegment();
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public IStorage getIStorage(IProgressMonitor monitor, R4EFileVersion fileVersion) {
        final IPath path = Path.fromPortableString((String)fileVersion.getRepositoryPath());
        final String localId = fileVersion.getLocalVersionID();
        if (localId == null) {
            return null;
        }
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return true;
            }

            public String getName() {
                return path.lastSegment();
            }

            public IPath getFullPath() {
                Path repoPath = new Path(ReviewsRFSProxy.this.fRepositoryUtil.getRepositoryName(ReviewsRFSProxy.this.fRepository));
                String pathString = path.toPortableString();
                return repoPath.append(Path.fromPortableString((String)(String.valueOf(pathString) + " " + localId)));
            }

            public InputStream getContents() throws CoreException {
                try {
                    return ReviewsRFSProxy.this.getBlobContent(null, localId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.core", e.getMessage()));
                }
            }
        };
    }

    public Repository getRepository() {
        return this.fRepository;
    }

    public void close() {
        this.fRepository.close();
    }

    public String blobIdFor(InputStream content) throws ReviewsFileStorageException {
        String id = null;
        try {
            id = this.blobIdFor(IOUtils.readFully(content));
        }
        catch (IOException e) {
            throw new ReviewsFileStorageException(e);
        }
        return id;
    }

    public String blobIdFor(byte[] content) {
        String id = this.fInserter.idFor(3, content).getName();
        this.fInserter.release();
        return id;
    }

    public String blobIdFor(File aFromFile) throws ReviewsFileStorageException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(aFromFile);
        }
        catch (FileNotFoundException e) {
            throw new ReviewsFileStorageException(e);
        }
        String id = null;
        ObjectId objid = null;
        try {
            try {
                objid = this.fInserter.idFor(3, aFromFile.length(), (InputStream)stream);
                FileSupportCommandFactory.getInstance().grantWritePermission(this.fRepository.getDirectory().getAbsolutePath());
            }
            catch (IOException e) {
                throw new ReviewsFileStorageException(e);
            }
        }
        finally {
            this.fInserter.release();
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                StringBuilder sb = new StringBuilder("Exception: " + e.getMessage());
                Activator.fTracer.traceDebug(sb.toString());
            }
        }
        if (objid != null) {
            id = objid.getName();
        }
        return id;
    }
}

