/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

public class AddAssignHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Add Assignees to Element...";

    public Object execute(ExecutionEvent aEvent) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                R4EUIModelController.setJobInProgress(true);
                if (!selectedElements.isEmpty()) {
                    List<R4EParticipant> participants = UIUtils.getAssignParticipants();
                    if (participants.size() > 0) {
                        monitor.beginTask(AddAssignHandler.COMMAND_MESSAGE, selectedElements.size());
                        for (IR4EUIModelElement element : selectedElements) {
                            R4EUIPlugin.Ftracer.traceInfo("Add Assignees..." + element.getName());
                            element.addAssignees(participants);
                            monitor.worked(1);
                            if (!monitor.isCanceled()) continue;
                            R4EUIModelController.setJobInProgress(false);
                            UIUtils.setNavigatorViewFocus(element, 0);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    UIUtils.setNavigatorViewFocus((IR4EUIModelElement)selectedElements.get(0), 0);
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

