/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.swt.graphics.Image;

public class MissingAnnotationAttributesProposal
extends LinkedCorrectionProposal {
    private Annotation fAnnotation;

    public MissingAnnotationAttributesProposal(ICompilationUnit cu, Annotation annotation, int relevance) {
        super(CorrectionMessages.MissingAnnotationAttributesProposal_add_missing_attributes_label, cu, (ASTRewrite)null, relevance, (Image)null);
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fAnnotation = annotation;
        Assert.isNotNull((Object)this.fAnnotation.resolveTypeBinding());
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ListRewrite listRewrite;
        AST ast = this.fAnnotation.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.createImportRewrite((CompilationUnit)this.fAnnotation.getRoot());
        if (this.fAnnotation instanceof NormalAnnotation) {
            listRewrite = rewrite.getListRewrite((ASTNode)this.fAnnotation, NormalAnnotation.VALUES_PROPERTY);
        } else {
            NormalAnnotation newAnnotation = ast.newNormalAnnotation();
            newAnnotation.setTypeName((Name)rewrite.createMoveTarget((ASTNode)this.fAnnotation.getTypeName()));
            rewrite.replace((ASTNode)this.fAnnotation, (ASTNode)newAnnotation, null);
            listRewrite = rewrite.getListRewrite((ASTNode)newAnnotation, NormalAnnotation.VALUES_PROPERTY);
        }
        this.addMissingAtributes(this.fAnnotation.resolveTypeBinding(), listRewrite);
        return rewrite;
    }

    private void addMissingAtributes(ITypeBinding binding, ListRewrite listRewriter) {
        HashSet<String> implementedAttribs = new HashSet<String>();
        if (this.fAnnotation instanceof NormalAnnotation) {
            List list = ((NormalAnnotation)this.fAnnotation).values();
            int i = 0;
            while (i < list.size()) {
                MemberValuePair curr = (MemberValuePair)list.get(i);
                implementedAttribs.add(curr.getName().getIdentifier());
                ++i;
            }
        } else if (this.fAnnotation instanceof SingleMemberAnnotation) {
            implementedAttribs.add("value");
        }
        ASTRewrite rewriter = listRewriter.getASTRewrite();
        AST ast = rewriter.getAST();
        ContextSensitiveImportRewriteContext context = null;
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(listRewriter.getParent());
        if (bodyDeclaration != null) {
            context = new ContextSensitiveImportRewriteContext((ASTNode)bodyDeclaration, this.getImportRewrite());
        }
        IMethodBinding[] declaredMethods = binding.getDeclaredMethods();
        int i = 0;
        while (i < declaredMethods.length) {
            IMethodBinding curr = declaredMethods[i];
            if (!implementedAttribs.contains(curr.getName()) && curr.getDefaultValue() == null) {
                MemberValuePair pair = ast.newMemberValuePair();
                pair.setName(ast.newSimpleName(curr.getName()));
                pair.setValue(this.newDefaultExpression(ast, curr.getReturnType(), context));
                listRewriter.insertLast((ASTNode)pair, null);
                this.addLinkedPosition(rewriter.track((ASTNode)pair.getName()), false, "val_name_" + i);
                this.addLinkedPosition(rewriter.track((ASTNode)pair.getValue()), false, "val_type_" + i);
            }
            ++i;
        }
    }

    private Expression newDefaultExpression(AST ast, ITypeBinding type, ImportRewrite.ImportRewriteContext context) {
        if (type.isPrimitive()) {
            String name = type.getName();
            if ("boolean".equals(name)) {
                return ast.newBooleanLiteral(false);
            }
            return ast.newNumberLiteral("0");
        }
        if (type == ast.resolveWellKnownType("java.lang.String")) {
            return ast.newStringLiteral();
        }
        if (type.isArray()) {
            ArrayInitializer initializer = ast.newArrayInitializer();
            initializer.expressions().add(this.newDefaultExpression(ast, type.getElementType(), context));
            return initializer;
        }
        if (type.isAnnotation()) {
            MarkerAnnotation annotation = ast.newMarkerAnnotation();
            annotation.setTypeName(ast.newName(this.getImportRewrite().addImport(type, context)));
            return annotation;
        }
        return ast.newNullLiteral();
    }
}

