/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.StatusInfo;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesLabelProvider;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class HistoryListDialog
extends StatusDialog {
    private List<String> fHistoryList = new ArrayList<String>();
    private IStatus fHistoryStatus;
    private TableViewer fHistoryViewer;
    private Button fRemoveButton;
    private String fResult;

    public HistoryListDialog(Shell shell, String[] elements) {
        super(shell);
        this.setTitle(PDEUIMessages.HistoryListDialog_title);
        this.fHistoryList.addAll(Arrays.asList(elements));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.pde.doc.user.history_list_dialog");
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(1808));
        Label label = new Label(inner, 0);
        label.setText(PDEUIMessages.HistoryListDialog_label);
        Composite container = this.createListArea(inner);
        container.setLayoutData((Object)new GridData(1808));
        HistoryListDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Composite createListArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout1 = new GridLayout();
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        layout1.numColumns = 2;
        container.setLayout((Layout)layout1);
        container.setLayoutData((Object)new GridData(1808));
        this.createTableArea(container);
        this.createListButtons(container);
        return container;
    }

    private void createListButtons(Composite parent) {
        this.fRemoveButton = new Button(parent, 8);
        this.fRemoveButton.setText(PDEUIMessages.HistoryListDialog_remove_button);
        this.fRemoveButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = HistoryListDialog.this.fHistoryViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    Object removalCandidate = ((IStructuredSelection)selection).getFirstElement();
                    HistoryListDialog.this.fHistoryList.remove(removalCandidate);
                    HistoryListDialog.this.fHistoryViewer.remove(removalCandidate);
                }
            }
        });
    }

    private Control createTableArea(Composite parent) {
        Table table = new Table(parent, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        gd.heightHint = 200;
        table.setLayoutData((Object)gd);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (HistoryListDialog.this.fHistoryStatus.isOK()) {
                    HistoryListDialog.this.okPressed();
                }
            }
        });
        this.fHistoryViewer = new TableViewer(table);
        final DependenciesLabelProvider labelProvider = new DependenciesLabelProvider(false);
        this.fHistoryViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fHistoryViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                labelProvider.dispose();
            }
        });
        this.fHistoryViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fHistoryViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.fHistoryViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        StructuredSelection sel = this.fHistoryList.size() > 0 ? new StructuredSelection((Object)this.fHistoryList.get(0)) : new StructuredSelection();
        this.fHistoryViewer.setSelection((ISelection)sel);
        this.fHistoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StatusInfo status = new StatusInfo();
                ISelection selection = HistoryListDialog.this.fHistoryViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    List selected = ((IStructuredSelection)selection).toList();
                    if (selected.size() != 1) {
                        status.setError("");
                        HistoryListDialog.this.fResult = null;
                    } else {
                        HistoryListDialog.this.fResult = (String)selected.get(0);
                    }
                    HistoryListDialog.this.fRemoveButton.setEnabled(HistoryListDialog.this.fHistoryList.size() > selected.size() && selected.size() != 0);
                    HistoryListDialog.this.fHistoryStatus = status;
                    HistoryListDialog.this.updateStatus(status);
                }
            }
        });
        return this.fHistoryViewer.getControl();
    }

    public String[] getRemaining() {
        return this.fHistoryList.toArray(new String[this.fHistoryList.size()]);
    }

    public String getResult() {
        return this.fResult;
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object element) {
            return HistoryListDialog.this.fHistoryList.toArray();
        }
    }
}

