/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.model.sherlock.report;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LoggingCategory implements Enumerator
{
    DEFAULT(0, "Default", "Default"),
    NORMAL(1, "Normal", "Normal"),
    ADVANCED(2, "Advanced", "Advanced");

    public static final int DEFAULT_VALUE = 0;
    public static final int NORMAL_VALUE = 1;
    public static final int ADVANCED_VALUE = 2;
    private static final LoggingCategory[] VALUES_ARRAY;
    public static final List<LoggingCategory> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LoggingCategory[]{DEFAULT, NORMAL, ADVANCED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LoggingCategory get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoggingCategory result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoggingCategory getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoggingCategory result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoggingCategory get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return NORMAL;
            }
            case 2: {
                return ADVANCED;
            }
        }
        return null;
    }

    private LoggingCategory(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

