/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.search.LocalSearchManager;
import org.eclipse.help.internal.search.XHTMLSearchParticipant;
import org.eclipse.help.internal.xhtml.XHTMLContentDescriber;
import org.eclipse.help.search.IHelpSearchIndex;
import org.eclipse.help.search.ISearchDocument;
import org.eclipse.help.search.SearchParticipant;

public class HTMLSearchParticipant
extends SearchParticipant {
    private static final String HELP_BASE_XHTML = "org.eclipse.help.base.xhtml";
    private HTMLDocParser parser = new HTMLDocParser();
    private String indexPath;
    private IContentDescriber xhtmlDescriber;
    private XHTMLSearchParticipant xhtmlParticipant;

    public HTMLSearchParticipant(String indexPath) {
        this.indexPath = indexPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus addDocument(IHelpSearchIndex index, String pluginId, String name, URL url, String id, ISearchDocument doc) {
        if (this.isXHTML(pluginId, url)) {
            LocalSearchManager manager = BaseHelpSystem.getLocalSearchManager();
            SearchParticipant participant = manager.getParticipant(HELP_BASE_XHTML);
            if (participant != null) return participant.addDocument(index, pluginId, name, url, id, doc);
            participant = this.getXhtmlParticipant();
            return participant.addDocument(index, pluginId, name, url, id, doc);
        }
        try {
            try {
                try {
                    this.parser.openDocument(url);
                }
                catch (IOException iOException) {
                    Status status = new Status(4, "org.eclipse.help.base", 4, "Help document " + name + " cannot be opened.", null);
                    this.parser.closeDocument();
                    return status;
                }
                doc.addContents(this.parser.getContentReader(), this.parser.getContentReader());
                String title = this.parser.getTitle();
                doc.setTitle(title);
                doc.setSummary(this.parser.getSummary(title));
                if (this.parser.getException() == null) return Status.OK_STATUS;
                Status status = new Status(4, "org.eclipse.help.base", 4, "Parse error occurred while adding document " + name + " to search index " + this.indexPath + ".", (Throwable)this.parser.getException());
                return status;
            }
            finally {
                this.parser.closeDocument();
            }
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.help.base", 4, "IO exception occurred while adding document " + name + " to search index " + this.indexPath + ".", (Throwable)e);
        }
    }

    private SearchParticipant getXhtmlParticipant() {
        if (this.xhtmlParticipant == null) {
            this.xhtmlParticipant = new XHTMLSearchParticipant();
        }
        return this.xhtmlParticipant;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isXHTML(String pluginId, URL url) {
        boolean bl;
        if (this.xhtmlDescriber == null) {
            this.xhtmlDescriber = new XHTMLContentDescriber();
        }
        InputStream in = null;
        in = ProxyUtil.getStream(url);
        boolean bl2 = bl = this.xhtmlDescriber.describe(in, null) == 2;
        if (in == null) return bl;
        try {
            in.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        catch (Exception exception) {
            try {
                if (in == null) return false;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
    }
}

