/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.rcptt.tesla.core.protocol.GetState;
import org.eclipse.rcptt.tesla.core.protocol.Nop;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.WaitForState;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandToElementEntry;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandToRawEntry;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandTransferKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawEvent;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaScenario;
import org.eclipse.rcptt.tesla.core.ui.Widget;

public class TeslaScenarioContainer {
    private TeslaScenario scenario;
    private XMIResource resource;

    public TeslaScenarioContainer() {
        this.scenario = RawFactory.eINSTANCE.createTeslaScenario();
        this.resource = new XMIResourceImpl();
        this.resource.getContents().add((Object)this.scenario);
    }

    public TeslaScenarioContainer(TeslaScenario scenario) {
        this.scenario = scenario;
    }

    public synchronized void add(Command command, List<Element> elements, List<Widget> controls, List<RawEvent> rawEvents) {
        Command copy;
        Command command2 = copy = command != null ? (Command)EcoreUtil.copy((EObject)command) : null;
        if (copy != null) {
            this.scenario.getCommands().add((Object)copy);
            this.setElements(elements, copy, controls);
            this.setEvents(copy, rawEvents);
        }
    }

    public synchronized void add(int index, Command command, List<Element> elements, List<Widget> controls, List<RawEvent> rawEvents) {
        Command copy = command != null ? (Command)EcoreUtil.copy((EObject)command) : null;
        this.scenario.getCommands().add(index, (Object)copy);
        this.setElements(elements, copy, controls);
        this.setEvents(copy, rawEvents);
    }

    private synchronized void setElements(List<Element> elements, Command copy, List<Widget> controls) {
        if (elements != null && elements.size() > 0) {
            CommandToElementEntry entry = RawFactory.eINSTANCE.createCommandToElementEntry();
            entry.setCommand(copy);
            for (Element element : elements) {
                entry.getElements().add(element != null ? (Element)EcoreUtil.copy((EObject)element) : null);
            }
            if (controls != null) {
                for (Widget control : controls) {
                    entry.getControls().add(control != null ? (Widget)EcoreUtil.copy((EObject)control) : null);
                }
            }
            this.scenario.getElementMapping().add((Object)entry);
        }
    }

    private synchronized void setEvents(Command copy, List<RawEvent> events) {
        if (events != null && events.size() > 0) {
            CommandToRawEntry entry = RawFactory.eINSTANCE.createCommandToRawEntry();
            entry.setCommand(copy);
            for (RawEvent event : events) {
                entry.getRawEvents().add(event != null ? (RawEvent)EcoreUtil.copy((EObject)event) : null);
            }
            this.scenario.getRawMapping().add((Object)entry);
        }
    }

    private synchronized List<RawEvent> getRawEvents(Command command) {
        if (command != null) {
            EList<CommandToRawEntry> rawMapping = this.scenario.getRawMapping();
            for (CommandToRawEntry commandToRawEntry : rawMapping) {
                if (!commandToRawEntry.getCommand().equals(command)) continue;
                return commandToRawEntry.getRawEvents();
            }
        }
        return new ArrayList<RawEvent>();
    }

    public synchronized void clear() {
        if (this.scenario != null) {
            this.scenario.getCommands().clear();
            this.scenario.getElementMapping().clear();
        }
    }

    public synchronized List<Command> getCommands() {
        return this.scenario.getCommands();
    }

    public synchronized List<Element> getElements(Command cmd) {
        EList<CommandToElementEntry> elementMapping = this.scenario.getElementMapping();
        for (CommandToElementEntry commandToElementEntry : elementMapping) {
            if (!commandToElementEntry.getCommand().equals(cmd)) continue;
            return commandToElementEntry.getElements();
        }
        return null;
    }

    public synchronized List<Widget> getControls(Command cmd) {
        EList<CommandToElementEntry> elementMapping = this.scenario.getElementMapping();
        for (CommandToElementEntry commandToElementEntry : elementMapping) {
            if (!commandToElementEntry.getCommand().equals(cmd)) continue;
            return commandToElementEntry.getControls();
        }
        return null;
    }

    public synchronized TeslaScenario getScenarioCopy() {
        return this.scenario != null ? (TeslaScenario)EcoreUtil.copy((EObject)this.scenario) : null;
    }

    public boolean isEmpty() {
        return this.scenario == null || this.scenario.getCommands().isEmpty();
    }

    public Command getLastCommand() {
        EList<Command> commands = this.scenario.getCommands();
        return (Command)commands.get(commands.size() - 1);
    }

    public Command getLastCommand(int index) {
        EList<Command> commands = this.scenario.getCommands();
        return (Command)commands.get(commands.size() - index);
    }

    public synchronized Command getLast() {
        EList<Command> commands = this.scenario.getCommands();
        if (commands.isEmpty()) {
            return null;
        }
        Command last = (Command)commands.get(commands.size() - 1);
        return last;
    }

    public synchronized Command removeLast() {
        EList<Command> commands = this.scenario.getCommands();
        if (commands.isEmpty()) {
            return null;
        }
        Command last = (Command)commands.remove(commands.size() - 1);
        EList<CommandToElementEntry> mapping = this.scenario.getElementMapping();
        ArrayList<CommandToElementEntry> toRemove = new ArrayList<CommandToElementEntry>();
        for (CommandToElementEntry commandToElementEntry : mapping) {
            if (!commandToElementEntry.getCommand().equals(last)) continue;
            toRemove.add(commandToElementEntry);
        }
        mapping.removeAll(toRemove);
        EList<CommandToRawEntry> rawMapping = this.scenario.getRawMapping();
        ArrayList<CommandToRawEntry> toRemoveRaw = new ArrayList<CommandToRawEntry>();
        for (CommandToRawEntry commandToRawEntry : rawMapping) {
            if (!commandToRawEntry.getCommand().equals(last)) continue;
            toRemoveRaw.add(commandToRawEntry);
        }
        rawMapping.removeAll(toRemoveRaw);
        return last;
    }

    public synchronized Command remove(int index) {
        EList<Command> commands = this.scenario.getCommands();
        if (commands.isEmpty()) {
            return null;
        }
        Command command = (Command)commands.remove(index);
        EList<CommandToElementEntry> mapping = this.scenario.getElementMapping();
        ArrayList<CommandToElementEntry> toRemove = new ArrayList<CommandToElementEntry>();
        for (CommandToElementEntry commandToElementEntry : mapping) {
            if (!commandToElementEntry.getCommand().equals(command)) continue;
            toRemove.add(commandToElementEntry);
        }
        mapping.removeAll(toRemove);
        EList<CommandToRawEntry> rawMapping = this.scenario.getRawMapping();
        ArrayList<CommandToRawEntry> toRemoveRaw = new ArrayList<CommandToRawEntry>();
        for (CommandToRawEntry commandToRawEntry : rawMapping) {
            if (!commandToRawEntry.getCommand().equals(command)) continue;
            toRemoveRaw.add(commandToRawEntry);
        }
        rawMapping.removeAll(toRemoveRaw);
        return command;
    }

    public void save(OutputStream stream) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("SAVE_ONLY_IF_CHANGED", Boolean.FALSE);
        options.put("ENCODING", "UTF-8");
        options.put("FORMATTED", Boolean.TRUE);
        try {
            this.resource.save(stream, options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(InputStream stream) {
        this.clear();
        this.resource.getContents().clear();
        try {
            this.resource.unload();
            this.resource.load(stream, null);
            this.scenario = null;
            EList contents = this.resource.getContents();
            for (EObject eObject : contents) {
                if (!(eObject instanceof TeslaScenario)) continue;
                this.scenario = (TeslaScenario)eObject;
            }
            if (this.scenario == null) {
                this.scenario = RawFactory.eINSTANCE.createTeslaScenario();
                this.resource.getContents().add((Object)this.scenario);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isDirty() {
        return this.resource.isModified();
    }

    public TeslaScenario getScenario() {
        return this.scenario;
    }

    public void setScenarioID(String name) {
        this.scenario.setId(name);
    }

    public void processTransfer(Command command, List<Element> elements, CommandTransferKind kind, List<Widget> controls, int index, List<RawEvent> rawEvents) {
        block0 : switch (kind) {
            case REMOVE: {
                this.remove(index);
                break;
            }
            case INSERT_BEFORE: {
                this.add(this.size() - index, command, elements, controls, rawEvents);
                break;
            }
            case REPLACE_PREVIOUS: {
                if (rawEvents != null && this.scenario.getCommands().size() > 0) {
                    List<RawEvent> events = this.getRawEvents((Command)this.scenario.getCommands().get(this.scenario.getCommands().size() - 1));
                    events.addAll(rawEvents);
                }
                this.removeLast();
                this.add(command, elements, controls, rawEvents);
                break;
            }
            case INSERT_BEFORE_ESSENTIAL_COMMAND: {
                EList<Command> commands = this.scenario.getCommands();
                int i = commands.size() - 1;
                while (i >= 0) {
                    Command cmd = (Command)commands.get(i);
                    if (!(cmd instanceof SelectCommand || cmd instanceof WaitForState || cmd instanceof GetState || cmd instanceof Nop)) {
                        this.add(i, command, elements, controls, rawEvents);
                        break block0;
                    }
                    --i;
                }
                break;
            }
            case DEFAULT: {
                this.add(command, elements, controls, rawEvents);
            }
        }
    }

    public int size() {
        if (this.scenario == null) {
            return 0;
        }
        return this.scenario.getCommands().size();
    }
}

