/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ui.IEditorPart;

public class AssistContext
extends TextInvocationContext
implements IInvocationContext {
    private final ICompilationUnit fCompilationUnit;
    private final IEditorPart fEditor;
    private CompilationUnit fASTRoot;
    private final SharedASTProvider.WAIT_FLAG fWaitFlag;
    private NodeFinder fNodeFinder;

    private AssistContext(ICompilationUnit cu, ISourceViewer sourceViewer, IEditorPart editor, int offset, int length, SharedASTProvider.WAIT_FLAG waitFlag) {
        super(sourceViewer, offset, length);
        Assert.isLegal((cu != null ? 1 : 0) != 0);
        Assert.isLegal((waitFlag != null ? 1 : 0) != 0);
        this.fCompilationUnit = cu;
        this.fEditor = editor;
        this.fWaitFlag = waitFlag;
    }

    public AssistContext(ICompilationUnit cu, ISourceViewer sourceViewer, int offset, int length, SharedASTProvider.WAIT_FLAG waitFlag) {
        this(cu, sourceViewer, null, offset, length, waitFlag);
    }

    public AssistContext(ICompilationUnit cu, ISourceViewer sourceViewer, IEditorPart editor, int offset, int length) {
        this(cu, sourceViewer, editor, offset, length, SharedASTProvider.WAIT_YES);
    }

    public AssistContext(ICompilationUnit cu, ISourceViewer sourceViewer, int offset, int length) {
        this(cu, sourceViewer, null, offset, length);
    }

    public AssistContext(ICompilationUnit cu, int offset, int length) {
        this(cu, null, offset, length);
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    @Override
    public int getSelectionLength() {
        return Math.max(this.getLength(), 0);
    }

    @Override
    public int getSelectionOffset() {
        return this.getOffset();
    }

    @Override
    public CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = SharedASTProvider.getAST((ITypeRoot)this.fCompilationUnit, this.fWaitFlag, null);
            if (this.fASTRoot == null) {
                this.fASTRoot = ASTResolving.createQuickFixAST(this.fCompilationUnit, null);
            }
        }
        return this.fASTRoot;
    }

    public void setASTRoot(CompilationUnit root) {
        this.fASTRoot = root;
    }

    @Override
    public ASTNode getCoveringNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.getOffset(), this.getLength());
        }
        return this.fNodeFinder.getCoveringNode();
    }

    @Override
    public ASTNode getCoveredNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.getOffset(), this.getLength());
        }
        return this.fNodeFinder.getCoveredNode();
    }
}

