/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.felix.scr.Component;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.ComponentStorage;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.Resolver;
import org.eclipse.equinox.internal.ds.WorkPerformer;
import org.eclipse.equinox.internal.ds.WorkThread;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.equinox.internal.util.event.Queue;
import org.eclipse.equinox.internal.util.threadpool.ThreadPoolManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentException;
import org.osgi.util.tracker.ServiceTracker;

public class SCRManager
implements ServiceListener,
SynchronousBundleListener,
ConfigurationListener,
WorkPerformer,
PrivilegedAction {
    public final int ENABLE_COMPONENTS = 1;
    public final int DISABLE_COMPONENTS = 2;
    protected Hashtable bundleToServiceComponents;
    protected Hashtable processingBundles = new Hashtable(5);
    protected Queue queue = new Queue(10);
    private Resolver resolver;
    private WorkThread workThread;
    protected boolean running = false;
    protected boolean stopped = false;
    private ServiceTracker threadPoolManagerTracker;
    private boolean hasRegisteredServiceListener = true;
    private ComponentStorage storage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SCRManager() {
        String storageClass;
        Class<?> clazz;
        if (Activator.startup) {
            Activator.timeLog("Queue instantiated for ");
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.util.threadpool.ThreadPoolManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.threadPoolManagerTracker = new ServiceTracker(Activator.bc, clazz.getName(), null);
        this.threadPoolManagerTracker.open();
        if (Activator.startup) {
            Activator.timeLog("Threadpool service tracker opened for ");
        }
        this.resolver = new Resolver(this);
        if (Activator.startup) {
            Activator.timeLog("Resolver instantiated for ");
        }
        this.resolver.synchronizeServiceReferences();
        if (Activator.startup) {
            Activator.timeLog("resolver.synchronizeServiceReferences() method took ");
        }
        if ((storageClass = Activator.bc.getProperty("scr.storage.class")) == null) {
            storageClass = "org.eclipse.equinox.internal.ds.storage.file.FileStorage";
        }
        try {
            Class<?> clazz2 = Class.forName(storageClass);
            Class[] classArray = new Class[1];
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.osgi.framework.BundleContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            this.storage = (ComponentStorage)clazz2.getConstructor(classArray).newInstance(Activator.bc);
        }
        catch (Exception e) {
            Activator.log(null, 1, NLS.bind((String)Messages.COULD_NOT_CREATE_INSTANCE, (Object)storageClass), e);
        }
        if (Activator.startup) {
            Activator.timeLog("Creating storage took ");
        }
        Activator.bc.addBundleListener((BundleListener)this);
    }

    public void startIt() {
        Bundle[] bundles = Activator.bc.getBundles();
        if (bundles != null) {
            int i = 0;
            while (i < bundles.length) {
                String lazy;
                Bundle current = bundles[i];
                if (current.getState() == 32) {
                    this.startedBundle(current);
                } else if (current.getState() == 8 && (lazy = (String)current.getHeaders("").get("Bundle-ActivationPolicy")) != null && lazy.indexOf("lazy") >= 0) {
                    this.startedBundle(current);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Object upEv, boolean securityCall) {
        try {
            Queue queue = this.queue;
            synchronized (queue) {
                this.queue.put(upEv);
                if (!this.running) {
                    if (this.queue.size() > 0) {
                        this.running = true;
                        this.workThread = new WorkThread(this);
                        if (securityCall) {
                            AccessController.doPrivileged(this);
                            return;
                        }
                        ThreadPoolManager threadPool = (ThreadPoolManager)this.threadPoolManagerTracker.getService();
                        if (threadPool != null) {
                            threadPool.execute((Runnable)this.workThread, 10, "Component Resolve Thread");
                        } else {
                            new Thread((Runnable)this.workThread, "Component Resolve Thread").start();
                        }
                    }
                } else if (this.workThread.waiting > 0) {
                    this.queue.notifyAll();
                }
            }
        }
        catch (Throwable e) {
            Activator.log(null, 1, Messages.UNEXPECTED_EXCEPTION, e);
        }
    }

    public Object run() {
        ThreadPoolManager threadPool = (ThreadPoolManager)this.threadPoolManagerTracker.getService();
        if (threadPool != null) {
            threadPool.execute((Runnable)this.workThread, 10, "Component Resolve Thread");
        } else {
            new Thread((Runnable)this.workThread, "Component Resolve Thread").start();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueBlocked() {
        this.resolver.queueBlocked();
        Queue queue = this.queue;
        synchronized (queue) {
            this.running = false;
            this.addEvent(null, Activator.security);
        }
    }

    public void enqueueWork(WorkPerformer d, int a, Object o, boolean securityCall) {
        this.addEvent(new QueuedJob(d, a, o), securityCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt() {
        this.stopped = true;
        this.disposeBundles();
        if (this.queue != null) {
            this.queue.clear();
        }
        if (this.running) {
            Queue queue = this.queue;
            synchronized (queue) {
                this.queue.notify();
            }
            int counter = 0;
            while (this.running && counter < 20) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                ++counter;
            }
        }
        this.stopped = true;
        this.threadPoolManagerTracker.close();
        this.storage.stop();
    }

    public void serviceChanged(ServiceEvent sEv) {
        this.resolver.getEligible(sEv);
    }

    public final void bundleChanged(BundleEvent event) {
        int type;
        long start = 0L;
        if (Activator.PERF) {
            start = System.currentTimeMillis();
            Activator.log.info("[DS perf] Started processing bundle event " + event);
        }
        if ((type = event.getType()) == 256) {
            this.stoppingBundle(event.getBundle());
        } else if (type == 2) {
            this.startedBundle(event.getBundle());
        } else if (type == 512) {
            this.startedBundle(event.getBundle());
        } else if (type == 16 && Activator.DBSTORE) {
            this.storage.deleteComponentDefinitions(event.getBundle().getBundleId());
        }
        if (Activator.PERF) {
            start = System.currentTimeMillis() - start;
            Activator.log.info("[DS perf] Processed bundle event '" + event + "' for " + start + "ms");
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (this.bundleToServiceComponents != null && !this.bundleToServiceComponents.isEmpty()) {
            this.addEvent(event, true);
        }
    }

    protected void processConfigurationEvent(ConfigurationEvent event) {
        block17: {
            if (this.bundleToServiceComponents == null || this.bundleToServiceComponents.isEmpty()) {
                return;
            }
            long start = 0L;
            try {
                if (Activator.DEBUG) {
                    Activator.log.debug(" Resolver.configurationEvent(): pid = " + event.getPid() + ", fpid = " + event.getFactoryPid(), null);
                }
                if (Activator.PERF) {
                    start = System.currentTimeMillis();
                    Activator.log.info("[DS perf] Started processing configuration event " + event);
                }
                String pid = event.getPid();
                String fpid = event.getFactoryPid();
                Enumeration keys = this.bundleToServiceComponents.keys();
                while (keys.hasMoreElements()) {
                    Vector bundleComps = (Vector)this.bundleToServiceComponents.get(keys.nextElement());
                    if (bundleComps == null) continue;
                    int i = 0;
                    while (i < bundleComps.size()) {
                        String name;
                        ServiceComponent sc = (ServiceComponent)bundleComps.elementAt(i);
                        if (sc.getConfigurationPolicy() != "ignore" && ((name = sc.getConfigurationPID()).equals(pid) || name.equals(fpid))) {
                            if (name.equals(fpid) && sc.factory != null) {
                                Activator.log(sc.bc, 1, NLS.bind((String)Messages.FACTORY_CONF_NOT_APPLICABLE_FOR_COMPONENT_FACTORY, (Object)sc.name), null);
                                return;
                            }
                            if (sc.enabled) {
                                if (Activator.DEBUG) {
                                    Activator.log.debug("SCRManager.processConfigurationEvent(): found component - " + pid, null);
                                }
                                this.processConfigurationEvent(event, sc);
                            }
                            return;
                        }
                        try {
                            ++i;
                            continue;
                        }
                        catch (Throwable e) {
                            Activator.log(null, 1, NLS.bind((String)Messages.ERROR_PROCESSING_CONFIGURATION, (Object)event.getReference().getBundle()), e);
                        }
                        break block17;
                    }
                }
            }
            finally {
                if (Activator.PERF) {
                    start = System.currentTimeMillis() - start;
                    Activator.log.info("[DS perf] Processed configuration event '" + event + "' for " + start + "ms");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConfigurationEvent(ConfigurationEvent event, ServiceComponent sc) {
        Configuration[] config = null;
        String pid = event.getPid();
        String fpid = event.getFactoryPid();
        switch (event.getType()) {
            case 1: {
                String filter = String.valueOf(fpid != null ? "(&" : "") + "(" + "service.pid" + "=" + pid + ")" + (fpid != null ? "(service.factoryPid=" + fpid + "))" : "");
                try {
                    config = Activator.listConfigurations(filter);
                }
                catch (IOException e) {
                    Activator.log(null, 1, Messages.ERROR_LISTING_CONFIGURATIONS, e);
                }
                catch (InvalidSyntaxException e) {
                    Activator.log(null, 1, Messages.ERROR_LISTING_CONFIGURATIONS, e);
                }
                if (config == null) {
                    return;
                }
                if (fpid == null) {
                    ServiceComponentProp scp;
                    boolean requiresRestart = true;
                    if (sc.isNamespaceAtLeast11() && sc.modifyMethodName != "" && (scp = sc.getServiceComponentProp()) != null && scp.isBuilt()) {
                        requiresRestart = this.processConfigurationChange(scp, config[0]);
                    }
                    if (!requiresRestart) break;
                    Vector<ServiceComponent> components = new Vector<ServiceComponent>();
                    components.addElement(sc);
                    this.resolver.disableComponents(components, 3);
                    sc.enabled = true;
                    this.resolver.enableComponents(components);
                    break;
                }
                ServiceComponentProp scp = sc.getComponentPropByPID(pid);
                if (scp == null && sc.componentProps != null) {
                    Vector components = sc.componentProps;
                    synchronized (components) {
                        if (sc.componentProps.size() == 1 && ((ServiceComponentProp)sc.componentProps.elementAt(0)).getProperties().get("service.pid") == null) {
                            scp = (ServiceComponentProp)sc.componentProps.elementAt(0);
                        }
                    }
                }
                boolean requiresRestart = true;
                if (sc.isNamespaceAtLeast11() && sc.modifyMethodName != "" && scp != null && scp.isBuilt()) {
                    requiresRestart = this.processConfigurationChange(scp, config[0]);
                }
                if (!requiresRestart) break;
                if (scp != null) {
                    sc.componentProps.removeElement(scp);
                    Vector<ServiceComponentProp> components = new Vector<ServiceComponentProp>();
                    components.addElement(scp);
                    this.resolver.disposeComponentConfigs(components, 3);
                    scp.setState(256);
                }
                this.resolver.map(sc, config[0]);
                this.resolver.enableComponents(null);
                break;
            }
            case 2: {
                if (fpid == null) {
                    Vector<ServiceComponent> components = new Vector<ServiceComponent>();
                    components.addElement(sc);
                    this.resolver.disableComponents(components, 4);
                    sc.enabled = true;
                    this.resolver.enableComponents(components);
                    break;
                }
                ServiceComponentProp scp = sc.getComponentPropByPID(pid);
                if (sc.componentProps.size() == 1) {
                    Vector<ServiceComponent> components = new Vector<ServiceComponent>();
                    components.addElement(sc);
                    this.resolver.disableComponents(components, 4);
                    sc.enabled = true;
                    sc.setState(4);
                    this.resolver.enableComponents(components);
                    break;
                }
                sc.componentProps.removeElement(scp);
                Vector<ServiceComponentProp> components = new Vector<ServiceComponentProp>();
                components.addElement(scp);
                this.resolver.disposeComponentConfigs(components, 4);
                scp.setState(256);
            }
        }
    }

    private boolean processConfigurationChange(ServiceComponentProp scp, Configuration config) {
        String key;
        boolean result = false;
        Hashtable currentProps = scp.properties;
        Dictionary newProps = config.getProperties();
        Enumeration keys = currentProps.keys();
        Vector<String> checkedFilters = new Vector<String>();
        while (keys.hasMoreElements() && !result) {
            key = (String)keys.nextElement();
            if (!key.endsWith(".target")) continue;
            checkedFilters.addElement(key);
            String newFilter = (String)newProps.get(key);
            Reference reference = null;
            String refName = key.substring(0, key.length() - ".target".length());
            Vector references = scp.references;
            int i = 0;
            while (i < references.size()) {
                reference = (Reference)references.elementAt(i);
                if (reference.reference.name.equals(refName)) break;
                reference = null;
                ++i;
            }
            if (reference == null) continue;
            if (newFilter != null) {
                if (newFilter.equals(currentProps.get(key))) continue;
                result = result || !reference.doSatisfy(newFilter);
                continue;
            }
            if (reference.policy != 0) continue;
            boolean bl = result = result || !reference.doSatisfy("(objectClass=" + reference.reference.interfaceName + ")");
        }
        keys = newProps.keys();
        while (keys.hasMoreElements() && !result) {
            key = (String)keys.nextElement();
            if (!key.endsWith(".target") || checkedFilters.contains(key)) continue;
            Reference reference = null;
            String refName = key.substring(0, key.length() - ".target".length());
            Vector references = scp.references;
            int i = 0;
            while (i < references.size()) {
                reference = (Reference)references.elementAt(i);
                if (reference.reference.name.equals(refName)) break;
                reference = null;
                ++i;
            }
            if (reference == null) continue;
            boolean bl = result = result || !reference.doSatisfy((String)newProps.get(key));
        }
        if (!result) {
            try {
                InstanceProcess.staticRef.modifyComponent(scp, newProps);
            }
            catch (ComponentException componentException) {
                result = true;
            }
        }
        return result;
    }

    private void disposeBundles() {
        if (this.bundleToServiceComponents != null) {
            Enumeration e = this.bundleToServiceComponents.keys();
            while (e.hasMoreElements()) {
                Bundle bundle = (Bundle)e.nextElement();
                this.stoppingBundle(bundle);
            }
            this.bundleToServiceComponents.clear();
            this.bundleToServiceComponents = null;
        }
    }

    void stoppingBundle(Bundle bundle) {
        Vector components;
        if (this.bundleToServiceComponents != null && (components = (Vector)this.bundleToServiceComponents.remove(bundle)) != null) {
            if (Activator.DEBUG) {
                String bundleName = bundle.getSymbolicName();
                bundleName = bundleName == null || "".equals(bundleName) ? bundle.getLocation() : bundleName;
                Activator.log.debug("SCRManager.stoppingBundle : " + bundleName, null);
            }
            this.resolver.disableComponents(components, 6);
            int i = 0;
            while (i < components.size()) {
                ServiceComponent sc = (ServiceComponent)components.elementAt(i);
                sc.setState(256);
                ++i;
            }
            if (this.bundleToServiceComponents.size() == 0) {
                this.hasRegisteredServiceListener = false;
                Activator.bc.removeServiceListener((ServiceListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startedBundle(Bundle bundle) {
        Hashtable hashtable = this.processingBundles;
        synchronized (hashtable) {
            if (this.processingBundles.get(bundle) != null) {
                return;
            }
            this.processingBundles.put(bundle, "");
        }
        try {
            this.startedBundle2(bundle);
        }
        finally {
            this.processingBundles.remove(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startedBundle2(Bundle bundle) {
        long start = 0L;
        if (Activator.PERF) {
            start = System.currentTimeMillis();
        }
        if (this.bundleToServiceComponents != null && this.bundleToServiceComponents.get(bundle) != null) {
            return;
        }
        String dsHeader = null;
        Dictionary allHeaders = bundle.getHeaders("");
        dsHeader = (String)allHeaders.get("Service-Component");
        if (dsHeader == null) {
            return;
        }
        Vector components = this.storage.loadComponentDefinitions(bundle, dsHeader);
        if (components != null && !components.isEmpty()) {
            if (!this.hasRegisteredServiceListener) {
                this.hasRegisteredServiceListener = true;
                Activator.bc.addServiceListener((ServiceListener)this);
                this.resolver.synchronizeServiceReferences();
            }
            if (Activator.PERF) {
                start = System.currentTimeMillis() - start;
                Activator.log.info("[DS perf] The components of bundle " + bundle + " are parsed for " + start + "ms");
            }
            if (this.bundleToServiceComponents == null) {
                SCRManager sCRManager = this;
                synchronized (sCRManager) {
                    if (this.bundleToServiceComponents == null) {
                        this.bundleToServiceComponents = new Hashtable(11);
                    }
                }
            }
            int i = 0;
            while (i < components.size()) {
                block27: {
                    ServiceComponent comp2;
                    ServiceComponent comp = (ServiceComponent)components.elementAt(i);
                    int j = i + 1;
                    while (j < components.size()) {
                        comp2 = (ServiceComponent)components.elementAt(j);
                        if (comp.name.equals(comp2.name)) {
                            Activator.log(comp.bc, 1, NLS.bind((String)Messages.FOUND_COMPONENTS_WITH_DUPLICATED_NAMES, (Object)comp), null);
                            components.remove(i);
                            --i;
                            break block27;
                        }
                        ++j;
                    }
                    Enumeration keys = this.bundleToServiceComponents.keys();
                    while (keys.hasMoreElements()) {
                        Vector components2 = (Vector)this.bundleToServiceComponents.get(keys.nextElement());
                        int j2 = 0;
                        while (j2 < components2.size()) {
                            comp2 = (ServiceComponent)components2.elementAt(j2);
                            if (comp.name.equals(comp2.name)) {
                                Activator.log(comp.bc, 2, NLS.bind((String)Messages.FOUND_COMPONENTS_WITH_DUPLICATED_NAMES2, (Object)comp, (Object)comp2), null);
                            }
                            ++j2;
                        }
                    }
                    if (comp.autoenable) {
                        comp.enabled = true;
                    }
                }
                ++i;
            }
            this.bundleToServiceComponents.put(bundle, components.clone());
            if (this.workThread != null && this.workThread.processingThread == Thread.currentThread()) {
                this.resolver.enableComponents(components);
            } else {
                this.enqueueWork(this, 1, components, false);
                Vector vector = components;
                synchronized (vector) {
                    long startTime = System.currentTimeMillis();
                    try {
                        while (!components.isEmpty() && System.currentTimeMillis() - startTime < (long)WorkThread.BLOCK_TIMEOUT) {
                            components.wait(1000L);
                        }
                        if (System.currentTimeMillis() - startTime >= (long)WorkThread.BLOCK_TIMEOUT) {
                            Activator.log(null, 2, NLS.bind((String)Messages.TIMEOUT_REACHED_ENABLING_COMPONENTS, (Object)this.getBundleName(bundle), (Object)Integer.toString(WorkThread.BLOCK_TIMEOUT)), null);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private String getBundleName(Bundle b) {
        if (b.getSymbolicName() != null) {
            return b.getSymbolicName();
        }
        return b.getLocation();
    }

    public void enableComponent(String name, Bundle bundle) {
        this.changeComponent(name, bundle, true);
    }

    private void changeComponent(String name, Bundle bundle, boolean enable) {
        if (this.bundleToServiceComponents == null) {
            return;
        }
        try {
            Vector bundleComponents;
            Vector<ServiceComponent> componentsToProcess = null;
            if (Activator.DEBUG) {
                String message = String.valueOf((enable ? "SCRManager.enableComponent(): " : "SCRManager.disableComponent(): ").concat(name != null ? name : "*all*")) + " from bundle " + this.getBundleName(bundle);
                Activator.log.debug(message, null);
            }
            if ((bundleComponents = (Vector)this.bundleToServiceComponents.get(bundle)) != null) {
                if (name != null) {
                    boolean found = false;
                    int i = 0;
                    while (i < bundleComponents.size()) {
                        ServiceComponent component = (ServiceComponent)bundleComponents.elementAt(i);
                        if (component.name.equals(name)) {
                            found = true;
                            if (component.enabled != enable) {
                                component.enabled = enable;
                                component.setState(enable ? 512 : 1024);
                                componentsToProcess = new Vector(2);
                                componentsToProcess.addElement(component);
                                break;
                            }
                        }
                        ++i;
                    }
                    if (!found) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.COMPONENT_NOT_FOUND, (Object)name, (Object)bundle));
                    }
                } else if (enable) {
                    componentsToProcess = new Vector<ServiceComponent>();
                    int i = 0;
                    while (i < bundleComponents.size()) {
                        ServiceComponent sc = (ServiceComponent)bundleComponents.elementAt(i);
                        if (!sc.enabled) {
                            componentsToProcess.addElement(sc);
                            sc.enabled = enable;
                            sc.setState(512);
                        }
                        ++i;
                    }
                }
            }
            if (componentsToProcess != null && !componentsToProcess.isEmpty()) {
                if (enable) {
                    this.enqueueWork(this, 1, componentsToProcess, Activator.security);
                } else {
                    this.enqueueWork(this, 2, componentsToProcess, Activator.security);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Throwable e) {
            Activator.log(null, 1, Messages.UNEXPECTED_EXCEPTION, e);
        }
    }

    public void disableComponent(String name, Bundle bundle) {
        this.changeComponent(name, bundle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performWork(int workAction, Object workObject) {
        if (workAction == 1) {
            this.resolver.enableComponents((Vector)workObject);
            Object object = workObject;
            synchronized (object) {
                ((Vector)workObject).clear();
                workObject.notify();
            }
        } else if (workAction == 2) {
            this.resolver.disableComponents((Vector)workObject, 1);
        }
    }

    protected void configAdminRegistered(ConfigurationAdmin configAdmin, ServiceReference caReference) {
        if (this.bundleToServiceComponents == null || this.bundleToServiceComponents.isEmpty()) {
            return;
        }
        Vector<ServiceComponent> toProcess = new Vector<ServiceComponent>(1);
        Configuration[] configs = null;
        try {
            configs = configAdmin.listConfigurations(null);
        }
        catch (Exception e) {
            Activator.log(null, 1, Messages.ERROR_LISTING_CONFIGURATIONS, e);
        }
        if (configs == null || configs.length == 0) {
            return;
        }
        Enumeration keys = this.bundleToServiceComponents.keys();
        while (keys.hasMoreElements()) {
            Vector bundleComps = (Vector)this.bundleToServiceComponents.get(keys.nextElement());
            if (bundleComps == null) continue;
            int i = 0;
            while (i < bundleComps.size()) {
                ServiceComponent sc = (ServiceComponent)bundleComps.elementAt(i);
                if (sc.getConfigurationPolicy() != "ignore" && sc.enabled) {
                    String componentPID = sc.getConfigurationPID();
                    int j = 0;
                    while (j < configs.length) {
                        if (configs[j].getPid().equals(componentPID) || componentPID.equals(configs[j].getFactoryPid())) {
                            if (componentPID.equals(configs[j].getFactoryPid()) && sc.factory != null) {
                                Activator.log(sc.bc, 1, NLS.bind((String)Messages.FACTORY_CONF_NOT_APPLICABLE_FOR_COMPONENT_FACTORY, (Object)sc.name), null);
                                break;
                            }
                            if (sc.componentProps == null || sc.componentProps.size() == 0) {
                                if (sc.getConfigurationPolicy() != "require") break;
                                toProcess.addElement(sc);
                                break;
                            }
                            ConfigurationEvent ce = new ConfigurationEvent(caReference, 1, configs[j].getFactoryPid(), configs[j].getPid());
                            this.configurationEvent(ce);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (toProcess.size() > 0) {
            this.enqueueWork(this, 1, toProcess, false);
        }
    }

    public Component[] getComponents() {
        if (this.bundleToServiceComponents == null || this.bundleToServiceComponents.isEmpty()) {
            return null;
        }
        Vector<ServiceComponent> result = new Vector<ServiceComponent>();
        Enumeration en = this.bundleToServiceComponents.keys();
        while (en.hasMoreElements()) {
            Bundle b = (Bundle)en.nextElement();
            Vector serviceComponents = (Vector)this.bundleToServiceComponents.get(b);
            int i = 0;
            while (i < serviceComponents.size()) {
                ServiceComponent sc = (ServiceComponent)serviceComponents.elementAt(i);
                if (sc.componentProps != null && !sc.componentProps.isEmpty()) {
                    result.addAll(sc.componentProps);
                } else {
                    result.add(sc);
                }
                ++i;
            }
        }
        if (!result.isEmpty()) {
            Object[] res = new Component[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    public Component[] getComponents(Bundle bundle) {
        if (this.bundleToServiceComponents == null || this.bundleToServiceComponents.isEmpty()) {
            return null;
        }
        Vector serviceComponents = (Vector)this.bundleToServiceComponents.get(bundle);
        if (serviceComponents != null) {
            Vector<ServiceComponent> result = new Vector<ServiceComponent>();
            int i = 0;
            while (i < serviceComponents.size()) {
                ServiceComponent sc = (ServiceComponent)serviceComponents.elementAt(i);
                if (sc.componentProps != null && !sc.componentProps.isEmpty()) {
                    result.addAll(sc.componentProps);
                } else {
                    result.add(sc);
                }
                ++i;
            }
            if (!result.isEmpty()) {
                Object[] res = new Component[result.size()];
                result.copyInto(res);
                return res;
            }
        }
        return null;
    }

    public Component[] getComponents(String componentName) {
        if (this.bundleToServiceComponents == null || this.bundleToServiceComponents.isEmpty()) {
            return null;
        }
        Vector<ServiceComponent> result = new Vector<ServiceComponent>();
        Enumeration en = this.bundleToServiceComponents.keys();
        block0: while (en.hasMoreElements()) {
            Bundle b = (Bundle)en.nextElement();
            Vector serviceComponents = (Vector)this.bundleToServiceComponents.get(b);
            int i = 0;
            while (i < serviceComponents.size()) {
                ServiceComponent sc = (ServiceComponent)serviceComponents.elementAt(i);
                if (sc.getName().equals(componentName)) {
                    if (sc.componentProps != null && !sc.componentProps.isEmpty()) {
                        result.addAll(sc.componentProps);
                        continue block0;
                    }
                    result.add(sc);
                    continue block0;
                }
                ++i;
            }
        }
        if (!result.isEmpty()) {
            Object[] res = new Component[result.size()];
            result.copyInto(res);
            return res;
        }
        return null;
    }

    static class QueuedJob {
        final WorkPerformer performer;
        final int actionType;
        final Object workToDo;

        QueuedJob(WorkPerformer d, int a, Object o) {
            this.performer = d;
            this.actionType = a;
            this.workToDo = o;
        }

        void dispatch() {
            try {
                this.performer.performWork(this.actionType, this.workToDo);
            }
            catch (Throwable t) {
                Activator.log(null, 1, Messages.ERROR_DISPATCHING_WORK, t);
            }
        }

        public String toString() {
            return "[QueuedJob] WorkPerformer: " + this.performer + "; actionType " + this.actionType;
        }
    }
}

