/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.compatibility;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Policy;
import org.eclipse.equinox.internal.p2.discovery.compatibility.BundleDiscoverySource;
import org.eclipse.equinox.internal.p2.discovery.compatibility.ConnectorDiscoveryExtensionReader;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Messages;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Certification;
import org.eclipse.equinox.internal.p2.discovery.model.ValidationException;
import org.eclipse.osgi.util.NLS;

public class BundleDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        if (this.items == null || this.categories == null) {
            throw new IllegalStateException();
        }
        IExtensionPoint extensionPoint = this.getExtensionRegistry().getExtensionPoint("org.eclipse.mylyn.discovery.core.connectorDiscovery");
        IExtension[] extensions = extensionPoint.getExtensions();
        monitor.beginTask(Messages.BundleDiscoveryStrategy_task_loading_local_extensions, extensions.length == 0 ? 1 : extensions.length);
        try {
            if (extensions.length > 0) {
                this.processExtensions((IProgressMonitor)new SubProgressMonitor(monitor, extensions.length), extensions);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void processExtensions(IProgressMonitor monitor, IExtension[] extensions) {
        monitor.beginTask(Messages.BundleDiscoveryStrategy_task_processing_extensions, extensions.length == 0 ? 1 : extensions.length);
        try {
            ConnectorDiscoveryExtensionReader extensionReader = new ConnectorDiscoveryExtensionReader();
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                AbstractCatalogSource discoverySource = this.computeDiscoverySource(extension.getContributor());
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    block14: {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        try {
                            if ("connectorDescriptor".equals(element.getName())) {
                                CatalogItem descriptor = extensionReader.readConnectorDescriptor(element, CatalogItem.class);
                                descriptor.setSource(discoverySource);
                                this.items.add(descriptor);
                                break block14;
                            }
                            if ("connectorCategory".equals(element.getName())) {
                                CatalogCategory category = extensionReader.readConnectorCategory(element, CatalogCategory.class);
                                category.setSource(discoverySource);
                                if (!discoverySource.getPolicy().isPermitCategories()) {
                                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.BundleDiscoveryStrategy_categoryDisallowed, (Object[])new Object[]{category.getName(), category.getId(), element.getContributor().getName()}), null));
                                } else {
                                    this.categories.add(category);
                                }
                                break block14;
                            }
                            if ("certification".equals(element.getName())) {
                                Certification certification = extensionReader.readCertification(element, Certification.class);
                                certification.setSource(discoverySource);
                                this.certifications.add(certification);
                                break block14;
                            }
                            throw new ValidationException(NLS.bind((String)Messages.BundleDiscoveryStrategy_unexpected_element, (Object)element.getName()));
                        }
                        catch (ValidationException e) {
                            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery", NLS.bind((String)Messages.BundleDiscoveryStrategy_3, (Object)element.getContributor().getName(), (Object)e.getMessage()), (Throwable)e));
                        }
                    }
                    ++n4;
                }
                monitor.worked(1);
                ++n2;
            }
            this.tags.addAll(extensionReader.getTags());
        }
        finally {
            monitor.done();
        }
    }

    protected AbstractCatalogSource computeDiscoverySource(IContributor contributor) {
        Policy policy = new Policy(true);
        BundleDiscoverySource bundleDiscoverySource = new BundleDiscoverySource(Platform.getBundle((String)contributor.getName()));
        bundleDiscoverySource.setPolicy(policy);
        return bundleDiscoverySource;
    }

    protected IExtensionRegistry getExtensionRegistry() {
        return Platform.getExtensionRegistry();
    }
}

