/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.search;

import java.util.HashMap;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.search.CommitMatch;
import org.eclipse.egit.ui.internal.search.CommitResultLabelProvider;
import org.eclipse.egit.ui.internal.search.RepositoryMatch;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class CommitSearchResultsPage
extends AbstractTextSearchViewPage {
    protected void elementsChanged(Object[] objects) {
        this.getViewer().refresh();
    }

    protected void clear() {
        this.getViewer().refresh();
    }

    private void configureViewer(StructuredViewer viewer) {
        viewer.setComparator((ViewerComparator)new CommitSorter());
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                if (CommitSearchResultsPage.this.getLayout() == 2) {
                    HashMap<Repository, RepositoryMatch> repos = new HashMap<Repository, RepositoryMatch>();
                    Object[] objectArray = CommitSearchResultsPage.this.getInput().getElements();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object inputElement = objectArray[n2];
                        RepositoryCommit commit = (RepositoryCommit)((Object)inputElement);
                        RepositoryMatch match = (RepositoryMatch)((Object)repos.get(commit.getRepository()));
                        if (match == null) {
                            match = new RepositoryMatch(commit.getRepository());
                            repos.put(commit.getRepository(), match);
                        }
                        match.addCommit(commit);
                        ++n2;
                    }
                    return repos.values().toArray();
                }
                return super.getElements(element);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new CommitResultLabelProvider(this.getLayout())));
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.configureViewer((StructuredViewer)viewer);
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.configureViewer((StructuredViewer)viewer);
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (match instanceof CommitMatch) {
            CommitEditor.open(((CommitMatch)match).getCommit());
        }
    }

    private static class CommitSorter
    extends ViewerComparator {
        private CommitSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof RepositoryCommit && e2 instanceof RepositoryCommit) {
                PersonIdent person1 = ((RepositoryCommit)((Object)e1)).getRevCommit().getAuthorIdent();
                PersonIdent person2 = ((RepositoryCommit)((Object)e2)).getRevCommit().getAuthorIdent();
                if (person1 != null && person2 != null) {
                    return person2.getWhen().compareTo(person1.getWhen());
                }
            } else if (e1 instanceof RepositoryMatch && e2 instanceof RepositoryMatch) {
                return ((RepositoryMatch)((Object)e1)).getLabel(e1).compareToIgnoreCase(((RepositoryMatch)((Object)e2)).getLabel(e2));
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

