/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.storage.CommitFileRevision;
import org.eclipse.egit.core.internal.storage.IndexFileRevision;
import org.eclipse.egit.core.internal.storage.KidCommit;
import org.eclipse.egit.core.internal.storage.KidCommitList;
import org.eclipse.egit.core.internal.storage.KidWalk;
import org.eclipse.egit.core.internal.storage.WorkspaceFileRevision;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.GitRemoteResource;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;
import org.eclipse.team.core.variants.IResourceVariant;

class GitFileHistory
extends FileHistory
implements IAdaptable {
    private static final IFileRevision[] NO_REVISIONS = new IFileRevision[0];
    private static final int BATCH_SIZE = 256;
    private final IResource resource;
    private String gitPath;
    private final Repository db;
    private final RevWalk walk;
    private final IFileRevision[] revisions;

    GitFileHistory(IResource rsrc, int flags, IProgressMonitor monitor) {
        this.resource = rsrc;
        RepositoryMapping rm = RepositoryMapping.getMapping(this.resource);
        if (rm == null) {
            IProject project = this.resource.getProject();
            String projectName = project != null ? project.getName() : "";
            Activator.logError(NLS.bind((String)CoreText.GitFileHistory_gitNotAttached, (Object)projectName), null);
            this.db = null;
            this.walk = null;
        } else {
            this.db = rm.getRepository();
            this.walk = new KidWalk(this.db);
            this.gitPath = rm.getRepoRelativePath(this.resource);
            if (this.gitPath == null || this.gitPath.length() == 0) {
                this.walk.setTreeFilter(TreeFilter.ANY_DIFF);
            } else {
                this.walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(Collections.singleton(this.gitPath)), (TreeFilter)TreeFilter.ANY_DIFF));
            }
        }
        this.revisions = this.buildRevisions(monitor, flags);
    }

    private IFileRevision[] buildRevisions(IProgressMonitor monitor, int flags) {
        if (this.walk == null) {
            return NO_REVISIONS;
        }
        try {
            ObjectId headId = this.db.resolve("HEAD");
            if (headId == null) {
                IProject project = this.resource.getProject();
                String projectName = project != null ? project.getName() : "";
                Activator.logError(NLS.bind((String)CoreText.GitFileHistory_noHeadRevisionAvailable, (Object)projectName), null);
                return NO_REVISIONS;
            }
            RevCommit root = this.walk.parseCommit((AnyObjectId)headId);
            if ((flags & 1) != 0) {
                CommitFileRevision single = new CommitFileRevision(this.db, root, this.gitPath);
                return new IFileRevision[]{single};
            }
            this.markStartAllRefs(this.walk, "refs/heads/");
            this.markStartAllRefs(this.walk, "refs/remotes/");
            this.markStartAllRefs(this.walk, "refs/tags/");
            this.walk.markStart(root);
        }
        catch (IOException e) {
            IProject project = this.resource.getProject();
            String projectName = project != null ? project.getName() : "";
            Activator.logError(NLS.bind((String)CoreText.GitFileHistory_invalidHeadRevision, (Object)projectName), e);
            return NO_REVISIONS;
        }
        KidCommitList list = new KidCommitList();
        list.source(this.walk);
        try {
            int oldsz;
            do {
                oldsz = list.size();
                list.fillTo(oldsz + 256 - 1);
            } while (oldsz != list.size() && (monitor == null || !monitor.isCanceled()));
        }
        catch (IOException e) {
            Activator.logError(NLS.bind((String)CoreText.GitFileHistory_errorParsingHistory, (Object)this.resource.getFullPath()), e);
            return NO_REVISIONS;
        }
        IFileRevision[] r = new IFileRevision[list.size()];
        int i = 0;
        while (i < r.length) {
            r[i] = new CommitFileRevision(this.db, (RevCommit)list.get(i), this.gitPath);
            ++i;
        }
        return r;
    }

    private void markStartAllRefs(RevWalk theWalk, String prefix) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        for (Map.Entry refEntry : this.db.getRefDatabase().getRefs(prefix).entrySet()) {
            Ref ref = (Ref)refEntry.getValue();
            if (ref.isSymbolic()) continue;
            this.markStartRef(theWalk, ref);
        }
    }

    private void markStartRef(RevWalk theWalk, Ref ref) throws IOException, IncorrectObjectTypeException {
        try {
            RevObject refTarget = theWalk.parseAny((AnyObjectId)ref.getLeaf().getObjectId());
            if (refTarget instanceof RevCommit) {
                theWalk.markStart((RevCommit)refTarget);
            }
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
    }

    public IFileRevision[] getContributors(IFileRevision ifr) {
        String path = this.getGitPath(ifr);
        RevCommit commit = this.getRevCommit(ifr);
        if (path != null && commit != null) {
            IFileRevision[] r = new IFileRevision[commit.getParentCount()];
            int i = 0;
            while (i < r.length) {
                r[i] = new CommitFileRevision(this.db, commit.getParent(i), path);
                ++i;
            }
            return r;
        }
        return NO_REVISIONS;
    }

    public IFileRevision[] getTargets(IFileRevision ifr) {
        String path = this.getGitPath(ifr);
        RevCommit commit = this.getRevCommit(ifr);
        if (path != null && commit instanceof KidCommit) {
            KidCommit c = (KidCommit)commit;
            IFileRevision[] r = new IFileRevision[c.children.length];
            int i = 0;
            while (i < r.length) {
                r[i] = new CommitFileRevision(this.db, c.children[i], path);
                ++i;
            }
            return r;
        }
        return NO_REVISIONS;
    }

    private String getGitPath(IFileRevision revision) {
        IResourceVariant variant;
        if (revision instanceof CommitFileRevision) {
            return ((CommitFileRevision)revision).getGitPath();
        }
        if (revision instanceof IAdaptable && (variant = Utils.getAdapter((IAdaptable)revision, IResourceVariant.class)) instanceof GitRemoteResource) {
            return ((GitRemoteResource)variant).getPath();
        }
        return null;
    }

    private RevCommit getRevCommit(IFileRevision revision) {
        IResourceVariant variant;
        if (revision instanceof CommitFileRevision) {
            return ((CommitFileRevision)revision).getRevCommit();
        }
        if (revision instanceof IAdaptable && (variant = Utils.getAdapter((IAdaptable)revision, IResourceVariant.class)) instanceof GitRemoteResource) {
            RevCommit commit = ((GitRemoteResource)variant).getCommitId();
            try {
                return this.walk.parseCommit((AnyObjectId)commit);
            }
            catch (IOException e) {
                Activator.logError(NLS.bind((String)CoreText.GitFileHistory_invalidCommit, (Object)commit.getName(), (Object)this.resource.getName()), e);
            }
        }
        return null;
    }

    public IFileRevision getFileRevision(String id) {
        if (id == null || id.equals("") || "Workspace".equals(id)) {
            return new WorkspaceFileRevision(this.resource);
        }
        if ("Index".equals(id)) {
            return new IndexFileRevision(this.db, this.gitPath);
        }
        IFileRevision[] iFileRevisionArray = this.revisions;
        int n = this.revisions.length;
        int n2 = 0;
        while (n2 < n) {
            IFileRevision r = iFileRevisionArray[n2];
            if (r.getContentIdentifier().equals(id)) {
                return r;
            }
            ++n2;
        }
        return null;
    }

    public IFileRevision[] getFileRevisions() {
        IFileRevision[] r = new IFileRevision[this.revisions.length];
        System.arraycopy(this.revisions, 0, r, 0, r.length);
        return r;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

