/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.ext;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.util.FileUtil;

public class Q7LaunchingUtil {
    public static final String EXTERNAL_LAUNCH_TYPE = "org.eclipse.rcptt.launching.ext";

    public static ILaunchConfigurationWorkingCopy createQ7LaunchConfiguration(ITargetPlatformHelper target, String sutArgs, String name) throws CoreException {
        ILaunchConfigurationWorkingCopy config = Q7LaunchingUtil.createLaunchConfiguration(target, name);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, sutArgs);
        return config;
    }

    public static ILaunchConfigurationWorkingCopy createLaunchConfiguration(ITargetPlatformHelper target) throws CoreException {
        return Q7LaunchingUtil.createLaunchConfiguration(target, null);
    }

    public static ILaunchConfigurationWorkingCopy createLaunchConfiguration(ITargetPlatformHelper target, String name) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(EXTERNAL_LAUNCH_TYPE);
        if (name == null) {
            name = launchManager.generateLaunchConfigurationName("AUT");
        }
        ILaunchConfigurationWorkingCopy config = type.newInstance(null, name);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, Q7LaunchDelegateUtils.getWorkingDirectory(new File(target.getTargetPlatformProfilePath())).getAbsolutePath());
        Q7LaunchingUtil.updateLaunchConfiguration(target, config);
        return config;
    }

    public static void updateLaunchConfiguration(ITargetPlatformHelper target, ILaunchConfigurationWorkingCopy config) throws CoreException {
        if (target != null) {
            String application;
            Q7TargetPlatformManager.delete(target.getName());
            Q7TargetPlatformManager.setHelper(target.getName(), target);
            config.setAttribute("aut-target-platform", target.getName());
            String product = target.getDefaultProduct();
            if (product != null) {
                config.setAttribute("useProduct", true);
                config.setAttribute("product", product);
            }
            if ((application = target.getDefaultApplication()) != null) {
                config.setAttribute("application", application);
            }
            if (product == null && application == null) {
                throw new CoreException(Q7LaunchingPlugin.createStatus((String)"Failed to launch AUT since there is no Product and Application ID found."));
            }
            config.setAttribute("aut-location", target.getTargetPlatformProfilePath());
            Map<String, String> iniEnvs = target.getIniEnvironment();
            Map configEnvs = config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            if (configEnvs != null) {
                iniEnvs.putAll(configEnvs);
            }
            config.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, iniEnvs);
        }
        config.setAttribute("clearws", false);
        config.setAttribute("askclear", false);
    }

    public static void cleanBundlePool(IProgressMonitor monitor) {
        Q7LaunchingUtil.cleanBundlePool(monitor, false, 30);
    }

    public static List<File> cleanBundlePool(IProgressMonitor monitor, boolean full, int timeout) {
        try {
            IFileArtifactRepository bundlePool = P2TargetUtils.getBundlePool();
            return Q7LaunchingUtil.cleanFileRepository(monitor, full, timeout, bundlePool);
        }
        catch (Throwable e) {
            Q7LaunchingPlugin.log((String)"Failed to clean RCPTT runtime from bundle pool.", (Throwable)e);
            return null;
        }
    }

    public static List<File> cleanFileRepository(IProgressMonitor monitor, boolean full, int timeout, IFileArtifactRepository bundlePool) {
        IQueryable queryable = bundlePool.descriptorQueryable();
        IQueryResult bundlePoolArtifactsQueryResult = queryable.query((IQuery)new ExpressionMatchQuery(IArtifactDescriptor.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]), (IProgressMonitor)new NullProgressMonitor());
        Set bundlePoolArtifacts = bundlePoolArtifactsQueryResult.toSet();
        HashSet<IArtifactDescriptor> artifactsForRemoval = new HashSet<IArtifactDescriptor>();
        if (full) {
            artifactsForRemoval.addAll(bundlePoolArtifacts);
        } else {
            for (IArtifactDescriptor art : bundlePoolArtifacts) {
                String id = art.getArtifactKey().getId();
                if (!Q7LaunchingUtil.isQ7RuntimeArtifact(id)) continue;
                artifactsForRemoval.add(art);
            }
        }
        HashMap<IArtifactDescriptor, File> files = new HashMap<IArtifactDescriptor, File>();
        for (IArtifactDescriptor descr : artifactsForRemoval) {
            files.put(descr, bundlePool.getArtifactFile(descr));
        }
        if (artifactsForRemoval.size() > 0) {
            bundlePool.removeDescriptors(artifactsForRemoval.toArray(new IArtifactDescriptor[artifactsForRemoval.size()]), monitor);
        }
        Q7LaunchingUtil.removeDeletedFilesFromMap(files);
        if (files.size() > 0) {
            Q7LaunchingPlugin.log((String)"Bundle pool is not cleared for first invocation. Try to delete files manually with timeout.");
            long start = System.currentTimeMillis();
            while (start + (long)(1000 * timeout) > System.currentTimeMillis() && files.size() > 0) {
                boolean deleteFiles = FileUtil.deleteFiles((File[])files.values().toArray(new File[files.size()]));
                if (deleteFiles) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {}
                Runtime.getRuntime().gc();
                Q7LaunchingUtil.removeDeletedFilesFromMap(files);
                Q7LaunchingPlugin.log((String)("Bundle pool is not cleared for invocation (files left:" + files.size() + ")"));
            }
        }
        return new ArrayList<File>(files.values());
    }

    private static void removeDeletedFilesFromMap(Map<IArtifactDescriptor, File> files) {
        Iterator<Map.Entry<IArtifactDescriptor, File>> iterator = files.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IArtifactDescriptor, File> entry = iterator.next();
            if (entry.getValue().exists()) continue;
            iterator.remove();
        }
    }

    private static boolean isQ7RuntimeArtifact(String id) {
        return id.contains("org.eclipse.rcptt") || id.contains("org.aspectj") || id.contains("org.eclipse.equinox.weaving");
    }
}

