/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.FileDiffInput;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.UIJob;

public class FileDiffContentProvider
implements IStructuredContentProvider {
    static final int INTERESTING_MARK_TREE_FILTER_INDEX = 0;
    private FileDiff[] diff;
    private TreeFilter markTreeFilter = TreeFilter.ALL;
    private CommitFileDiffViewer viewer;
    private boolean needsRecompute;
    private FileDiffLoader loader;
    private FileDiffInput currentInput;

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        this.cancel();
        this.viewer = (CommitFileDiffViewer)newViewer;
        if (newInput != null) {
            this.currentInput = (FileDiffInput)newInput;
            this.setInterestingPaths(this.currentInput.getInterestingPaths());
        } else {
            this.currentInput = null;
        }
        this.diff = null;
        this.needsRecompute = true;
    }

    void setInterestingPaths(Collection<String> interestingPaths) {
        this.markTreeFilter = interestingPaths != null ? PathFilterGroup.createFromStrings(interestingPaths) : TreeFilter.ALL;
        this.needsRecompute = true;
    }

    public Object[] getElements(Object inputElement) {
        if (!this.needsRecompute) {
            return this.diff != null ? this.diff : new Object[]{};
        }
        this.needsRecompute = false;
        final FileDiffInput input = this.currentInput;
        if (input == null) {
            this.diff = null;
            return new Object[0];
        }
        this.cancel();
        final FileDiffLoader job = new FileDiffLoader(input, this.markTreeFilter);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                UpdateJob updater = new UpdateJob(MessageFormat.format(UIText.FileDiffContentProvider_updatingFileDiffs, input.getCommit().getName()), job);
                updater.schedule();
            }
        });
        job.setUser(false);
        job.setSystem(true);
        this.loader = job;
        this.loader.schedule();
        return new Object[0];
    }

    private void cancel() {
        if (this.loader != null) {
            this.loader.cancel();
            this.loader = null;
        }
    }

    public void dispose() {
        this.cancel();
        this.viewer = null;
        this.diff = null;
        this.currentInput = null;
    }

    private static class FileDiffLoader
    extends Job {
        private FileDiff[] diffs;
        private final FileDiffInput input;
        private final TreeFilter filter;

        public FileDiffLoader(FileDiffInput input, TreeFilter filter) {
            super(MessageFormat.format(UIText.FileDiffContentProvider_computingFileDiffs, input.getCommit().getName()));
            this.input = input;
            this.filter = filter;
            this.setRule(new TreeWalkSchedulingRule(input.getTreeWalk()));
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.diffs = FileDiff.compute(this.input.getRepository(), this.input.getTreeWalk(), this.input.getCommit(), monitor, this.filter);
            }
            catch (IOException err) {
                Activator.handleError(MessageFormat.format(UIText.FileDiffContentProvider_errorGettingDifference, this.input.getCommit().getId()), err, false);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        public FileDiff[] getDiffs() {
            return this.diffs;
        }

        public boolean belongsTo(Object family) {
            return family == JobFamilies.HISTORY_DIFF || super.belongsTo(family);
        }
    }

    private static class TreeWalkSchedulingRule
    implements ISchedulingRule {
        private final TreeWalk treeWalk;

        public TreeWalkSchedulingRule(TreeWalk treeWalk) {
            this.treeWalk = treeWalk;
        }

        public boolean contains(ISchedulingRule rule) {
            if (rule instanceof TreeWalkSchedulingRule) {
                return Objects.equals(this.treeWalk, ((TreeWalkSchedulingRule)rule).treeWalk);
            }
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this.contains(rule);
        }
    }

    private class UpdateJob
    extends UIJob {
        FileDiffLoader loadJob;

        public UpdateJob(String name, FileDiffLoader loadJob) {
            super(name);
            this.loadJob = loadJob;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Control control;
            Control control2 = control = FileDiffContentProvider.this.viewer == null ? null : FileDiffContentProvider.this.viewer.getControl();
            if (control == null || control.isDisposed() || FileDiffContentProvider.this.loader != this.loadJob) {
                return Status.CANCEL_STATUS;
            }
            FileDiffContentProvider.this.diff = this.loadJob.getDiffs();
            FileDiffContentProvider.this.viewer.refresh();
            FileDiff interesting = this.getFirstInterestingElement();
            if (interesting != null) {
                if (FileDiffContentProvider.this.currentInput.isSelectMarked()) {
                    FileDiffContentProvider.this.viewer.setSelection((ISelection)new StructuredSelection((Object)interesting), true);
                } else {
                    FileDiffContentProvider.this.viewer.reveal((Object)interesting);
                }
            }
            return Status.OK_STATUS;
        }

        private FileDiff getFirstInterestingElement() {
            FileDiff[] diffs = FileDiffContentProvider.this.diff;
            if (diffs != null) {
                FileDiff[] fileDiffArray = diffs;
                int n = diffs.length;
                int n2 = 0;
                while (n2 < n) {
                    FileDiff d = fileDiffArray[n2];
                    if (d.isMarked(0)) {
                        return d;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }
}

