/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.storage.WorkspaceFileRevision;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.GitBaseResourceVariantTree;
import org.eclipse.egit.core.synchronize.GitRemoteResource;
import org.eclipse.egit.core.synchronize.GitRemoteResourceVariantTree;
import org.eclipse.egit.core.synchronize.GitResourceVariantComparator;
import org.eclipse.egit.core.synchronize.GitSourceResourceVariantTree;
import org.eclipse.egit.core.synchronize.GitSyncCache;
import org.eclipse.egit.core.synchronize.GitSyncInfo;
import org.eclipse.egit.core.synchronize.GitSyncObjectCache;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.diff.provider.ThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.IResourceVariantTree;
import org.eclipse.team.core.variants.ResourceVariantTreeSubscriber;
import org.eclipse.team.internal.core.mapping.ResourceVariantFileRevision;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;

public class GitResourceVariantTreeSubscriber
extends ResourceVariantTreeSubscriber {
    private GitSourceResourceVariantTree sourceTree;
    private GitRemoteResourceVariantTree remoteTree;
    private GitBaseResourceVariantTree baseTree;
    private GitSynchronizeDataSet gsds;
    private IResource[] roots;
    private GitSyncCache cache;
    private GitSyncInfoToDiffConverter syncInfoConverter = new GitSyncInfoToDiffConverter();

    public GitResourceVariantTreeSubscriber(GitSynchronizeDataSet data) {
        this.gsds = data;
    }

    public void init(IProgressMonitor monitor) {
        monitor.beginTask(CoreText.GitResourceVariantTreeSubscriber_fetchTaskName, this.gsds.size());
        try {
            this.cache = GitSyncCache.getAllData(this.gsds, monitor);
        }
        finally {
            monitor.done();
        }
    }

    public boolean isSupervised(IResource res) throws TeamException {
        return this.gsds.contains(res.getProject()) && this.gsds.shouldBeIncluded(res);
    }

    public IResource[] members(IResource res) throws TeamException {
        if (res.getType() == 1 || !this.gsds.shouldBeIncluded(res)) {
            return new IResource[0];
        }
        GitSynchronizeData gsd = this.gsds.getData(res.getProject());
        Repository repo = gsd.getRepository();
        GitSyncObjectCache repoCache = this.cache.get(repo);
        ArrayList<Object> allMembers = new ArrayList<Object>();
        HashMap<String, IResource> existingMembers = new HashMap<String, IResource>();
        String path = Repository.stripWorkDir((File)repo.getWorkTree(), (File)res.getLocation().toFile());
        GitSyncObjectCache cachedMembers = repoCache.get(path);
        try {
            Collection<GitSyncObjectCache> members;
            IContainer container = (IContainer)res;
            if (container.exists()) {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    existingMembers.put(member.getName(), member);
                    ++n2;
                }
            }
            if (cachedMembers != null && (members = cachedMembers.members()) != null) {
                for (GitSyncObjectCache gitMember : members) {
                    String name = gitMember.getName();
                    IResource existing = (IResource)existingMembers.get(name);
                    if (existing != null) {
                        allMembers.add(existing);
                    }
                    if (existing != null && existing.getType() != 1 == gitMember.getDiffEntry().isTree()) continue;
                    Path localPath = new Path(name);
                    if (gitMember.getDiffEntry().isTree()) {
                        allMembers.add(container.getFolder((IPath)localPath));
                        continue;
                    }
                    allMembers.add(container.getFile((IPath)localPath));
                }
            }
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
        return allMembers.toArray(new IResource[0]);
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 8) {
                this.cache = GitSyncCache.getAllData(this.gsds, monitor);
                super.refresh(resources, depth, monitor);
                return;
            }
            ++n2;
        }
        HashMap<GitSynchronizeData, Collection<String>> updateRequests = new HashMap<GitSynchronizeData, Collection<String>>();
        IResource[] iResourceArray2 = resources;
        int n3 = resources.length;
        n = 0;
        while (n < n3) {
            RepositoryMapping mapping;
            IResource resource = iResourceArray2[n];
            IProject project = resource.getProject();
            GitSynchronizeData data = this.gsds.getData(project.getName());
            if (data != null && (mapping = RepositoryMapping.getMapping(project)) != null) {
                String path;
                ArrayList<String> paths = (ArrayList<String>)updateRequests.get(data);
                if (paths == null) {
                    paths = new ArrayList<String>();
                    updateRequests.put(data, paths);
                }
                if ((path = mapping.getRepoRelativePath(resource)) == null) {
                    path = "";
                }
                paths.add(path);
            }
            ++n;
        }
        if (!updateRequests.isEmpty()) {
            GitSyncCache.mergeAllDataIntoCache(updateRequests, monitor, this.cache);
        }
        super.refresh(resources, depth, monitor);
    }

    public IResource[] roots() {
        if (this.roots == null) {
            this.roots = this.gsds.getAllProjects();
        }
        if (this.roots == null) {
            return new IResource[0];
        }
        IResource[] result = new IResource[this.roots.length];
        System.arraycopy(this.roots, 0, result, 0, this.roots.length);
        return result;
    }

    public void reset(GitSynchronizeDataSet data) {
        this.gsds = data;
        this.roots = null;
        this.sourceTree = null;
        this.baseTree = null;
        this.remoteTree = null;
    }

    public void dispose() {
        if (this.sourceTree != null) {
            this.sourceTree.dispose();
        }
        if (this.baseTree != null) {
            this.baseTree.dispose();
        }
        if (this.remoteTree != null) {
            this.remoteTree.dispose();
        }
        this.gsds.dispose();
    }

    protected GitSynchronizeDataSet getDataSet() {
        return this.gsds;
    }

    protected GitSyncCache getCache() {
        return this.cache;
    }

    public IDiff getDiff(IResource resource) throws CoreException {
        GitSynchronizeData syncData = this.gsds.getData(resource.getProject());
        if (syncData == null || syncData.shouldIncludeLocal()) {
            return super.getDiff(resource);
        }
        SyncInfo info = this.getSyncInfo(resource);
        if (info == null || info.getKind() == 0) {
            return null;
        }
        return this.syncInfoConverter.getDeltaFor(info);
    }

    public String getName() {
        return CoreText.GitBranchResourceVariantTreeSubscriber_gitRepository;
    }

    public IResourceVariantComparator getResourceComparator() {
        return new GitResourceVariantComparator(this.gsds);
    }

    protected IResourceVariantTree getSourceTree() {
        if (this.sourceTree == null) {
            this.sourceTree = new GitSourceResourceVariantTree(this.cache, this.gsds);
        }
        return this.sourceTree;
    }

    public IFileRevision getSourceFileRevision(IFile resource) throws TeamException {
        return this.syncInfoConverter.getLocalFileRevision(resource);
    }

    protected IResourceVariantTree getBaseTree() {
        if (this.baseTree == null) {
            this.baseTree = new GitBaseResourceVariantTree(this.cache, this.gsds);
        }
        return this.baseTree;
    }

    protected IResourceVariantTree getRemoteTree() {
        if (this.remoteTree == null) {
            this.remoteTree = new GitRemoteResourceVariantTree(this.cache, this.gsds);
        }
        return this.remoteTree;
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        Repository repo = this.gsds.getData(local.getProject()).getRepository();
        return this.getSyncInfo(local, base, remote, repo);
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote, Repository repo) throws TeamException {
        GitSyncInfo info = new GitSyncInfo(local, base, remote, this.getResourceComparator(), this.cache.get(repo), repo);
        info.init();
        return info;
    }

    private static class GitResourceVariantFileRevision
    extends ResourceVariantFileRevision {
        private final IResourceVariant variant;

        public GitResourceVariantFileRevision(IResourceVariant variant) {
            super(variant);
            this.variant = variant;
        }

        public String getContentIdentifier() {
            if (this.variant instanceof GitRemoteResource) {
                return ((GitRemoteResource)this.variant).getCommitId().getId().getName();
            }
            return super.getContentIdentifier();
        }

        public long getTimestamp() {
            PersonIdent author;
            if (this.variant instanceof GitRemoteResource && (author = ((GitRemoteResource)this.variant).getCommitId().getAuthorIdent()) != null) {
                return author.getWhen().getTime();
            }
            return super.getTimestamp();
        }

        public String getAuthor() {
            PersonIdent author;
            if (this.variant instanceof GitRemoteResource && (author = ((GitRemoteResource)this.variant).getCommitId().getAuthorIdent()) != null) {
                return author.getName();
            }
            return super.getAuthor();
        }

        public String getComment() {
            if (this.variant instanceof GitRemoteResource) {
                return ((GitRemoteResource)this.variant).getCommitId().getFullMessage();
            }
            return super.getComment();
        }
    }

    private class GitSyncInfoToDiffConverter
    extends SyncInfoToDiffConverter {
        private GitSyncInfoToDiffConverter() {
        }

        public IDiff getDeltaFor(SyncInfo info) {
            if (info.getComparator().isThreeWay()) {
                ITwoWayDiff local = this.getLocalDelta(info);
                ITwoWayDiff remote = this.getRemoteDelta(info);
                return new ThreeWayDiff(local, remote);
            }
            if (info.getKind() != 0) {
                IResourceVariant remote = info.getRemote();
                IResource local = info.getLocal();
                int kind = remote == null ? 2 : (!local.exists() ? 1 : 4);
                if (local.getType() == 1) {
                    IFileRevision after = this.asFileState(remote);
                    IFileRevision before = this.getLocalFileRevision((IFile)local);
                    return new ResourceDiff(info.getLocal(), kind, 0, before, after);
                }
                return new ResourceDiff(info.getLocal(), kind);
            }
            return null;
        }

        private ITwoWayDiff getLocalDelta(SyncInfo info) {
            int direction = SyncInfo.getDirection((int)info.getKind());
            if (direction == 4 || direction == 12) {
                IResourceVariant ancestor = info.getBase();
                IResource local = info.getLocal();
                int kind = ancestor == null ? 1 : (!local.exists() ? 2 : 4);
                if (local.getType() == 1) {
                    IFileRevision before = this.asFileState(ancestor);
                    IFileRevision after = this.getLocalFileRevision((IFile)local);
                    return new ResourceDiff(info.getLocal(), kind, 0, before, after);
                }
                return new ResourceDiff(info.getLocal(), kind);
            }
            return null;
        }

        protected IFileRevision getLocalFileRevision(IFile local) {
            GitSynchronizeData data = GitResourceVariantTreeSubscriber.this.gsds.getData(local.getProject());
            if (data.shouldIncludeLocal()) {
                return new WorkspaceFileRevision((IResource)local);
            }
            try {
                return this.asFileState(GitResourceVariantTreeSubscriber.this.getSourceTree().getResourceVariant((IResource)local));
            }
            catch (TeamException e) {
                String error = NLS.bind((String)CoreText.GitResourceVariantTreeSubscriber_CouldNotFindSourceVariant, (Object)local.getName());
                Activator.logError(error, e);
                return new WorkspaceFileRevision((IResource)local);
            }
        }

        private ITwoWayDiff getRemoteDelta(SyncInfo info) {
            int direction = SyncInfo.getDirection((int)info.getKind());
            if (direction == 8 || direction == 12) {
                IResourceVariant ancestor = info.getBase();
                IResourceVariant remote = info.getRemote();
                int kind = ancestor == null ? 1 : (remote == null ? 2 : 4);
                if (info.getLocal().getType() == 1) {
                    IFileRevision before = this.asFileState(ancestor);
                    IFileRevision after = this.asFileState(remote);
                    return new ResourceDiff(info.getLocal(), kind, 0, before, after);
                }
                return new ResourceDiff(info.getLocal(), kind);
            }
            return null;
        }

        private IFileRevision asFileState(IResourceVariant variant) {
            if (variant == null) {
                return null;
            }
            return this.asFileRevision(variant);
        }

        protected ResourceVariantFileRevision asFileRevision(IResourceVariant variant) {
            return new GitResourceVariantFileRevision(variant);
        }
    }
}

