/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import java.io.EOFException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.util.Statuses;
import org.eclipse.rcptt.ecl.interop.InteropFactory;
import org.eclipse.rcptt.internal.launching.EclStackTrace;
import org.eclipse.rcptt.internal.launching.ExecutionStatus;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.runner.RunnerConfiguration;
import org.eclipse.rcptt.runner.util.AutThread;
import org.eclipse.rcptt.runner.util.ResultsHandler;

public class TestResult {
    public final boolean failed;
    public final boolean skipped;
    public final String name;
    public final String reason;
    public final long time;
    public final boolean timeout;
    public final boolean connectionUnavailable;
    public long memory;

    public TestResult(boolean failed, boolean skipped, String name, String reason, long time, boolean timeout, boolean connectionUnavailable) {
        this.failed = failed;
        this.skipped = skipped;
        this.name = name;
        this.reason = reason;
        this.time = time;
        this.timeout = timeout;
        this.connectionUnavailable = connectionUnavailable;
    }

    public TestResult withAdditionalInfo(RunnerConfiguration conf, AutThread thread) {
        if (conf.outputMemoryUsage) {
            try {
                this.memory = (Long)thread.launch.execute((Command)InteropFactory.eINSTANCE.createGetMemoryUsage());
            }
            catch (Throwable e) {
                ResultsHandler.log("Cannot get the memory usage information", e);
            }
        }
        return this;
    }

    public String userFriendlyMessage(int est, int timeLeft, int processed, int artifacts, int failedCount) {
        String remaining = String.format("%d:%02d mins", est / 60, est % 60);
        String elapsed = String.format("%d:%02d", timeLeft / 60, timeLeft % 60);
        String usedMB = String.format("%.1fMB", Float.valueOf((float)this.memory / 1024.0f / 1024.0f));
        String status = "Pass";
        if (this.failed) {
            status = "Fail";
        } else if (this.skipped) {
            status = "Skip";
        }
        return String.format("%s %s (%s) processed. %s failed. spent: %s, %s remaining. %s. time: %sms %s%s", status, "" + processed, "" + artifacts, "" + failedCount, elapsed, remaining, this.name, this.time, this.reason.length() > 0 ? " Cause: " + this.reason : "", this.memory > 0L ? "\nUsed memory: " + usedMB : "");
    }

    public static TestResult collectFrom(IExecutable[] executables, String testName, long totalTime) {
        String reason = "";
        boolean failed = false;
        boolean skipped = false;
        boolean timeout = false;
        boolean connectionUnavailable = false;
        IExecutable[] iExecutableArray = executables;
        int n = executables.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutable executable = iExecutableArray[n2];
            IStatus resultStatus = executable.getResultStatus();
            if (!executable.getResultStatus().isOK()) {
                reason = "";
                if (resultStatus != null) {
                    if (Statuses.hasCode((IStatus)resultStatus, (int)123130)) {
                        timeout = true;
                    }
                    reason = resultStatus.getMessage();
                    if (resultStatus instanceof ExecutionStatus) {
                        reason = EclStackTrace.fromExecStatus((ExecutionStatus)((ExecutionStatus)resultStatus)).getDisplayMessage();
                    }
                    if (resultStatus.getException() instanceof EOFException) {
                        connectionUnavailable = true;
                    }
                }
                failed = true;
            }
            ++n2;
        }
        return new TestResult(failed, skipped, testName, reason, totalTime, timeout, connectionUnavailable);
    }
}

