/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetPersistence34Helper;
import org.eclipse.pde.internal.core.target.TargetPersistence35Helper;
import org.eclipse.pde.internal.core.target.TargetPersistence36Helper;
import org.eclipse.pde.internal.core.target.TargetPersistence38Helper;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TargetDefinitionPersistenceHelper {
    static final String ROOT = "target";
    static final String ATTR_NAME = "name";
    static final String LOCATIONS = "locations";
    static final String LOCATION = "location";
    static final String ATTR_LOCATION_PATH = "path";
    static final String ATTR_LOCATION_TYPE = "type";
    static final String ATTR_USE_DEFAULT = "useDefault";
    static final String INCLUDE_BUNDLES = "includeBundles";
    static final String ENVIRONMENT = "environment";
    static final String OS = "os";
    static final String WS = "ws";
    static final String ARCH = "arch";
    static final String NL = "nl";
    static final String TARGET_JRE = "targetJRE";
    static final String EXEC_ENV = "execEnv";
    static final String JRE_NAME = "jreName";
    static final String ARGUMENTS = "launcherArgs";
    static final String PROGRAM_ARGS = "programArgs";
    static final String VM_ARGS = "vmArgs";
    static final String IMPLICIT = "implicitDependencies";
    static final String PLUGIN = "plugin";
    static final String PDE_INSTRUCTION = "pde";
    static final String ATTR_ID = "id";
    static final String INSTALLABLE_UNIT = "unit";
    static final String REPOSITORY = "repository";
    static final String ATTR_INCLUDE_MODE = "includeMode";
    public static final String MODE_SLICER = "slicer";
    public static final String MODE_PLANNER = "planner";
    static final String ATTR_INCLUDE_ALL_PLATFORMS = "includeAllPlatforms";
    static final String ATTR_INCLUDE_SOURCE = "includeSource";
    static final String ATTR_INCLUDE_CONFIGURE_PHASE = "includeConfigurePhase";
    static final String ATTR_VERSION = "version";
    static final String ATTR_CONFIGURATION = "configuration";
    static final String ATTR_SEQUENCE_NUMBER = "sequenceNumber";
    static final String CONTENT = "content";
    static final String ATTR_USE_ALL = "useAllPlugins";
    static final String PLUGINS = "plugins";
    static final String FEATURES = "features";
    static final String FEATURE = "feature";
    static final String EXTRA_LOCATIONS = "extraLocations";
    private static ITargetPlatformService fTargetService;

    public static void persistXML(ITargetDefinition definition, OutputStream output) throws CoreException, ParserConfigurationException, TransformerException, IOException, SAXException {
        Document document = definition.getDocument();
        DOMSource source = new DOMSource(document);
        StreamResult outputTarget = new StreamResult(output);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, outputTarget);
    }

    public static void initFromXML(ITargetDefinition definition, InputStream input) throws CoreException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        parser.setErrorHandler(new DefaultHandler());
        Document doc = parser.parse(new InputSource(input));
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equalsIgnoreCase(ROOT)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.TargetDefinitionPersistenceHelper_0));
        }
        String version = null;
        NodeList list = doc.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            ProcessingInstruction instruction;
            Node node = list.item(i);
            if (node.getNodeType() == 7 && (instruction = (ProcessingInstruction)node).getTarget() == PDE_INSTRUCTION) {
                String data = instruction.getData();
                Pattern pattern = Pattern.compile("version=\"(.*)\"");
                Matcher matcher = pattern.matcher(data);
                if (matcher.matches()) {
                    version = matcher.group(1);
                    break;
                }
            }
            ++i;
        }
        definition.setDocument(null);
        if (version == null || version.length() == 0) {
            TargetPersistence38Helper.initFromDoc(definition, root);
        } else if (version.equals("3.8")) {
            TargetPersistence38Helper.initFromDoc(definition, root);
        } else if (version.equals("3.6")) {
            TargetPersistence36Helper.initFromDoc(definition, root);
        } else if (version.equals("3.5")) {
            TargetPersistence35Helper.initFromDoc(definition, root);
        } else if (version.compareTo("3.4") <= 0) {
            TargetPersistence34Helper.initFromDoc(definition, root);
        } else {
            String name = root.getAttribute(ATTR_NAME);
            PDECore.log((IStatus)new Status(2, "org.eclipse.pde.core", MessageFormat.format(Messages.TargetDefinitionPersistenceHelper_2, version, name)));
            TargetPersistence38Helper.initFromDoc(definition, root);
        }
        definition.setDocument(doc);
    }

    static ITargetPlatformService getTargetPlatformService() throws CoreException {
        if (fTargetService == null && (fTargetService = PDECore.getDefault().acquireService(ITargetPlatformService.class)) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.TargetDefinitionPersistenceHelper_1));
        }
        return fTargetService;
    }

    static String getTextContent(Element element) throws DOMException {
        NodeList children = element.getChildNodes();
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < children.getLength()) {
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() == 3) {
                result.append(currentNode.getNodeValue());
            }
            ++i;
        }
        return result.toString();
    }
}

