/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.rcptt.core.ecl.model.Declaration;
import org.eclipse.rcptt.core.ecl.parser.ast.Reference;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.context.ContextEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclTextHyperLinkDetector;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class EclOpenDeclarationAction
extends Action {
    private EclEditor eclEditor;

    public EclOpenDeclarationAction(EclEditor editor) {
        super("Open Declaration");
        this.eclEditor = editor;
    }

    public boolean isEnabled() {
        return this.getReference() != null;
    }

    private Reference getReference() {
        ISelectionProvider selectionProvider = this.eclEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        int offset = ((ITextSelection)selection).getOffset();
        TextViewer viewer = this.eclEditor.doGetSourceViewer();
        Reference reference = EclTextHyperLinkDetector.getReferenceAtPoint((ITextViewer)viewer, offset);
        return reference;
    }

    public void run() {
        Reference reference = this.getReference();
        if (reference != null) {
            EclOpenDeclarationAction.openDeclaration(reference.dest);
        }
    }

    public static void openDeclaration(Declaration reference) {
        IQ7NamedElement element = Q7SearchCore.findById((String)reference.container.getResource());
        IResource resource = element.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        try {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)WorkbenchUtils.getPage(), (IFile)((IFile)element.getResource()));
            if (editor instanceof EclEditor) {
                ((EclEditor)editor).selectAndReveal(reference.location.begin, reference.location.length());
            } else if (editor instanceof ContextEditor) {
                IEditorPart innerPart = ((ContextEditor)editor).getEditor();
                if (innerPart instanceof EclEditor) {
                    ((EclEditor)innerPart).selectAndReveal(reference.location.begin, reference.location.length());
                } else {
                    ((ContextEditor)editor).setSelectionAtLine(reference.location.begin);
                }
            }
        }
        catch (PartInitException e) {
            Q7UIPlugin.log("Error opening editor", e);
            return;
        }
    }
}

