/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

public class TagOperation
implements IEGitOperation {
    private final TagBuilder tag;
    private final Repository repo;
    private RefUpdate.Result result;
    private final boolean shouldMoveTag;
    private final boolean annotated;

    public TagOperation(Repository repo, TagBuilder tag, boolean shouldMoveTag, boolean annotated) {
        this.tag = tag;
        this.repo = repo;
        this.shouldMoveTag = shouldMoveTag;
        this.annotated = annotated;
    }

    public TagOperation(Repository repo, TagBuilder tag, boolean shouldMoveTag) {
        this(repo, tag, shouldMoveTag, true);
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        progress.setTaskName(NLS.bind((String)CoreText.TagOperation_performingTagging, (Object)this.tag.getTag()));
        ObjectId tagId = this.annotated ? this.updateTagObject() : this.tag.getObjectId();
        progress.worked(1);
        this.updateRepo(tagId);
        progress.worked(1);
    }

    @NonNull
    public RefUpdate.Result getResult() {
        RefUpdate.Result r = this.result;
        return r == null ? RefUpdate.Result.NOT_ATTEMPTED : r;
    }

    private void updateRepo(ObjectId tagId) throws TeamException {
        String refName = "refs/tags/" + this.tag.getTag();
        try {
            RefUpdate.Result updateResult;
            RefUpdate tagRef = this.repo.updateRef(refName);
            tagRef.setNewObjectId((AnyObjectId)tagId);
            tagRef.setForceUpdate(this.shouldMoveTag);
            this.result = updateResult = tagRef.update();
            switch (updateResult) {
                case NO_CHANGE: 
                case NEW: 
                case FORCED: {
                    break;
                }
                default: {
                    throw new TeamException(NLS.bind((String)CoreText.TagOperation_taggingFailure, (Object)this.tag.getTag(), (Object)updateResult));
                }
            }
        }
        catch (IOException e) {
            throw new TeamException(NLS.bind((String)CoreText.TagOperation_taggingFailure, (Object)this.tag.getTag(), (Object)e.getMessage()), (Throwable)e);
        }
    }

    private ObjectId updateTagObject() throws TeamException {
        ObjectId startPointRef = this.tag.getObjectId();
        try {
            ObjectId tagId;
            this.repo.open((AnyObjectId)startPointRef);
            Throwable throwable = null;
            Object var4_4 = null;
            try (ObjectInserter inserter = this.repo.newObjectInserter();){
                tagId = inserter.insert(this.tag);
                inserter.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return tagId;
        }
        catch (IOException e) {
            throw new TeamException(NLS.bind((String)CoreText.TagOperation_objectIdNotFound, (Object)this.tag.getTag(), (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }
}

