/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.GitResourceDeltaVisitor;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.op.AddToIndexOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;

public class GitSubscriberMergeContext
extends SubscriberMergeContext {
    private final GitSynchronizeDataSet gsds;
    private final IndexDiffChangedListener indexChangeListener;
    private final IResourceChangeListener resourceChangeListener;
    private final GitResourceVariantTreeSubscriber subscriber;

    public GitSubscriberMergeContext(GitResourceVariantTreeSubscriber subscriber, ISynchronizationScopeManager manager, GitSynchronizeDataSet gsds) {
        super((Subscriber)subscriber, manager);
        this.subscriber = subscriber;
        this.gsds = gsds;
        this.indexChangeListener = (repository, indexDiffData) -> this.handleRepositoryChange(repository);
        this.resourceChangeListener = event -> {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                this.handleResourceChange(delta);
            }
        };
        IndexDiffCache indexDiffCache = Activator.getDefault().getIndexDiffCache();
        if (indexDiffCache != null) {
            indexDiffCache.addIndexDiffChangedListener(this.indexChangeListener);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        this.initialize();
    }

    public void markAsMerged(IDiff node, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        IResource resource = this.getDiffTree().getResource(node);
        AddToIndexOperation operation = new AddToIndexOperation(new IResource[]{resource});
        operation.execute(monitor);
    }

    public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
    }

    public GitSynchronizeDataSet getSyncData() {
        return this.gsds;
    }

    protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
    }

    public void dispose() {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return;
        }
        IndexDiffCache indexDiffCache = activator.getIndexDiffCache();
        if (indexDiffCache != null) {
            indexDiffCache.removeIndexDiffChangedListener(this.indexChangeListener);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.subscriber.dispose();
        super.dispose();
    }

    private void handleRepositoryChange(Repository which) {
        boolean shouldRefresh = false;
        for (GitSynchronizeData gsd : this.gsds) {
            if (!which.equals(gsd.getRepository())) continue;
            this.updateRevs(gsd);
            shouldRefresh = true;
        }
        if (!shouldRefresh) {
            return;
        }
        this.subscriber.reset(this.gsds);
        ResourceTraversal[] traversals = this.getScopeManager().getScope().getTraversals();
        try {
            this.subscriber.refresh(traversals, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamException e) {
            Activator.logError(CoreText.GitSubscriberMergeContext_FailedRefreshSyncView, e);
        }
    }

    private void handleResourceChange(IResourceDelta delta) {
        IResourceDelta[] children;
        IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta resourceDelta = iResourceDeltaArray[n2];
            IResource resource = resourceDelta.getResource();
            RepositoryMapping mapping = RepositoryMapping.getMapping(resource);
            if (mapping != null) {
                this.scanDeltaAndRefresh(mapping, resourceDelta);
            }
            ++n2;
        }
    }

    private void scanDeltaAndRefresh(RepositoryMapping mapping, IResourceDelta delta) {
        Repository repo = mapping.getRepository();
        GitResourceDeltaVisitor visitor = new GitResourceDeltaVisitor(repo);
        try {
            delta.accept((IResourceDeltaVisitor)visitor);
            Collection<IFile> files = visitor.getFileResourcesToUpdate();
            if (files != null && files.isEmpty()) {
                return;
            }
            for (GitSynchronizeData gsd : this.gsds) {
                if (!repo.equals(gsd.getRepository())) continue;
                this.refreshResources(files);
            }
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    private void refreshResources(Collection<IFile> resources) {
        IResource[] files = resources.toArray(new IResource[0]);
        try {
            this.subscriber.refresh(files, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.logError(CoreText.GitSubscriberMergeContext_FailedRefreshSyncView, e);
        }
    }

    private void updateRevs(GitSynchronizeData gsd) {
        try {
            gsd.updateRevs();
        }
        catch (IOException e) {
            Activator.logError(CoreText.GitSubscriberMergeContext_FailedUpdateRevs, e);
            return;
        }
    }
}

