/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.ResourcePropertyTester;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchAdapter;

public class RepositoryTreeNodeWorkbenchAdapter
extends WorkbenchAdapter {
    public static final RepositoryTreeNodeWorkbenchAdapter INSTANCE = new RepositoryTreeNodeWorkbenchAdapter();

    private RepositoryTreeNodeWorkbenchAdapter() {
    }

    public Object getParent(Object object) {
        return ((RepositoryTreeNode)object).getParent();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (object == null) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)object;
        switch (node.getType()) {
            case FILE: {
                Object item = node.getObject();
                if (!(item instanceof File)) break;
                return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(((File)item).getName());
            }
            case REPO: {
                Object item = node.getObject();
                if (!(item instanceof Repository) || !ResourcePropertyTester.hasGerritConfiguration((Repository)item)) break;
                return UIIcons.REPOSITORY_GERRIT;
            }
            case TAG: {
                if (!((TagNode)node).isAnnotated()) break;
                return UIIcons.TAG_ANNOTATED;
            }
        }
        return node.getType().getIcon();
    }

    public String getLabel(Object object) {
        RepositoryTreeNode node = (RepositoryTreeNode)object;
        switch (node.getType()) {
            case REPO: {
                Repository repository = (Repository)node.getObject();
                return GitLabels.getPlainShortLabel(repository);
            }
            case REPOGROUP: {
                return ((RepositoryGroup)node.getObject()).getName();
            }
            case FOLDER: 
            case FILE: {
                return ((File)node.getObject()).getName();
            }
            case BRANCHES: {
                return UIText.RepositoriesView_Branches_Nodetext;
            }
            case LOCAL: {
                return UIText.RepositoriesViewLabelProvider_LocalNodetext;
            }
            case REMOTETRACKING: {
                return UIText.RepositoriesViewLabelProvider_RemoteTrackingNodetext;
            }
            case BRANCHHIERARCHY: {
                IPath fullPath = (IPath)node.getObject();
                return fullPath.lastSegment();
            }
            case TAGS: {
                return UIText.RepositoriesViewLabelProvider_TagsNodeText;
            }
            case ADDITIONALREFS: {
                return UIText.RepositoriesViewLabelProvider_SymbolicRefNodeText;
            }
            case REMOTES: {
                return UIText.RepositoriesView_RemotesNodeText;
            }
            case SUBMODULES: {
                return UIText.RepositoriesViewLabelProvider_SubmodulesNodeText;
            }
            case STASH: {
                return UIText.RepositoriesViewLabelProvider_StashNodeText;
            }
            case STASHED_COMMIT: {
                return MessageFormat.format("{0}@'{'{1}'}'", "stash", ((StashedCommitNode)node).getIndex());
            }
            case REF: 
            case TAG: {
                Ref ref = (Ref)node.getObject();
                String refName = Repository.shortenRefName((String)ref.getName());
                if (node.getParent().getType() == RepositoryTreeNodeType.BRANCHHIERARCHY) {
                    refName = refName.substring(refName.lastIndexOf(47) + 1);
                }
                return refName;
            }
            case ADDITIONALREF: {
                Ref ref = (Ref)node.getObject();
                return Repository.shortenRefName((String)ref.getName());
            }
            case WORKINGDIR: {
                return UIText.RepositoriesView_WorkingDir_treenode;
            }
        }
        return (String)node.getObject();
    }
}

