/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.RequirementHelper;
import org.osgi.framework.Version;

public class BundleLauncherHelper {
    public static final String DEFAULT_UPDATE_CONFIGURATOR_START_LEVEL_TEXT = "3";
    public static final String DEFAULT_UPDATE_CONFIGURATOR_AUTO_START_TEXT = "true";
    public static final String DEFAULT_UPDATE_CONFIGURATOR_START_LEVEL = "3:true";
    public static final char VERSION_SEPARATOR = '*';

    public static Map<IPluginModelBase, String> getWorkspaceBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getWorkspaceBundleMap(configuration, null);
    }

    public static Map<IPluginModelBase, String> getTargetBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getTargetBundleMap(configuration, null);
    }

    public static Map<IPluginModelBase, String> getMergedBundleMap(ILaunchConfiguration configuration, boolean osgi) throws CoreException {
        Map<Object, Object> map = new LinkedHashMap();
        if (!osgi) {
            BundleLauncherHelper.migrateLaunchConfiguration(configuration);
            if (configuration.getAttribute("default", true)) {
                IPluginModelBase[] models;
                IPluginModelBase[] iPluginModelBaseArray = models = PluginRegistry.getActiveModels();
                int n = models.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginModelBase model = iPluginModelBaseArray[n2];
                    BundleLauncherHelper.addBundleToMap(map, model, "default:default");
                    ++n2;
                }
                return map;
            }
        } else {
            BundleLauncherHelper.migrateOsgiLaunchConfiguration(configuration);
        }
        if (configuration.getAttribute("useCustomFeatures", false)) {
            Object pluginResolution;
            Object id;
            IFeatureModel[] workspaceFeatureModels;
            String defaultLocation = configuration.getAttribute("featureDefaultLocation", "workspace");
            String defaultPluginResolution = configuration.getAttribute("featurePluginResolution", "workspace");
            HashMap<IFeatureModel[], IFeatureModel> workspaceFeatureMap = new HashMap<IFeatureModel[], IFeatureModel>();
            HashMap<String, IFeatureModel> externalFeatureMap = new HashMap<String, IFeatureModel>();
            FeatureModelManager fmm = PDECore.getDefault().getFeatureModelManager();
            IFeatureModel[] iFeatureModelArray = workspaceFeatureModels = fmm.getWorkspaceModels();
            int n = workspaceFeatureModels.length;
            int n3 = 0;
            while (n3 < n) {
                IFeatureModel workspaceFeatureModel = iFeatureModelArray[n3];
                id = workspaceFeatureModel.getFeature().getId();
                workspaceFeatureMap.put((IFeatureModel[])id, workspaceFeatureModel);
                ++n3;
            }
            IFeatureModel[] externalFeatureModels = fmm.getExternalModels();
            id = externalFeatureModels;
            int n4 = externalFeatureModels.length;
            n = 0;
            while (n < n4) {
                IFeatureModel externalFeatureModel = id[n];
                String id2 = externalFeatureModel.getFeature().getId();
                externalFeatureMap.put(id2, externalFeatureModel);
                ++n;
            }
            HashMap<String, String> featureResolutionMap = new HashMap<String, String>();
            Set selectedFeatures = configuration.getAttribute("selected_features", null);
            if (selectedFeatures != null) {
                for (String currentSelected : selectedFeatures) {
                    String[] attributes = currentSelected.split(":");
                    if (attributes.length <= 1) continue;
                    featureResolutionMap.put(attributes[0], attributes[1]);
                }
            }
            HashSet<IPluginModelBase> launchPlugins = new HashSet<IPluginModelBase>();
            for (Map.Entry entry : featureResolutionMap.entrySet()) {
                IFeatureImport[] featureImports;
                String id3 = (String)entry.getKey();
                IFeatureModel featureModel = null;
                if ("workspace".equalsIgnoreCase(defaultLocation)) {
                    featureModel = (IFeatureModel)workspaceFeatureMap.get(id3);
                }
                if ((featureModel == null || "external".equalsIgnoreCase(defaultLocation)) && externalFeatureMap.containsKey(id3)) {
                    featureModel = (IFeatureModel)externalFeatureMap.get(id3);
                }
                if (featureModel == null) continue;
                IFeaturePlugin[] featurePlugins = featureModel.getFeature().getPlugins();
                pluginResolution = (String)entry.getValue();
                if ("default".equalsIgnoreCase((String)pluginResolution)) {
                    pluginResolution = defaultPluginResolution;
                }
                IFeaturePlugin[] iFeaturePluginArray = featurePlugins;
                int n5 = featurePlugins.length;
                int n6 = 0;
                while (n6 < n5) {
                    IPluginModelBase model;
                    IFeaturePlugin featurePlugin = iFeaturePluginArray[n6];
                    ModelEntry modelEntry = PluginRegistry.findEntry((String)featurePlugin.getId());
                    if (modelEntry != null && (model = BundleLauncherHelper.findModel(modelEntry, featurePlugin.getVersion(), (String)pluginResolution)) != null) {
                        launchPlugins.add(model);
                    }
                    ++n6;
                }
                IFeatureImport[] iFeatureImportArray = featureImports = featureModel.getFeature().getImports();
                int n7 = featureImports.length;
                n5 = 0;
                while (n5 < n7) {
                    IPluginModelBase model;
                    ModelEntry modelEntry;
                    IFeatureImport featureImport = iFeatureImportArray[n5];
                    if (featureImport.getType() == 0 && (modelEntry = PluginRegistry.findEntry((String)featureImport.getId())) != null && (model = BundleLauncherHelper.findModel(modelEntry, featureImport.getVersion(), (String)pluginResolution)) != null) {
                        launchPlugins.add(model);
                    }
                    ++n5;
                }
            }
            Map<IPluginModelBase, AdditionalPluginData> additionalPlugins = BundleLauncherHelper.getAdditionalPlugins(configuration, true);
            launchPlugins.addAll(additionalPlugins.keySet());
            if (!osgi) {
                String[] applicationIds;
                pluginResolution = applicationIds = RequirementHelper.getApplicationRequirements(configuration);
                int featurePlugins = applicationIds.length;
                int featureModel = 0;
                while (featureModel < featurePlugins) {
                    IPluginModelBase model;
                    String applicationId = pluginResolution[featureModel];
                    ModelEntry modelEntry = PluginRegistry.findEntry((String)applicationId);
                    if (modelEntry != null && (model = BundleLauncherHelper.findModel(modelEntry, null, defaultPluginResolution)) != null) {
                        launchPlugins.add(model);
                    }
                    ++featureModel;
                }
            }
            Set additionalIds = DependencyManager.getDependencies((Object[])launchPlugins.toArray(), (boolean)false, null);
            for (String id4 : additionalIds) {
                IPluginModelBase model;
                ModelEntry modelEntry = PluginRegistry.findEntry((String)id4);
                if (modelEntry == null || (model = BundleLauncherHelper.findModel(modelEntry, null, defaultPluginResolution)) == null) continue;
                launchPlugins.add(model);
            }
            HashMap pluginMap = new HashMap();
            HashSet<IPluginModelBase> pluginSet = new HashSet<IPluginModelBase>();
            List<IPluginModelBase> workspaceModels = null;
            for (IPluginModelBase model : launchPlugins) {
                String id5 = model.getPluginBase().getId();
                if (pluginMap.containsKey(id5)) {
                    IPluginModelBase existing = (IPluginModelBase)pluginMap.get(id5);
                    if (model.getPluginBase().getVersion().equalsIgnoreCase(existing.getPluginBase().getVersion()) || BundleLauncherHelper.isSingleton(model) && BundleLauncherHelper.isSingleton(existing)) {
                        if (workspaceModels == null) {
                            workspaceModels = Arrays.asList(PluginRegistry.getWorkspaceModels());
                        }
                        if (!workspaceModels.contains(existing)) {
                            pluginSet.add(model);
                            continue;
                        }
                    }
                }
                pluginSet.add(model);
            }
            pluginMap.clear();
            for (IPluginModelBase model : pluginSet) {
                AdditionalPluginData additionalPluginData = additionalPlugins.get(model);
                String startLevels = additionalPluginData != null ? additionalPluginData.startLevels() : "default:default";
                BundleLauncherHelper.addBundleToMap(map, model, startLevels);
            }
            return map;
        }
        HashSet<String> set = new HashSet<String>();
        map = BundleLauncherHelper.getWorkspaceBundleMap(configuration, set);
        map.putAll(BundleLauncherHelper.getTargetBundleMap(configuration, set));
        return map;
    }

    private static IPluginModelBase findModel(ModelEntry modelEntry, String version, String location) {
        IPluginModelBase model = null;
        if ("workspace".equalsIgnoreCase(location)) {
            model = BundleLauncherHelper.getBestCandidateModel(modelEntry.getWorkspaceModels(), version);
        }
        if (model == null) {
            model = BundleLauncherHelper.getBestCandidateModel(modelEntry.getExternalModels(), version);
        }
        if (model == null && "external".equalsIgnoreCase(location)) {
            model = BundleLauncherHelper.getBestCandidateModel(modelEntry.getWorkspaceModels(), version);
        }
        return model;
    }

    private static boolean isSingleton(IPluginModelBase model) {
        return model.getBundleDescription() == null || model.getBundleDescription().isSingleton();
    }

    private static IPluginModelBase getBestCandidateModel(IPluginModelBase[] models, String version) {
        Version requiredVersion = version != null ? Version.parseVersion((String)version) : Version.emptyVersion;
        IPluginModelBase model = null;
        int i = 0;
        while (i < models.length) {
            if (models[i].getBundleDescription() != null && models[i].isEnabled()) {
                if (model == null) {
                    model = models[i];
                    if (requiredVersion.compareTo(model.getBundleDescription().getVersion()) == 0) {
                        break;
                    }
                } else if (!model.isEnabled() && models[i].isEnabled()) {
                    model = models[i];
                } else {
                    BundleDescription current = model.getBundleDescription();
                    BundleDescription candidate = models[i].getBundleDescription();
                    if (current != null && candidate != null) {
                        if (!current.isResolved() && candidate.isResolved()) {
                            model = models[i];
                        } else {
                            if (requiredVersion.compareTo(candidate.getVersion()) == 0) {
                                model = models[i];
                                break;
                            }
                            if (current.getVersion().compareTo(candidate.getVersion()) < 0) {
                                model = models[i];
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return model;
    }

    public static IPluginModelBase[] getMergedBundles(ILaunchConfiguration configuration, boolean osgi) throws CoreException {
        Map<IPluginModelBase, String> map = BundleLauncherHelper.getMergedBundleMap(configuration, osgi);
        return map.keySet().toArray(new IPluginModelBase[map.size()]);
    }

    public static Map<IPluginModelBase, String> getWorkspaceBundleMap(ILaunchConfiguration configuration, Set<String> set) throws CoreException {
        Set selected = configuration.getAttribute("selected_workspace_bundles", Collections.emptySet());
        LinkedHashMap<IPluginModelBase, String> map = new LinkedHashMap<IPluginModelBase, String>();
        for (String token : selected) {
            ModelEntry entry;
            String version;
            String idVersion;
            int versionIndex;
            int index = token.indexOf(64);
            if (index < 0) {
                token = token.concat("@default:default");
                index = token.indexOf(64);
            }
            String id = (versionIndex = (idVersion = token.substring(0, index)).indexOf(42)) > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            String string = version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
            if (set != null) {
                set.add(id);
            }
            if ((entry = PluginRegistry.findEntry((String)id)) == null) continue;
            IPluginModelBase[] models = entry.getWorkspaceModels();
            HashSet<String> versions = new HashSet<String>();
            IPluginModelBase[] iPluginModelBaseArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                IPluginBase base = model.getPluginBase();
                String v = base.getVersion();
                if (versions.add(v) && (base.getVersion().equals(version) || version == null || models.length == 1)) {
                    BundleLauncherHelper.addBundleToMap(map, model, token.substring(index + 1));
                }
                ++n2;
            }
        }
        if (configuration.getAttribute("automaticAdd", true)) {
            Set<IPluginModelBase> deselectedPlugins = LaunchPluginValidator.parsePlugins(configuration, "deselected_workspace_bundles");
            IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                String id = models[i].getPluginBase().getId();
                if (id != null && !deselectedPlugins.contains(models[i])) {
                    if (set != null) {
                        set.add(id);
                    }
                    if (!map.containsKey(models[i])) {
                        BundleLauncherHelper.addBundleToMap(map, models[i], "default:default");
                    }
                }
                ++i;
            }
        }
        return map;
    }

    public static String resolveSystemRunLevelText(IPluginModelBase model) {
        BundleDescription description = model.getBundleDescription();
        String modelName = description.getSymbolicName();
        if ("org.eclipse.equinox.ds".equals(modelName)) {
            return "1";
        }
        if ("org.eclipse.equinox.simpleconfigurator".equals(modelName)) {
            return "1";
        }
        if ("org.eclipse.equinox.common".equals(modelName)) {
            return "2";
        }
        if ("org.eclipse.osgi".equals(modelName)) {
            return "-1";
        }
        if ("org.eclipse.core.runtime".equals(modelName)) {
            if (TargetPlatformHelper.getTargetVersion() > 3.1) {
                return "default";
            }
            return "2";
        }
        if ("org.apache.felix.scr".equals(modelName)) {
            return "1";
        }
        return null;
    }

    public static String resolveSystemAutoText(IPluginModelBase model) {
        BundleDescription description = model.getBundleDescription();
        String modelName = description.getSymbolicName();
        if ("org.eclipse.equinox.ds".equals(modelName)) {
            return DEFAULT_UPDATE_CONFIGURATOR_AUTO_START_TEXT;
        }
        if ("org.eclipse.equinox.simpleconfigurator".equals(modelName)) {
            return DEFAULT_UPDATE_CONFIGURATOR_AUTO_START_TEXT;
        }
        if ("org.eclipse.equinox.common".equals(modelName)) {
            return DEFAULT_UPDATE_CONFIGURATOR_AUTO_START_TEXT;
        }
        if ("org.eclipse.osgi".equals(modelName)) {
            return DEFAULT_UPDATE_CONFIGURATOR_AUTO_START_TEXT;
        }
        if ("org.eclipse.core.runtime".equals(modelName)) {
            if (TargetPlatformHelper.getTargetVersion() > 3.1) {
                return DEFAULT_UPDATE_CONFIGURATOR_AUTO_START_TEXT;
            }
            return DEFAULT_UPDATE_CONFIGURATOR_AUTO_START_TEXT;
        }
        if ("org.apache.felix.scr".equals(modelName)) {
            return DEFAULT_UPDATE_CONFIGURATOR_AUTO_START_TEXT;
        }
        return null;
    }

    private static void addBundleToMap(Map<IPluginModelBase, String> map, IPluginModelBase bundle, String sl) {
        boolean defaultsl;
        BundleDescription desc = bundle.getBundleDescription();
        boolean bl = defaultsl = sl == null || sl.equals("default:default");
        if (desc != null && defaultsl) {
            String runLevelText = BundleLauncherHelper.resolveSystemRunLevelText(bundle);
            String autoText = BundleLauncherHelper.resolveSystemAutoText(bundle);
            if (runLevelText != null && autoText != null) {
                map.put(bundle, String.valueOf(runLevelText) + ":" + autoText);
            } else {
                map.put(bundle, sl);
            }
        } else {
            map.put(bundle, sl);
        }
    }

    public static Map<IPluginModelBase, String> getTargetBundleMap(ILaunchConfiguration configuration, Set<String> set) throws CoreException {
        Set selected = configuration.getAttribute("selected_target_bundles", Collections.emptySet());
        LinkedHashMap<IPluginModelBase, String> map = new LinkedHashMap<IPluginModelBase, String>();
        for (String token : selected) {
            IPluginModelBase[] models;
            ModelEntry entry;
            String version;
            String idVersion;
            int versionIndex;
            int index = token.indexOf(64);
            if (index < 0) {
                token = token.concat("@default:default");
                index = token.indexOf(64);
            }
            String id = (versionIndex = (idVersion = token.substring(0, index)).indexOf(42)) > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            String string = version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
            if (set != null && set.contains(id) || (entry = PluginRegistry.findEntry((String)id)) == null) continue;
            IPluginModelBase[] iPluginModelBaseArray = models = entry.getExternalModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginBase base;
                IPluginModelBase model = iPluginModelBaseArray[n2];
                if (model.isEnabled() && ((base = model.getPluginBase()).getVersion().equals(version) || version == null || models.length == 1)) {
                    BundleLauncherHelper.addBundleToMap(map, model, token.substring(index + 1));
                }
                ++n2;
            }
        }
        return map;
    }

    public static String writeBundleEntry(IPluginModelBase model, String startLevel, String autoStart) {
        boolean hasAutoStart;
        IPluginBase base = model.getPluginBase();
        String id = base.getId();
        StringBuilder buffer = new StringBuilder(id);
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry != null && entry.getActiveModels().length > 1) {
            buffer.append('*');
            buffer.append(model.getPluginBase().getVersion());
        }
        boolean hasStartLevel = startLevel != null && startLevel.length() > 0;
        boolean bl = hasAutoStart = autoStart != null && autoStart.length() > 0;
        if (hasStartLevel || hasAutoStart) {
            buffer.append('@');
        }
        if (hasStartLevel) {
            buffer.append(startLevel);
        }
        if (hasStartLevel || hasAutoStart) {
            buffer.append(':');
        }
        if (hasAutoStart) {
            buffer.append(autoStart);
        }
        return buffer.toString();
    }

    public static void migrateLaunchConfiguration(ILaunchConfiguration configuration) throws CoreException {
        boolean upgrade;
        String value2;
        ILaunchConfigurationWorkingCopy wc = BundleLauncherHelper.getWorkingCopy(configuration);
        String value = configuration.getAttribute("wsproject", null);
        if (value != null) {
            wc.setAttribute("wsproject", null);
            if (value.indexOf(59) != -1) {
                value = value.replace(';', ',');
            } else if (value.indexOf(58) != -1) {
                value = value.replace(':', ',');
            }
            value = value.length() == 0 || value.equals(",") ? null : value.substring(0, value.length() - 1);
            boolean automatic = configuration.getAttribute("automaticAdd", true);
            String attr = automatic ? "deselected_workspace_plugins" : "selected_workspace_plugins";
            wc.setAttribute(attr, value);
        }
        if ((value2 = configuration.getAttribute("extplugins", null)) != null) {
            wc.setAttribute("extplugins", null);
            if (value2.indexOf(59) != -1) {
                value2 = value2.replace(';', ',');
            } else if (value2.indexOf(58) != -1) {
                value2 = value2.replace(':', ',');
            }
            value2 = value2.length() == 0 || value2.equals(",") ? null : value2.substring(0, value2.length() - 1);
            wc.setAttribute("selected_target_plugins", value2);
        }
        BundleLauncherHelper.convertToSet(wc, "selected_target_plugins", "selected_target_bundles");
        BundleLauncherHelper.convertToSet(wc, "selected_workspace_plugins", "selected_workspace_bundles");
        BundleLauncherHelper.convertToSet(wc, "deselected_workspace_plugins", "deselected_workspace_bundles");
        String version = configuration.getAttribute("pde.version", null);
        boolean newApp = TargetPlatformHelper.usesNewApplicationModel();
        boolean bl = upgrade = !"3.3".equals(version) && newApp;
        if (!upgrade) {
            boolean bl2 = upgrade = TargetPlatformHelper.getTargetVersion() >= 3.2 && version == null;
        }
        if (upgrade) {
            wc.setAttribute("pde.version", newApp ? "3.3" : "3.2a");
            boolean usedefault = configuration.getAttribute("default", true);
            boolean automaticAdd = configuration.getAttribute("automaticAdd", true);
            if (!usedefault) {
                ArrayList<String> list = new ArrayList<String>();
                if (version == null) {
                    list.add("org.eclipse.core.contenttype");
                    list.add("org.eclipse.core.jobs");
                    list.add("org.eclipse.equinox.common");
                    list.add("org.eclipse.equinox.preferences");
                    list.add("org.eclipse.equinox.registry");
                }
                if (!"3.3".equals(version) && newApp) {
                    list.add("org.eclipse.equinox.app");
                }
                LinkedHashSet<String> extensions = new LinkedHashSet<String>(configuration.getAttribute("selected_workspace_bundles", Collections.emptySet()));
                LinkedHashSet<String> target = new LinkedHashSet<String>(configuration.getAttribute("selected_target_bundles", Collections.emptySet()));
                for (String plugin : list) {
                    IPluginModelBase model = PluginRegistry.findModel((String)plugin);
                    if (model == null) continue;
                    if (model.getUnderlyingResource() != null) {
                        if (automaticAdd) continue;
                        extensions.add(plugin);
                        continue;
                    }
                    target.add(plugin);
                }
                if (!extensions.isEmpty()) {
                    wc.setAttribute("selected_workspace_bundles", extensions);
                }
                if (!target.isEmpty()) {
                    wc.setAttribute("selected_target_bundles", target);
                }
            }
        }
        if (wc.isDirty()) {
            wc.doSave();
        }
    }

    private static ILaunchConfigurationWorkingCopy getWorkingCopy(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.isWorkingCopy()) {
            return (ILaunchConfigurationWorkingCopy)configuration;
        }
        return configuration.getWorkingCopy();
    }

    public static void migrateOsgiLaunchConfiguration(ILaunchConfiguration configuration) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = BundleLauncherHelper.getWorkingCopy(configuration);
        BundleLauncherHelper.convertToSet(wc, "workspace_bundles", "selected_workspace_bundles");
        BundleLauncherHelper.convertToSet(wc, "target_bundles", "selected_target_bundles");
        BundleLauncherHelper.convertToSet(wc, "deselected_workspace_plugins", "deselected_workspace_bundles");
        if (wc.isDirty()) {
            wc.doSave();
        }
    }

    private static void convertToSet(ILaunchConfigurationWorkingCopy wc, String stringAttribute, String listAttribute) throws CoreException {
        String value = wc.getAttribute(stringAttribute, null);
        if (value != null) {
            wc.setAttribute(stringAttribute, null);
            String[] itemArray = value.split(",");
            HashSet<String> itemSet = new HashSet<String>(Arrays.asList(itemArray));
            wc.setAttribute(listAttribute, itemSet);
        }
    }

    public static Map<IPluginModelBase, AdditionalPluginData> getAdditionalPlugins(ILaunchConfiguration config, boolean onlyEnabled) throws CoreException {
        HashMap<IPluginModelBase, AdditionalPluginData> resolvedAdditionalPlugins = new HashMap<IPluginModelBase, AdditionalPluginData>();
        Set userAddedPlugins = config.getAttribute("additional_plugins", null);
        String defaultPluginResolution = config.getAttribute("featurePluginResolution", "workspace");
        if (userAddedPlugins != null) {
            for (String addedPlugin : userAddedPlugins) {
                IPluginModelBase model;
                String[] pluginData = addedPlugin.split(":");
                boolean checked = Boolean.parseBoolean(pluginData[3]);
                if (onlyEnabled && !checked) continue;
                String id = pluginData[0];
                String version = pluginData[1];
                String pluginResolution = pluginData[2];
                ModelEntry pluginModelEntry = PluginRegistry.findEntry((String)id);
                if (pluginModelEntry == null) continue;
                if ("default".equalsIgnoreCase(pluginResolution)) {
                    pluginResolution = defaultPluginResolution;
                }
                if ((model = BundleLauncherHelper.findModel(pluginModelEntry, version, pluginResolution)) == null) continue;
                String startLevel = pluginData.length >= 6 ? pluginData[4] : null;
                String autoStart = pluginData.length >= 6 ? pluginData[5] : null;
                AdditionalPluginData additionalPluginData = new AdditionalPluginData(pluginData[2], checked, startLevel, autoStart);
                resolvedAdditionalPlugins.put(model, additionalPluginData);
            }
        }
        return resolvedAdditionalPlugins;
    }

    public static class AdditionalPluginData {
        public final String fResolution;
        public final boolean fEnabled;
        public final String fStartLevel;
        public final String fAutoStart;

        public AdditionalPluginData(String resolution, boolean enabled, String startLevel, String autoStart) {
            this.fResolution = resolution;
            this.fEnabled = enabled;
            this.fStartLevel = startLevel == null || startLevel.isEmpty() ? "default" : startLevel;
            this.fAutoStart = autoStart == null || autoStart.isEmpty() ? "default" : autoStart;
        }

        String startLevels() {
            return String.valueOf(this.fStartLevel) + ':' + this.fAutoStart;
        }
    }
}

