/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.IUndoManagerListener;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.UndoManagerAdapter;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class UndoManagerAction
implements IWorkbenchWindowActionDelegate {
    private static final int MAX_LENGTH = 30;
    private IAction fAction;
    private IWorkbenchWindow fWorkbenchWindow;
    private UndoManagerAdapter fUndoManagerListener;

    protected UndoManagerAction() {
    }

    protected abstract IRunnableWithProgress createOperation(Shell var1);

    protected abstract UndoManagerAdapter createUndoManagerListener();

    protected abstract String getName();

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected boolean isHooked() {
        return this.fAction != null;
    }

    protected void hookListener(IAction action) {
        if (this.isHooked()) {
            return;
        }
        this.fAction = action;
        this.fUndoManagerListener = this.createUndoManagerListener();
        RefactoringCore.getUndoManager().addListener((IUndoManagerListener)this.fUndoManagerListener);
    }

    protected String shortenText(String text, int patternLength) {
        int length = text.length();
        int finalLength = 30 + patternLength;
        if (text.length() <= finalLength) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        int mid = finalLength / 2;
        result.append(text.substring(0, mid));
        result.append("...");
        result.append(text.substring(length - mid));
        return result.toString();
    }

    public void dispose() {
        if (this.fUndoManagerListener != null) {
            RefactoringCore.getUndoManager().removeListener((IUndoManagerListener)this.fUndoManagerListener);
        }
        this.fWorkbenchWindow = null;
        this.fAction = null;
        this.fUndoManagerListener = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
    }

    public void run(IAction action) {
        Shell parent = this.fWorkbenchWindow.getShell();
        IRunnableWithProgress op = this.createOperation(parent);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)new ProgressMonitorDialog(this.fWorkbenchWindow.getShell()), op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            RefactoringCore.getUndoManager().flush();
            ExceptionHandler.handle(e, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), RefactoringUIMessages.UndoManagerAction_internal_error_title, RefactoringUIMessages.UndoManagerAction_internal_error_message);
        }
        catch (InterruptedException | OperationCanceledException throwable) {}
    }

    protected static abstract class Query
    implements IValidationCheckResultQuery {
        private Shell fParent;
        private String fTitle;

        public Query(Shell parent, String title) {
            this.fParent = parent;
            this.fTitle = title;
        }

        public boolean proceed(RefactoringStatus status) {
            final Dialog dialog = RefactoringUI.createRefactoringStatusDialog(status, this.fParent, this.fTitle, false);
            final int[] result = new int[1];
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    result[0] = dialog.open();
                }
            };
            this.fParent.getDisplay().syncExec(r);
            return result[0] == 0;
        }

        public void stopped(final RefactoringStatus status) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String message = status.getMessageMatchingSeverity(4);
                    MessageDialog.openWarning((Shell)fParent, (String)fTitle, (String)this.getFullMessage(message));
                }
            };
            this.fParent.getDisplay().syncExec(r);
        }

        protected abstract String getFullMessage(String var1);
    }
}

