/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.IUriSchemeExtensionReader;
import org.eclipse.urischeme.IUriSchemeHandler;

public class UriSchemeExtensionReader
implements IUriSchemeExtensionReader {
    private static final String PLUGIN_ID = "org.eclipse.urischeme";
    private static final String EXT_POINT_ID_URI_SCHEME_HANDLERS = "org.eclipse.urischeme.uriSchemeHandlers";
    private static final String EXT_POINT_ATTRIBUTE_URI_SCHEME = "uriScheme";
    private static final String EXT_POINT_ATTRIBUTE_URI_SCHEME_DESCRIPTION = "uriSchemeDescription";
    private static final String EXT_POINT_ATTRIBUTE_CLASS = "class";
    IConfigurationElement[] configurationElements = null;

    @Override
    public Collection<IScheme> getSchemes() {
        IConfigurationElement[] elements = this.getOrReadConfigurationElements();
        ArrayList<IScheme> schemes = new ArrayList<IScheme>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String schemeName = element.getAttribute(EXT_POINT_ATTRIBUTE_URI_SCHEME);
            String schemeDescription = element.getAttribute(EXT_POINT_ATTRIBUTE_URI_SCHEME_DESCRIPTION);
            Scheme scheme = new Scheme(schemeName, schemeDescription);
            schemes.add(scheme);
            ++n2;
        }
        return schemes;
    }

    @Override
    public IUriSchemeHandler getHandlerFromExtensionPoint(String uriScheme) throws CoreException {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = this.getOrReadConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (uriScheme.equals(element.getAttribute(EXT_POINT_ATTRIBUTE_URI_SCHEME))) {
                return this.createExecutableSchemeHandler(element);
            }
            ++n2;
        }
        return null;
    }

    private IConfigurationElement[] getOrReadConfigurationElements() {
        if (this.configurationElements == null) {
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            this.configurationElements = registry.getConfigurationElementsFor(EXT_POINT_ID_URI_SCHEME_HANDLERS);
        }
        return this.configurationElements;
    }

    private IUriSchemeHandler createExecutableSchemeHandler(IConfigurationElement element) throws CoreException {
        Object executableExtension = element.createExecutableExtension(EXT_POINT_ATTRIBUTE_CLASS);
        if (executableExtension instanceof IUriSchemeHandler) {
            return (IUriSchemeHandler)executableExtension;
        }
        throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "Registered class has wrong type: " + executableExtension.getClass()));
    }

    private static class Scheme
    implements IScheme {
        private String uriScheme;
        private String uriSchemeDescription;

        public Scheme(String uriScheme, String uriSchemeDescription) {
            this.uriScheme = uriScheme;
            this.uriSchemeDescription = uriSchemeDescription;
        }

        @Override
        public String getName() {
            return this.uriScheme;
        }

        @Override
        public String getDescription() {
            return this.uriSchemeDescription;
        }
    }
}

