/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.IdentityUtils;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryDataResolver;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.keyprovider.KeyTypeIndicator;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class PublicKeyEntry
implements Serializable,
KeyTypeIndicator {
    public static final char COMMENT_CHAR = '#';
    public static final String STD_KEYFILE_FOLDER_NAME = ".ssh";
    private static final long serialVersionUID = -585506072687602760L;
    private static final NavigableMap<String, PublicKeyEntryDataResolver> KEY_DATA_RESOLVERS = new TreeMap<String, PublicKeyEntryDataResolver>(String.CASE_INSENSITIVE_ORDER);
    private String keyType;
    private byte[] keyData;
    private PublicKeyEntryDataResolver keyDataResolver = PublicKeyEntryDataResolver.DEFAULT;

    public PublicKeyEntry() {
    }

    public PublicKeyEntry(String keyType, byte ... keyData) {
        this.keyType = keyType;
        this.keyData = keyData;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String value) {
        this.keyType = value;
    }

    public byte[] getKeyData() {
        return this.keyData;
    }

    public void setKeyData(byte[] value) {
        this.keyData = value;
    }

    public PublicKeyEntryDataResolver getKeyDataResolver() {
        return this.keyDataResolver;
    }

    public void setKeyDataResolver(PublicKeyEntryDataResolver keyDataResolver) {
        this.keyDataResolver = keyDataResolver;
    }

    public PublicKeyEntryDataResolver resolvePublicKeyEntryDataResolver() {
        PublicKeyEntryDataResolver resolver = this.getKeyDataResolver();
        return resolver == null ? PublicKeyEntryDataResolver.DEFAULT : resolver;
    }

    public PublicKey resolvePublicKey(SessionContext session, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        String kt = this.getKeyType();
        PublicKeyEntryResolver decoder = KeyUtils.getPublicKeyEntryDecoder(kt);
        if (decoder == null) {
            decoder = fallbackResolver;
        }
        if (decoder == null) {
            throw new InvalidKeySpecException("No decoder available for key type=" + kt);
        }
        return decoder.resolve(session, kt, this.getKeyData());
    }

    public PublicKey appendPublicKey(SessionContext session, Appendable sb, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        PublicKey key = this.resolvePublicKey(session, fallbackResolver);
        if (key != null) {
            PublicKeyEntry.appendPublicKeyEntry(sb, key, this.resolvePublicKeyEntryDataResolver());
        }
        return key;
    }

    public int hashCode() {
        return Objects.hashCode(this.getKeyType()) + Arrays.hashCode(this.getKeyData());
    }

    protected boolean isEquivalent(PublicKeyEntry e) {
        if (this == e) {
            return true;
        }
        return Objects.equals(this.getKeyType(), e.getKeyType()) && Arrays.equals(this.getKeyData(), e.getKeyData());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.isEquivalent((PublicKeyEntry)obj);
    }

    public String toString() {
        PublicKeyEntryDataResolver resolver = this.resolvePublicKeyEntryDataResolver();
        String encData = resolver.encodeEntryKeyData(this.getKeyData());
        return this.getKeyType() + " " + (GenericUtils.isEmpty(encData) ? "<no-key>" : encData);
    }

    public static List<PublicKey> resolvePublicKeyEntries(SessionContext session, Collection<? extends PublicKeyEntry> entries, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        int numEntries = GenericUtils.size(entries);
        if (numEntries <= 0) {
            return Collections.emptyList();
        }
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>(numEntries);
        for (PublicKeyEntry publicKeyEntry : entries) {
            PublicKey k = publicKeyEntry.resolvePublicKey(session, fallbackResolver);
            if (k == null) continue;
            keys.add(k);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerKeyDataEntryResolver(String keyType, PublicKeyEntryDataResolver resolver) {
        ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        Objects.requireNonNull(resolver, "No resolver provided");
        NavigableMap<String, PublicKeyEntryDataResolver> navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            KEY_DATA_RESOLVERS.put(keyType, resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDataResolver getKeyDataEntryResolver(String keyType) {
        keyType = ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        NavigableMap<String, PublicKeyEntryDataResolver> navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            return (PublicKeyEntryDataResolver)KEY_DATA_RESOLVERS.get(keyType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDataResolver unregisterKeyDataEntryResolver(String keyType) {
        keyType = ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        NavigableMap<String, PublicKeyEntryDataResolver> navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            return (PublicKeyEntryDataResolver)KEY_DATA_RESOLVERS.remove(keyType);
        }
    }

    public static PublicKeyEntryDataResolver resolveKeyDataEntryResolver(String keyType) {
        PublicKeyEntryDataResolver resolver = PublicKeyEntry.getKeyDataEntryResolver(keyType = ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided"));
        if (resolver != null) {
            return resolver;
        }
        return PublicKeyEntryDataResolver.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableMap<String, PublicKeyEntryDataResolver> getRegisteredKeyDataEntryResolvers() {
        TreeMap<String, PublicKeyEntryDataResolver> decoders;
        NavigableMap<String, PublicKeyEntryDataResolver> navigableMap = KEY_DATA_RESOLVERS;
        synchronized (navigableMap) {
            if (KEY_DATA_RESOLVERS.isEmpty()) {
                return Collections.emptyNavigableMap();
            }
            decoders = new TreeMap<String, PublicKeyEntryDataResolver>(KEY_DATA_RESOLVERS.comparator());
            decoders.putAll(KEY_DATA_RESOLVERS);
        }
        return decoders;
    }

    public static PublicKeyEntry parsePublicKeyEntry(String encData) throws IllegalArgumentException {
        return PublicKeyEntry.parsePublicKeyEntry(encData, (PublicKeyEntryDataResolver)null);
    }

    public static PublicKeyEntry parsePublicKeyEntry(String encData, PublicKeyEntryDataResolver decoder) throws IllegalArgumentException {
        String data = GenericUtils.replaceWhitespaceAndTrim(encData);
        if (GenericUtils.isEmpty(data)) {
            return null;
        }
        return PublicKeyEntry.parsePublicKeyEntry(new PublicKeyEntry(), data, decoder);
    }

    public static <E extends PublicKeyEntry> E parsePublicKeyEntry(E entry, String encData) throws IllegalArgumentException {
        return PublicKeyEntry.parsePublicKeyEntry(entry, encData, null);
    }

    public static <E extends PublicKeyEntry> E parsePublicKeyEntry(E entry, String encData, PublicKeyEntryDataResolver decoder) throws IllegalArgumentException {
        String b64Data;
        byte[] keyData;
        String data = GenericUtils.replaceWhitespaceAndTrim(encData);
        if (GenericUtils.isEmpty(data) || entry == null) {
            return entry;
        }
        int startPos = data.indexOf(32);
        if (startPos <= 0) {
            throw new IllegalArgumentException("Bad format (no key data delimiter): " + data);
        }
        int endPos = data.indexOf(32, startPos + 1);
        if (endPos <= startPos) {
            endPos = data.length();
        }
        String keyType = data.substring(0, startPos);
        if (decoder == null) {
            decoder = PublicKeyEntry.resolveKeyDataEntryResolver(keyType);
        }
        if (NumberUtils.isEmpty(keyData = decoder.decodeEntryKeyData(b64Data = data.substring(startPos + 1, endPos).trim()))) {
            throw new IllegalArgumentException("Bad format (no BASE64 key data): " + data);
        }
        entry.setKeyType(keyType);
        entry.setKeyDataResolver(decoder);
        entry.setKeyData(keyData);
        return entry;
    }

    public static String toString(PublicKey key) throws IllegalArgumentException {
        return PublicKeyEntry.toString(key, null);
    }

    public static String toString(PublicKey key, PublicKeyEntryDataResolver encoder) throws IllegalArgumentException {
        try {
            return PublicKeyEntry.appendPublicKeyEntry(new StringBuilder(127), key, encoder).toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed (" + e.getClass().getSimpleName() + ") to encode: " + e.getMessage(), e);
        }
    }

    public static <A extends Appendable> A appendPublicKeyEntry(A sb, PublicKey key) throws IOException {
        return PublicKeyEntry.appendPublicKeyEntry(sb, key, null);
    }

    public static <A extends Appendable> A appendPublicKeyEntry(A sb, PublicKey key, PublicKeyEntryDataResolver encoder) throws IOException {
        if (key == null) {
            return sb;
        }
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(key);
        if (decoder == null) {
            throw new StreamCorruptedException("Cannot retrieve decoder for key=" + key.getAlgorithm());
        }
        try (ByteArrayOutputStream s = new ByteArrayOutputStream(127);){
            String keyType = decoder.encodePublicKey(s, key);
            byte[] bytes = s.toByteArray();
            if (encoder == null) {
                encoder = PublicKeyEntry.resolveKeyDataEntryResolver(keyType);
            }
            String encData = encoder.encodeEntryKeyData(bytes);
            sb.append(keyType).append(' ').append(encData);
        }
        return sb;
    }

    public static Path getDefaultKeysFolderPath() {
        return LazyDefaultKeysFolderHolder.PATH;
    }

    private static final class LazyDefaultKeysFolderHolder {
        private static final Path PATH = IdentityUtils.getUserHomeFolder().resolve(".ssh");

        private LazyDefaultKeysFolderHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

