/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.P2Utils;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.OSGiValidationOperation;
import org.eclipse.pde.ui.launcher.AbstractPDELaunchConfiguration;

@Deprecated
public class EquinoxLaunchConfiguration
extends AbstractPDELaunchConfiguration {
    protected Map<String, List<IPluginModelBase>> fAllBundles;
    private Map<IPluginModelBase, String> fModels;

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> programArgs = new ArrayList<String>();
        programArgs.add("-dev");
        programArgs.add(ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(this.getConfigDir(configuration).toString()) + "/dev.properties"), this.fAllBundles));
        this.saveConfigurationFile(configuration);
        programArgs.add("-configuration");
        programArgs.add("file:" + new Path(this.getConfigDir(configuration).getPath()).addTrailingSeparator().toString());
        String[] args = super.getProgramArguments(configuration);
        Collections.addAll(programArgs, args);
        return programArgs.toArray(new String[programArgs.size()]);
    }

    private void saveConfigurationFile(ILaunchConfiguration configuration) throws CoreException {
        Properties properties = new Properties();
        properties.setProperty("osgi.install.area", "file:" + TargetPlatform.getLocation());
        properties.setProperty("osgi.configuration.cascaded", "false");
        properties.put("osgi.framework", LaunchConfigurationHelper.getBundleURL((String)"org.eclipse.osgi", this.fAllBundles, (boolean)false));
        int start = configuration.getAttribute("default_start_level", 4);
        properties.put("osgi.bundles.defaultStartLevel", Integer.toString(start));
        boolean autostart = configuration.getAttribute("default_auto_start", true);
        String bundles = null;
        if (this.fAllBundles.containsKey("org.eclipse.equinox.simpleconfigurator")) {
            URL bundlesTxt = P2Utils.writeBundlesTxt(this.fModels, (int)start, (boolean)autostart, (File)this.getConfigDir(configuration), null);
            if (bundlesTxt != null) {
                properties.setProperty("org.eclipse.equinox.simpleconfigurator.configUrl", bundlesTxt.toString());
            }
            StringBuilder buffer = new StringBuilder();
            IPluginModelBase model = LaunchConfigurationHelper.getLatestModel((String)"org.eclipse.equinox.simpleconfigurator", this.fAllBundles);
            buffer.append(LaunchConfigurationHelper.getBundleURL((IPluginModelBase)model, (boolean)true));
            this.appendStartData(buffer, this.fModels.get(model), autostart);
            bundles = buffer.toString();
        } else {
            bundles = this.getBundles(autostart);
        }
        if (bundles.length() > 0) {
            properties.put("osgi.bundles", bundles);
        }
        if (!"3.3".equals(configuration.getAttribute("pde.version", ""))) {
            properties.put("eclipse.ignoreApp", "true");
            properties.put("osgi.noShutdown", "true");
        }
        LaunchConfigurationHelper.save((File)new File(this.getConfigDir(configuration), "config.ini"), (Properties)properties);
    }

    private String getBundles(boolean defaultAuto) {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<IPluginModelBase, String> entry : this.fModels.entrySet()) {
            IPluginModelBase model = entry.getKey();
            String id = model.getPluginBase().getId();
            if ("org.eclipse.osgi".equals(id)) continue;
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(LaunchConfigurationHelper.getBundleURL((IPluginModelBase)model, (boolean)true));
            if (model instanceof IFragmentModel) continue;
            String data = entry.getValue();
            this.appendStartData(buffer, data, defaultAuto);
        }
        return buffer.toString();
    }

    private void appendStartData(StringBuilder buffer, String startData, boolean defaultAuto) {
        String auto;
        int index = startData.indexOf(58);
        String level = index > 0 ? startData.substring(0, index) : "default";
        String string = auto = index > 0 && index < startData.length() - 1 ? startData.substring(index + 1) : "default";
        if ("default".equals(auto)) {
            auto = Boolean.toString(defaultAuto);
        }
        if (!level.equals("default") || "true".equals(auto)) {
            buffer.append("@");
        }
        if (!level.equals("default")) {
            buffer.append(level);
            if ("true".equals(auto)) {
                buffer.append(":");
            }
        }
        if ("true".equals(auto)) {
            buffer.append("start");
        }
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.fModels = BundleLauncherHelper.getMergedBundleMap((ILaunchConfiguration)configuration, (boolean)true);
        this.fAllBundles = this.fModels.keySet().stream().collect(Collectors.groupingBy(m -> m.getPluginBase().getId(), HashMap::new, Collectors.toCollection(ArrayList::new)));
        if (!this.fAllBundles.containsKey("org.eclipse.osgi")) {
            IPluginModelBase model = PluginRegistry.findModel((String)"org.eclipse.osgi");
            if (model != null) {
                this.fModels.put(model, "default:default");
                this.fAllBundles.computeIfAbsent("org.eclipse.osgi", i -> new ArrayList()).add(model);
            } else {
                String message = PDEMessages.EquinoxLaunchConfiguration_oldTarget;
                throw new CoreException(Status.error((String)message));
            }
        }
        super.preLaunchCheck(configuration, launch, monitor);
    }

    protected void validatePluginDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        OSGiValidationOperation op = new OSGiValidationOperation(configuration);
        LaunchPluginValidator.runValidationOperation((LaunchValidationOperation)op, (IProgressMonitor)monitor);
    }

    protected void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (configuration.getAttribute("clearConfig", false)) {
            CoreUtility.deleteContent((File)this.getConfigDir(configuration));
        }
    }
}

