/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryDate;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEntry;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryProject;

public final class BrowseRefactoringHistoryViewerSorter
extends ViewerComparator {
    public int category(Object element) {
        if (element instanceof RefactoringHistoryProject) {
            return 0;
        }
        return 1;
    }

    public int compare(Viewer viewer, Object first, Object second) {
        if (first instanceof RefactoringHistoryProject && second instanceof RefactoringHistoryProject) {
            RefactoringHistoryProject predecessor = (RefactoringHistoryProject)first;
            RefactoringHistoryProject successor = (RefactoringHistoryProject)second;
            return this.getComparator().compare(predecessor.getProject(), successor.getProject());
        }
        if (first instanceof RefactoringHistoryDate && second instanceof RefactoringHistoryDate) {
            RefactoringHistoryDate predecessor = (RefactoringHistoryDate)first;
            RefactoringHistoryDate successor = (RefactoringHistoryDate)second;
            int delta = predecessor.getKind() - successor.getKind();
            if (delta != 0) {
                return delta;
            }
            long result = successor.getTimeStamp() - predecessor.getTimeStamp();
            if (result < 0L) {
                return -1;
            }
            if (result > 0L) {
                return 1;
            }
            return 0;
        }
        if (first instanceof RefactoringHistoryEntry && second instanceof RefactoringHistoryEntry) {
            RefactoringHistoryEntry predecessor = (RefactoringHistoryEntry)first;
            RefactoringHistoryEntry successor = (RefactoringHistoryEntry)second;
            long delta = successor.getDescriptor().getTimeStamp() - predecessor.getDescriptor().getTimeStamp();
            if (delta < 0L) {
                return -1;
            }
            if (delta > 0L) {
                return 1;
            }
            return 0;
        }
        return super.compare(viewer, first, second);
    }
}

