/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.preferences.ui.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.internal.preferences.PrefUtils;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.preferences.PrefNode;
import org.eclipse.rcptt.preferences.PreferencesContext;
import org.eclipse.rcptt.preferences.PreferencesFactory;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class WizardPreferencesPage
extends WizardPage
implements Listener {
    private Text destinationNameField;
    private Button destinationBrowseButton;
    private String currentMessage;

    public WizardPreferencesPage() {
        super("preferencesImportPage");
        this.setTitle("Import Preferences");
        this.setDescription("Import preferences from the local file system.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createDestinationComposite(composite);
        this.updatePageCompletion();
        this.setControl((Control)composite);
        this.destinationNameField.setFocus();
        Dialog.applyDialogFont((Control)composite);
    }

    private void createDestinationComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label dest = new Label(composite, 0);
        dest.setText("From preference file:");
        this.destinationNameField = new Text(composite, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationBrowseButton = new Button(composite, 8);
        this.destinationBrowseButton.setText("Browse...");
        this.destinationBrowseButton.setLayoutData((Object)new GridData(256));
        this.destinationBrowseButton.addListener(13, (Listener)this);
        new Label(parent, 0);
    }

    public boolean finish(IQ7Editor<Context> contextEditor) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.getDestinationValue());
        }
        catch (FileNotFoundException e) {
            Q7UIPlugin.log((String)e.getMessage(), (Throwable)e);
            MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)new String(), (String)e.getLocalizedMessage(), (int)0x10000000);
            return false;
        }
        IPreferencesService service = Platform.getPreferencesService();
        try {
            try {
                IExportedPreferences prefs = service.readPreferences((InputStream)fis);
                PrefNode prefNode = PrefUtils.convertPreferences((Preferences)prefs);
                PreferencesContext context = PreferencesFactory.eINSTANCE.createPreferencesContext();
                if (prefNode != null) {
                    context.getContent().addAll((Collection)prefNode.getChilds());
                }
                contextEditor.copyContentFrom((Object)context, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Q7UIPlugin.log((String)e.getMessage(), (Throwable)e);
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e2) {
                    Q7UIPlugin.log((String)e2.getMessage(), (Throwable)e2);
                }
            }
            catch (BackingStoreException e) {
                Q7UIPlugin.log((String)e.getMessage(), (Throwable)e);
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e3) {
                    Q7UIPlugin.log((String)e3.getMessage(), (Throwable)e3);
                }
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                Q7UIPlugin.log((String)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    private void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 0x10001000);
        dialog.setText("Import from File");
        dialog.setFilterPath(this.getDestinationValue());
        dialog.setFilterExtensions(new String[]{"*.epf", "*.*"});
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.destinationNameField.setText(selectedFileName);
        }
    }

    private String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    private void updatePageCompletion() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
    }

    private boolean determinePageCompletion() {
        if (this.isDestinationValid()) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(this.currentMessage);
        return false;
    }

    private boolean isDestinationValid() {
        String destination = this.getDestinationValue();
        if (destination.length() == 0) {
            this.currentMessage = "Please select a preference file.";
            return false;
        }
        File file = new File(this.getDestinationValue());
        if (!file.exists() || file.isDirectory()) {
            this.currentMessage = "Preference file does not exist or is a directory.";
            return false;
        }
        return true;
    }
}

