/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.preferences.ui.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ctx.preferences.ui.wizard.PreferencesImportWizard;
import org.eclipse.rcptt.internal.preferences.PrefUtils;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.preferences.PreferencesContext;
import org.eclipse.rcptt.preferences.SettingsNode;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.rcptt.workspace.WorkspaceContext;
import org.eclipse.ui.PlatformUI;

public abstract class PrefAction
extends Action {
    protected ISelectionProvider selectionProvider;
    protected TreeViewer viewer;

    public PrefAction(String text, ImageDescriptor descriptor, ISelectionProvider selectionProvider) {
        super(text, descriptor);
        this.selectionProvider = selectionProvider;
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    protected WorkspaceContext getContext() {
        return (WorkspaceContext)this.viewer.getInput();
    }

    public static class ImportPreferences
    extends PrefAction {
        private final IQ7Editor<Context> contextEditor;

        public ImportPreferences(IQ7Editor<Context> contextEditor) {
            super("Import Preferences...", Images.getImageDescriptor((String)"icons/preferences/import.gif"), null);
            this.contextEditor = contextEditor;
        }

        public void run() {
            PreferencesImportWizard wizard = new PreferencesImportWizard(this.contextEditor);
            WizardDialog dialog = new WizardDialog(WorkbenchUtils.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public static class Remove
    extends PrefAction {
        private PreferencesContext context;

        public Remove(ISelectionProvider selectionProvider, PreferencesContext context) {
            super("Remove", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"), selectionProvider);
            this.context = context;
        }

        public boolean isEnabled() {
            return !this.selectionProvider.getSelection().isEmpty();
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
            for (Object o : selection.toList()) {
                if (o instanceof SettingsNode) {
                    this.context.setSettings(null);
                    this.viewer.remove(o);
                    continue;
                }
                PrefUtils.remove((EObject)((EObject)o));
            }
        }
    }
}

