/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.gef;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.rcptt.tesla.core.utils.TeslaUtils;
import org.eclipse.rcptt.tesla.gef.FigureUIElement;
import org.eclipse.rcptt.tesla.gef.GefActivator;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;

public class TeslaGefAccess {
    public static boolean isPalleteEditPart(EditPart part) {
        if (part == null) {
            return false;
        }
        Class<?> palleteEditPartClass = null;
        try {
            palleteEditPartClass = TeslaUtils.getGEFVersion().getMajor() >= 3 && TeslaUtils.getGEFVersion().getMinor() >= 4 ? Class.forName("org.eclipse.gef.ui.palette.editparts.PaletteEditPart") : Class.forName("org.eclipse.gef.internal.ui.palette.editparts.PaletteEditPart");
        }
        catch (ClassNotFoundException e) {
            GefActivator.log(e);
        }
        if (palleteEditPartClass != null) {
            return palleteEditPartClass.isInstance(part);
        }
        return false;
    }

    public static EditPart getSourceEditPart(DirectEditManager manager) {
        try {
            Field field = DirectEditManager.class.getDeclaredField("source");
            field.setAccessible(true);
            Object source = field.get(manager);
            if (source instanceof EditPart) {
                return (EditPart)source;
            }
        }
        catch (Throwable e) {
            GefActivator.log(e);
        }
        return null;
    }

    private static Object get(Object widget, String fieldName) {
        try {
            Class<?> cl = widget.getClass();
            Field f = cl.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(widget);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object getThis(Object widget) {
        return TeslaGefAccess.get(widget, "this$0");
    }

    public static Object getArg(Object widget) {
        return TeslaGefAccess.get(widget, "arg$1");
    }

    private static Object getField(Object sTool, String fieldName, Class oclass) {
        try {
            Field field = oclass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(sTool);
        }
        catch (Throwable e) {
            GefActivator.log(e);
            return null;
        }
    }

    public static DragTracker getDragTracker(Tool tool) {
        return (DragTracker)TeslaGefAccess.getField((Object)tool, "dragTracker", SelectionTool.class);
    }

    public static Object getDirectEditSource(DirectEditManager manager) {
        Object source = null;
        try {
            Field field = DirectEditManager.class.getDeclaredField("source");
            field.setAccessible(true);
            source = field.get(manager);
        }
        catch (Throwable e) {
            GefActivator.log(e);
        }
        return source;
    }

    public static EditPart getEditPart(Object helper) {
        EditPart value = null;
        try {
            Field field = helper.getClass().getDeclaredField("part");
            field.setAccessible(true);
            value = (EditPart)field.get(helper);
        }
        catch (Throwable e) {
            GefActivator.log(e);
        }
        return value;
    }

    public static Object getActiveHelper(Object helper) {
        Object activeHelper = null;
        try {
            Field field = helper.getClass().getDeclaredField("activeHelper");
            field.setAccessible(true);
            activeHelper = field.get(helper);
        }
        catch (Throwable e) {
            GefActivator.log(e);
        }
        return activeHelper;
    }

    public static Object getEditPartField(DragTracker dragTracker) {
        return TeslaGefAccess.getField((Object)dragTracker, "editpart", SelectEditPartTracker.class);
    }

    public static List getOperationSet(DragTracker dragTracker) {
        return (List)TeslaGefAccess.getField((Object)dragTracker, "operationSet", AbstractTool.class);
    }

    static boolean createTargetRequest(CreationTool createTool, int x, int y, EditPart performAt) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> toolClass = createTool.getClass();
        Method method = toolClass.getDeclaredMethod("createTargetRequest", new Class[0]);
        if (method != null) {
            method.setAccessible(true);
            CreateRequest creationRequest = (CreateRequest)method.invoke((Object)createTool, new Object[0]);
            creationRequest.setLocation(new Point(x, y));
            Command gefCommand = performAt.getCommand((Request)creationRequest);
            if (gefCommand != null && gefCommand.canExecute()) {
                performAt.performRequest((Request)creationRequest);
                return true;
            }
            return false;
        }
        return false;
    }

    static boolean createTargetRequest(FigureUIElement source, FigureUIElement target, ConnectionCreationTool createTool, EditDomain domain, EditPart performAt) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> toolClass = createTool.getClass();
        Method method = toolClass.getDeclaredMethod("createTargetRequest", new Class[0]);
        boolean fine = false;
        if (method != null) {
            method.setAccessible(true);
            CreateConnectionRequest creationRequest = (CreateConnectionRequest)method.invoke((Object)createTool, new Object[0]);
            creationRequest.setSourceEditPart(source.getPart());
            creationRequest.setTargetEditPart(target.getPart());
            creationRequest.setLocation(new Point(0, 0));
            Command gefCommand = target.getPart().getCommand((Request)creationRequest);
            if (gefCommand != null && gefCommand.canExecute()) {
                performAt.performRequest((Request)creationRequest);
                fine = true;
            } else {
                fine = false;
            }
            if (!fine) {
                CreateConnectionRequest connectionRequest = (CreateConnectionRequest)method.invoke((Object)createTool, new Object[0]);
                connectionRequest.setType((Object)"connection start");
                connectionRequest.setLocation(new Point(0, 0));
                if (source.getPart().getCommand((Request)connectionRequest) != null) {
                    connectionRequest.setSourceEditPart(source.getPart());
                    connectionRequest.setTargetEditPart(target.getPart());
                    connectionRequest.setType((Object)"connection end");
                    Command cmd = target.getPart().getCommand((Request)connectionRequest);
                    if (cmd != null && cmd.canExecute()) {
                        domain.getCommandStack().execute(cmd);
                    }
                }
            }
        }
        return fine;
    }

    public static AbstractTool.Input getCurrentInput(AbstractTool tool) {
        try {
            Field currentField = AbstractTool.class.getDeclaredField("current");
            currentField.setAccessible(true);
            return (AbstractTool.Input)currentField.get(tool);
        }
        catch (Throwable e) {
            GefActivator.log(e);
            return null;
        }
    }

    public static EditPart getEditPart(AbstractHandle figure) {
        return (EditPart)TeslaGefAccess.getField((Object)figure, AbstractHandle.class, "editpart");
    }

    public static Object getField(Object t, Class<?> cl, String name) {
        try {
            Field field = cl.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(t);
        }
        catch (Throwable e) {
            TeslaCore.log((Throwable)e);
            return null;
        }
    }
}

