/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.gef;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.CompositeUIElement;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramFeatures;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.FigureUIElement;
import org.eclipse.rcptt.tesla.core.ui.DiagramItem;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeList;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.gef.GefModelMapper;
import org.eclipse.rcptt.tesla.gef.GefProcessor;
import org.eclipse.rcptt.tesla.gef.PropertySourceBasedModelMapper;
import org.eclipse.rcptt.tesla.gef.TeslaGefAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.gef.GefEventRecorder;
import org.eclipse.rcptt.tesla.recording.core.gef.GefRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.gef.IGMFRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.swt.BasicRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTEventRecorder;
import org.eclipse.rcptt.tesla.swt.util.IdentifyObjectUtil;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class GefFigureLocator {
    private final GefEventRecorder gefEventRecorder;

    public GefFigureLocator(GefEventRecorder gefRecorder) {
        this.gefEventRecorder = gefRecorder;
    }

    public GefRecordingHelper.GraphicalViewerEntry getDiagramUIElement(EditPartViewer viewer) {
        boolean change;
        GefRecordingHelper.GraphicalViewerEntry entry = GefRecordingHelper.getGraphicalViewerEntries().get(viewer);
        SWTEventRecorder eventRecorder = this.gefEventRecorder.getEventRecorder();
        SWTUIPlayer player = eventRecorder.getPlayer();
        if (entry != null && (change = this.gefEventRecorder.getEventRecorder().getLocator().checkParentsTextFieldChange(entry.lowerParent, true))) {
            GefRecordingHelper.getGraphicalViewerEntries().remove(viewer);
            entry = null;
        }
        if (entry == null) {
            entry = new GefRecordingHelper.GraphicalViewerEntry();
            Control control = viewer.getControl();
            SWTUIElement semanticParent = player.getParentElement(player.wrap((Object)control));
            FindResult semanticParentElement = eventRecorder.getLocator().findElement(semanticParent, false, false, true);
            if (semanticParent != null && semanticParentElement != null && semanticParentElement.element != null) {
                CompositeUIElement parentElement = new CompositeUIElement(semanticParentElement.element, (UIPlayer)this.gefEventRecorder.getRecorder());
                DiagramViewerUIElement diagramViewer = null;
                BasicRecordingHelper.ElementEntry element = GefRecordingHelper.getHelper().get(viewer);
                if (element != null) {
                    diagramViewer = new DiagramViewerUIElement(element.getElement(), (UIPlayer)this.gefEventRecorder.getRecorder());
                } else {
                    this.gefEventRecorder.getRecorder().setControls(new Widget[]{SWTModelMapper.map((SWTUIElement)semanticParentElement.realElement)});
                    if (viewer instanceof PaletteViewer) {
                        diagramViewer = parentElement.paletteViewer();
                    } else {
                        Integer index = null;
                        SWTUIElement[] allCanvases = player.children.collectFor(semanticParent, null, true, new Class[]{FigureCanvas.class, Canvas.class});
                        if (allCanvases != null) {
                            int ind = 0;
                            int i = 0;
                            while (i < allCanvases.length) {
                                GraphicalViewer vv;
                                org.eclipse.swt.widgets.Widget widget = (org.eclipse.swt.widgets.Widget)PlayerWrapUtils.unwrap((SWTUIElement)allCanvases[i]);
                                if (widget instanceof FigureCanvas || (vv = (GraphicalViewer)TeslaSWTAccess.getThis(GraphicalViewer.class, (org.eclipse.swt.widgets.Widget)widget, (int)12)) != null) {
                                    if (widget == viewer.getControl()) {
                                        index = ind;
                                        break;
                                    }
                                    ++ind;
                                }
                                ++i;
                            }
                        }
                        if (index == 0) {
                            index = null;
                        }
                        diagramViewer = parentElement.diagramViewer(index);
                    }
                    if (diagramViewer != null) {
                        GefRecordingHelper.getHelper().put(viewer, new BasicRecordingHelper.ElementEntry(diagramViewer.getElement()));
                    }
                }
                entry.diagramViewer = diagramViewer;
                entry.lowerParent = semanticParent;
                if (diagramViewer != null) {
                    GefRecordingHelper.getGraphicalViewerEntries().put(viewer, entry);
                }
            }
        }
        if (entry.diagramViewer != null) {
            return entry;
        }
        return null;
    }

    public FigureUIElement find(EditPart part, EditPartViewer viewer, DiagramViewerUIElement diagramViewer, boolean fromAssert) {
        if (part == null) {
            return null;
        }
        if (viewer.getRootEditPart().equals(part)) {
            return diagramViewer;
        }
        EditPart parent = part.getParent();
        FigureUIElement parentPart = this.find(parent, viewer, diagramViewer, fromAssert);
        List children = parent.getChildren();
        int index = children.indexOf(part);
        BasicRecordingHelper.ElementEntry el = GefRecordingHelper.getHelper().get(part);
        TeslaRecorder recorder = this.gefEventRecorder.getRecorder();
        if (el != null) {
            BasicRecordingHelper.ElementEntry newElement = this.findElement((GraphicalEditPart)part, children, parentPart, index, false, viewer, diagramViewer, fromAssert);
            if (newElement != null && !newElement.matchAttributes(el)) {
                el = null;
                GefRecordingHelper.getHelper().remove(part);
                GefRecordingHelper.getHelper().clearAllWithParent(part);
            } else if (!fromAssert) {
                return new FigureUIElement(el.getElement(), (UIPlayer)recorder);
            }
        }
        this.mapModel(part, viewer, recorder, true);
        BasicRecordingHelper.ElementEntry elementEntry = this.findElement((GraphicalEditPart)part, children, parentPart, index, true, viewer, diagramViewer, fromAssert);
        GefRecordingHelper.getHelper().put(part, elementEntry);
        return new FigureUIElement(elementEntry.getElement(), (UIPlayer)this.gefEventRecorder.getRecorder());
    }

    private BasicRecordingHelper.ElementEntry findElement(GraphicalEditPart part, List<?> children, FigureUIElement parentPart, int index, boolean needCreateElement, EditPartViewer viewer, DiagramViewerUIElement diagramViewer, boolean fromAssert) {
        Integer partIndex;
        Widget first;
        String text;
        Object model;
        FigureUIElement element = null;
        BasicRecordingHelper.ElementEntry result = null;
        if (TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.protocol.diagram.palette.entry") && TeslaGefAccess.isPalleteEditPart((EditPart)part) && (model = part.getModel()) != null && model instanceof PaletteEntry) {
            Integer indexPos;
            PaletteEntry entry = (PaletteEntry)model;
            String label = entry.getLabel();
            Integer n = indexPos = label == null ? null : this.calculatePaletteEntryIndex(label, entry);
            element = needCreateElement ? (indexPos == null ? diagramViewer.paletteEntry(label) : diagramViewer.paletteEntry(label, indexPos.intValue())) : new FigureUIElement(null, null);
            result = new BasicRecordingHelper.ElementEntry(element.getElement());
            result.set("name", (Object)label);
        }
        if (element == null && part instanceof ConnectionEditPart) {
            EditPart target;
            ConnectionEditPart connection = (ConnectionEditPart)part;
            EditPart source = connection.getSource();
            if (source != null && source instanceof GraphicalEditPart) {
                GraphicalEditPart sourcePart = (GraphicalEditPart)source;
                FigureUIElement sourceElement = this.find((EditPart)sourcePart, viewer, diagramViewer, fromAssert);
                List list = sourcePart.getSourceConnections();
                int sourceIndex = list.indexOf(part);
                if (needCreateElement) {
                    this.mapModel((EditPart)part, viewer, this.gefEventRecorder.getRecorder(), true);
                    element = sourceElement.figureSourceConnection(sourceIndex);
                } else {
                    element = new FigureUIElement(null, null);
                }
                result = new BasicRecordingHelper.ElementEntry(element.getElement());
                result.set("index", (Object)sourceIndex);
            }
            if ((target = connection.getTarget()) != null && target instanceof GraphicalEditPart) {
                GraphicalEditPart targetPart = (GraphicalEditPart)target;
                FigureUIElement targetElement = this.find((EditPart)targetPart, viewer, diagramViewer, fromAssert);
                List list = targetPart.getTargetConnections();
                int targetIndex = list.indexOf(part);
                if (needCreateElement) {
                    this.mapModel((EditPart)part, viewer, this.gefEventRecorder.getRecorder(), true);
                    element = targetElement.figureTargetConnection(targetIndex);
                } else {
                    element = new FigureUIElement(null, null);
                }
                result = new BasicRecordingHelper.ElementEntry(element.getElement());
                result.set("index", (Object)targetIndex);
            }
        }
        if (element == null && (TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.protocol.diagram.part.locator.name.feature.support") || TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.protocol.diagram.part.locator.feature.identity.support"))) {
            String[] identity;
            ArrayList<String> ids = new ArrayList<String>();
            String[] list = identity = TeslaFeatures.getInstance().getValue("org.eclipse.rcptt.tesla.protocol.diagram.part.locator.feature.identity.names").split(",");
            int targetElement = identity.length;
            int targetPart = 0;
            while (targetPart < targetElement) {
                String s = list[targetPart];
                if (!ids.contains(s)) {
                    ids.add(s);
                }
                ++targetPart;
            }
            EObject modelObject = this.getModelObject((EditPart)part);
            if (modelObject != null && this.checkChildrenNotContain(children, (EditPart)part, modelObject)) {
                EClass eClass = modelObject.eClass();
                EList attributes = eClass.getEAllAttributes();
                for (EAttribute eAttribute : attributes) {
                    Object value;
                    if (TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.protocol.diagram.part.locator.name.feature.support") && eAttribute.getName().equalsIgnoreCase("name") && (value = modelObject.eGet((EStructuralFeature)eAttribute)) != null && value instanceof String) {
                        Integer indexValue = this.getEMFFeatureIndex((EditPart)part, children, (String)value, eAttribute.getName());
                        element = needCreateElement ? parentPart.figureByName((String)value, indexValue) : new FigureUIElement(null, null);
                        result = new BasicRecordingHelper.ElementEntry(element.getElement());
                        result.set("emf.name", value);
                        break;
                    }
                    if (!TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.protocol.diagram.part.locator.feature.identity.support") || !ids.contains(eAttribute.getName()) || (value = modelObject.eGet((EStructuralFeature)eAttribute)) == null || !(value instanceof String)) continue;
                    Integer indexValue = this.getEMFFeatureIndex((EditPart)part, children, (String)value, eAttribute.getName());
                    element = needCreateElement ? parentPart.figureByFeature(eAttribute.getName(), (String)value, indexValue) : new FigureUIElement(null, null);
                    result = new BasicRecordingHelper.ElementEntry(element.getElement());
                    result.set("feature.name", (Object)eAttribute.getName());
                    result.set("feature.value", value);
                    break;
                }
            }
        }
        if (element == null && TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.protocol.diagram.part.locator.text.support") && !viewer.getRootEditPart().equals(part) && !viewer.getContents().equals(part) && (text = GefProcessor.getPartText((Widget)(first = this.mapModel((EditPart)part, viewer, this.gefEventRecorder.getRecorder(), false)))) != null) {
            partIndex = this.calcPartTextIndex((EditPart)part, text);
            element = needCreateElement ? parentPart.figureByText(text, partIndex) : new FigureUIElement(null, null);
            result = new BasicRecordingHelper.ElementEntry(element.getElement());
            result.set("text", (Object)text);
        }
        if (element == null && TeslaFeatures.isIdentifyMethodsProvided()) {
            try {
                String id = IdentifyObjectUtil.getObjectIdByClassMethods((Object)part);
                if (id != null) {
                    element = needCreateElement ? parentPart.figureByCustomId(id) : new FigureUIElement(null, null);
                    result = new BasicRecordingHelper.ElementEntry(element.getElement());
                    result.set("customId", (Object)id);
                }
            }
            catch (CoreException id) {
                // empty catch block
            }
        }
        if (element == null) {
            String method = TeslaFeatures.getInstance().getValue("org.eclipse.rcptt.tesla.protocol.diagram.part.locator.identity");
            switch (DiagramFeatures.PartIdentity.valueOf((String)method)) {
                case Address: {
                    break;
                }
                case ClassName: {
                    String className = this.getPartClassName((EditPart)part);
                    partIndex = this.calcPartClassNameIndex((EditPart)part, className);
                    element = needCreateElement ? parentPart.figureByClassName(className, partIndex) : new FigureUIElement(null, null);
                    result = new BasicRecordingHelper.ElementEntry(element.getElement());
                    result.set("classname", (Object)className);
                }
            }
        }
        if (element == null) {
            element = needCreateElement ? parentPart.figure(new Integer[]{index}) : new FigureUIElement(null, null);
            result = new BasicRecordingHelper.ElementEntry(element.getElement());
            result.set("index", (Object)Integer.toString(index));
        }
        return result;
    }

    private Integer calculatePaletteEntryIndex(String label, PaletteEntry entry) {
        PaletteEntry parent = entry;
        PaletteContainer pp = parent.getParent();
        while (pp != null) {
            parent = pp;
            pp = pp.getParent();
        }
        if (!(parent instanceof PaletteContainer)) {
            return null;
        }
        ArrayList entries = new ArrayList();
        GefProcessor.fillPaletteEntries(entries, (PaletteContainer)((PaletteContainer)parent));
        int index = 0;
        String entryLabel = entry.getLabel();
        for (PaletteEntry paletteEntry : entries) {
            if (paletteEntry.equals(entry)) {
                return index == 0 ? null : Integer.valueOf(index);
            }
            String eLabel = paletteEntry.getLabel();
            if (!eLabel.equals(entryLabel)) continue;
            ++index;
        }
        return null;
    }

    private Integer getEMFFeatureIndex(EditPart part, List<?> children, String recordedName, String name) {
        int index = 0;
        for (Object object : children) {
            String oName;
            EObject modelObject;
            if (part.equals(object)) break;
            if (!(object instanceof EditPart) || (modelObject = this.getModelObject((EditPart)object)) == null || !recordedName.equals(oName = GefProcessor.getPartEMFName((EObject)modelObject, (String)name, (boolean)false))) continue;
            ++index;
        }
        return index == 0 ? null : Integer.valueOf(index);
    }

    private Integer calcPartClassNameIndex(EditPart part, String className) {
        EditPart parent = part.getParent();
        List children = parent.getChildren();
        int index = 0;
        for (Object object : children) {
            String partName;
            if (part.equals(object)) break;
            if (!(object instanceof EditPart) || !(partName = this.getPartClassName((EditPart)object)).equals(className)) continue;
            ++index;
        }
        return index == 0 ? null : Integer.valueOf(index);
    }

    private Integer calcPartTextIndex(EditPart part, String textValue) {
        EditPart parent = part.getParent();
        List children = parent.getChildren();
        int index = 0;
        for (Object object : children) {
            Widget objectModel;
            String partName;
            if (part.equals(object)) {
                this.mapModel((EditPart)object, part.getViewer(), this.gefEventRecorder.getRecorder(), false);
                break;
            }
            if (!(object instanceof EditPart) || (partName = GefProcessor.getPartText((Widget)(objectModel = this.mapModel((EditPart)object, part.getViewer(), this.gefEventRecorder.getRecorder(), false)))) == null || !partName.equals(textValue)) continue;
            ++index;
        }
        return index == 0 ? null : Integer.valueOf(index);
    }

    private String getPartClassName(EditPart part) {
        return GefProcessor.getPartClassName((EditPart)part);
    }

    private boolean checkChildrenNotContain(List children, EditPart part, EObject modelObject) {
        for (Object o : children) {
            EObject eObject;
            if (!(o instanceof EditPart) || part.equals(o) || !modelObject.equals(eObject = this.getModelObject((EditPart)o))) continue;
            return false;
        }
        return true;
    }

    private EObject getModelObject(EditPart part) {
        IGMFRecordingProcessor[] helpers = this.gefEventRecorder.getHelpers();
        Object model = part.getModel();
        EObject modelObject = null;
        if (model != null && model instanceof EObject) {
            modelObject = (EObject)model;
        }
        IGMFRecordingProcessor[] iGMFRecordingProcessorArray = helpers;
        int n = helpers.length;
        int n2 = 0;
        while (n2 < n) {
            IGMFRecordingProcessor helper = iGMFRecordingProcessorArray[n2];
            EObject emfModel = helper.getEMFMode(part);
            if (emfModel != null) {
                modelObject = emfModel;
            }
            ++n2;
        }
        return modelObject;
    }

    private FigureUIElement findConnectionPart(ConnectionEditPart part, EditPartViewer viewer, DiagramViewerUIElement diagramViewer, TeslaRecorder recorder) {
        ConnectionEditPart connection = part;
        EditPart source = connection.getSource();
        if (source != null && source instanceof GraphicalEditPart) {
            GraphicalEditPart sourcePart = (GraphicalEditPart)source;
            FigureUIElement sourceElement = this.find((EditPart)sourcePart, viewer, diagramViewer, false);
            List list = sourcePart.getSourceConnections();
            int sourceIndex = list.indexOf(part);
            this.mapModel((EditPart)part, viewer, recorder, true);
            FigureUIElement figureSourceConnection = sourceElement.figureSourceConnection(sourceIndex);
            BasicRecordingHelper.ElementEntry elementEntry = new BasicRecordingHelper.ElementEntry(figureSourceConnection.getElement());
            GefRecordingHelper.getHelper().put(part, elementEntry);
            return figureSourceConnection;
        }
        EditPart target = connection.getTarget();
        if (target != null && target instanceof GraphicalEditPart) {
            GraphicalEditPart targetPart = (GraphicalEditPart)target;
            FigureUIElement targetElement = this.find((EditPart)targetPart, viewer, diagramViewer, false);
            List list = targetPart.getTargetConnections();
            int targetIndex = list.indexOf(part);
            this.mapModel((EditPart)part, viewer, recorder, true);
            FigureUIElement figureTargetConnection = targetElement.figureTargetConnection(targetIndex);
            BasicRecordingHelper.ElementEntry elementEntry = new BasicRecordingHelper.ElementEntry(figureTargetConnection.getElement());
            GefRecordingHelper.getHelper().put(part, elementEntry);
            return figureTargetConnection;
        }
        return null;
    }

    private Widget mapModel(EditPart part, EditPartViewer viewer, TeslaRecorder recorder, boolean updateRecorder) {
        Widget model = null;
        List processors = recorder.getProcessors(IGMFRecordingProcessor.class);
        SWTUIPlayer player = this.gefEventRecorder.getEventRecorder().getPlayer();
        SWTUIElement semanticParent = player.getParentElement(player.wrap((Object)viewer.getControl()));
        if (semanticParent instanceof WorkbenchUIElement) {
            DiagramItem map = GefModelMapper.basicMap((EditPart)part);
            if (PropertySourceBasedModelMapper.map((IWorkbenchPart)((WorkbenchUIElement)semanticParent).reference.getPart(true), (Object)part, (DiagramItem)map)) {
                model = map;
            }
        }
        if (model == null) {
            for (IGMFRecordingProcessor helper : processors) {
                model = helper.getModel(part);
            }
        }
        if (model == null) {
            model = GefModelMapper.map((EditPart)part, (SWTUIPlayer)((SWTEventRecorder)recorder.getProcessor(SWTEventRecorder.class)).getPlayer());
        }
        recorder.setControls(new Widget[]{model});
        return model;
    }

    public PropertyNodeList getNodeProperties(EditPart part, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyNodeList nodeList;
        EditPartViewer viewer = part.getViewer();
        SWTUIPlayer player = this.gefEventRecorder.getEventRecorder().getPlayer();
        SWTUIElement semanticParent = player.getParentElement(player.wrap((Object)viewer.getControl()));
        if (semanticParent instanceof WorkbenchUIElement && PropertySourceBasedModelMapper.isPropertyBasedMapped((IWorkbenchPart)((WorkbenchUIElement)semanticParent).reference.getPart(true), (Object)part) && (nodeList = PropertySourceBasedModelMapper.getPropertyNodes((IWorkbenchPart)((WorkbenchUIElement)semanticParent).reference.getPart(true), (Object)part, (String)nodePath)) != null) {
            return nodeList;
        }
        List processors = TeslaRecorder.getInstance().getProcessors(IGMFRecordingProcessor.class);
        for (IGMFRecordingProcessor helper : processors) {
            if (!helper.isGMFMapped(part)) continue;
            return helper.getNodeProperties(part, nodePath);
        }
        return GefModelMapper.getPropertyNodes((EditPart)part, (String)nodePath);
    }
}

