/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core;

import java.util.List;
import org.eclipse.rcptt.tesla.core.TeslaScenarioContainer;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandTransferKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawEvent;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.internal.core.SimpleCommandPrinter;
import org.eclipse.rcptt.tesla.recording.core.ITeslaRecordingListener;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;

public class TeslaCapturer
implements ITeslaRecordingListener {
    private TeslaScenarioContainer container = new TeslaScenarioContainer();
    private boolean printingEnabled = false;

    public void enable() {
        TeslaRecorder.getInstance().addListener(this);
    }

    public void disable() {
        TeslaRecorder.getInstance().removeListener(this);
    }

    @Override
    public void recordCommand(Command command, List<Element> elements, CommandTransferKind kind, List<Widget> controls, int index, List<RawEvent> rawEvents) {
        if (command != null) {
            this.container.processTransfer(command, elements, kind, controls, index, rawEvents);
            if (this.printingEnabled) {
                System.out.println(SimpleCommandPrinter.toString((Command)command));
            }
        }
    }

    public void enablePrints() {
        this.printingEnabled = true;
    }
}

