/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching;

import com.google.common.base.Throwables;
import java.util.function.Consumer;
import java.util.function.Function;

public final class CheckedExceptionWrapper
extends RuntimeException {
    private static final long serialVersionUID = -2641861448641156035L;

    public CheckedExceptionWrapper(Exception e) {
        super(e);
    }

    public static Runnable wrap(ThrowingRunnable throwing) {
        return () -> {
            try {
                throwing.run();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new CheckedExceptionWrapper(e);
            }
        };
    }

    public static <T> Consumer<T> wrap(ThrowingConsumer<T> throwing) {
        return t -> {
            try {
                throwing.accept(t);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new CheckedExceptionWrapper(e);
            }
        };
    }

    public static <T, R> Function<T, R> wrap(ThrowingFunction<T, R> throwing) {
        return t -> {
            try {
                return throwing.apply(t);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new CheckedExceptionWrapper(e);
            }
        };
    }

    public <E extends Exception> void rethrow(Class<E> clazz) throws E {
        Throwables.throwIfInstanceOf((Throwable)this.getCause(), clazz);
    }

    public void rethrowUnchecked() {
        Throwables.throwIfUnchecked((Throwable)this.getCause());
    }

    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

