/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.util.Locale;
import java.util.Set;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Show
extends ConsoleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(Show.class);
    private static final String OUTPUT_SEPARATOR = "+----------";

    @Override
    public String getName() {
        return "show";
    }

    @Override
    public String getHelpShort() {
        return "Displays an overview of various resources";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nshow {r, repositories}   Shows all available repositories\nshow {n, namespaces}     Shows all namespaces\nshow {c, contexts}       Shows all context identifiers\n";
    }

    public Show(ConsoleIO consoleIO, ConsoleState state) {
        super(consoleIO, state);
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length == 2) {
            String target = tokens[1].toLowerCase(Locale.ENGLISH);
            if ("repositories".equals(target) || "r".equals(target)) {
                this.showRepositories();
            } else if ("namespaces".equals(target) || "n".equals(target)) {
                this.showNamespaces();
            } else if ("contexts".equals(target) || "c".equals(target)) {
                this.showContexts();
            } else {
                this.consoleIO.writeError("Unknown target '" + tokens[1] + "'");
            }
        } else {
            this.consoleIO.writeln(this.getHelpLong());
        }
    }

    private void showRepositories() {
        block7: {
            try {
                RepositoryManager manager = this.state.getManager();
                Set<String> repIDs = manager.getRepositoryIDs();
                if (repIDs.isEmpty()) {
                    this.consoleIO.writeln("--no repositories found--");
                    break block7;
                }
                this.consoleIO.writeln(OUTPUT_SEPARATOR);
                for (String repID : repIDs) {
                    this.consoleIO.write("|" + repID);
                    try {
                        RepositoryInfo repInfo = manager.getRepositoryInfo(repID);
                        if (repInfo.getDescription() != null) {
                            this.consoleIO.write(" (\"" + repInfo.getDescription() + "\")");
                        }
                    }
                    catch (RepositoryException e) {
                        this.consoleIO.write(" [ERROR: " + e.getMessage() + "]");
                    }
                    this.consoleIO.writeln();
                }
                this.consoleIO.writeln(OUTPUT_SEPARATOR);
            }
            catch (RepositoryException e) {
                this.consoleIO.writeError("Failed to get repository list: " + e.getMessage());
                LOGGER.error("Failed to get repository list", (Throwable)e);
            }
        }
    }

    private void showNamespaces() {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        try (RepositoryConnection con = repository.getConnection();
             RepositoryResult<Namespace> namespaces = con.getNamespaces();){
            if (namespaces.hasNext()) {
                this.consoleIO.writeln(OUTPUT_SEPARATOR);
                while (namespaces.hasNext()) {
                    Namespace namespace = (Namespace)namespaces.next();
                    this.consoleIO.writeln("|" + namespace.getPrefix() + "  " + namespace.getName());
                }
                this.consoleIO.writeln(OUTPUT_SEPARATOR);
            } else {
                this.consoleIO.writeln("--no namespaces found--");
            }
        }
        catch (RepositoryException e) {
            this.consoleIO.writeError(e.getMessage());
            LOGGER.error("Failed to show namespaces", (Throwable)e);
        }
    }

    private void showContexts() {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        try (RepositoryConnection con = repository.getConnection();
             RepositoryResult<Resource> contexts = con.getContextIDs();){
            if (contexts.hasNext()) {
                this.consoleIO.writeln(OUTPUT_SEPARATOR);
                while (contexts.hasNext()) {
                    this.consoleIO.writeln("|" + ((Resource)contexts.next()).toString());
                }
                this.consoleIO.writeln(OUTPUT_SEPARATOR);
            } else {
                this.consoleIO.writeln("--no contexts found--");
            }
        }
        catch (RepositoryException e) {
            this.consoleIO.writeError(e.getMessage());
            LOGGER.error("Failed to show contexts", (Throwable)e);
        }
    }
}

